/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "email", "firstName", "lastName", "password", "workspaceId", "role"})
@JsonTypeName(value="user_update_request")
public class UserUpdateRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_WORKSPACE_ID = "workspaceId";
    private String workspaceId;
    public static final String JSON_PROPERTY_ROLE = "role";
    private RoleEnum role;

    public UserUpdateRequest id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="provide current or updated ID of the user")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(UUID id) {
        this.id = id;
    }

    public UserUpdateRequest email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="provide current or updated email of the user")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public UserUpdateRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="the current or updated first name of the user")
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UserUpdateRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="the current or updated last name of the user")
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UserUpdateRequest password(String password) {
        this.password = password;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="the current or updated authentication password of the user")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPassword(String password) {
        this.password = password;
    }

    public UserUpdateRequest workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the current or updated workspaceId the user can access")
    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public UserUpdateRequest role(RoleEnum role) {
        this.role = role;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the current or updated workspace role for the user")
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoleEnum getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserUpdateRequest userUpdateRequest = (UserUpdateRequest)o;
        return Objects.equals(this.id, userUpdateRequest.id) && Objects.equals(this.email, userUpdateRequest.email) && Objects.equals(this.firstName, userUpdateRequest.firstName) && Objects.equals(this.lastName, userUpdateRequest.lastName) && Objects.equals(this.password, userUpdateRequest.password) && Objects.equals(this.workspaceId, userUpdateRequest.workspaceId) && Objects.equals((Object)this.role, (Object)userUpdateRequest.role);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.email, this.firstName, this.lastName, this.password, this.workspaceId, this.role});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserUpdateRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RoleEnum {
        MEMBER("member"),
        ADMIN("admin");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

