/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "resourceId", "resourceType", "recipientUserId", "status", "userId"})
@JsonTypeName(value="TransferResourceRequest")
public class TransferResourceRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
    private UUID resourceId;
    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    private ResourceTypeEnum resourceType;
    public static final String JSON_PROPERTY_RECIPIENT_USER_ID = "recipientUserId";
    private UUID recipientUserId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.PENDING;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private UUID userId;

    public TransferResourceRequest id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The transfer resource request ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(UUID id) {
        this.id = id;
    }

    public TransferResourceRequest resourceId(UUID resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the resource being transferred")
    @JsonProperty(value="resourceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getResourceId() {
        return this.resourceId;
    }

    @JsonProperty(value="resourceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceId(UUID resourceId) {
        this.resourceId = resourceId;
    }

    public TransferResourceRequest resourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of resource being transferred")
    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public TransferResourceRequest recipientUserId(UUID recipientUserId) {
        this.recipientUserId = recipientUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the user receiving the resource")
    @JsonProperty(value="recipientUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getRecipientUserId() {
        return this.recipientUserId;
    }

    @JsonProperty(value="recipientUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecipientUserId(UUID recipientUserId) {
        this.recipientUserId = recipientUserId;
    }

    public TransferResourceRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The current status of the transfer request")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TransferResourceRequest userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the user making the transfer request")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferResourceRequest transferResourceRequest = (TransferResourceRequest)o;
        return Objects.equals(this.id, transferResourceRequest.id) && Objects.equals(this.resourceId, transferResourceRequest.resourceId) && Objects.equals((Object)this.resourceType, (Object)transferResourceRequest.resourceType) && Objects.equals(this.recipientUserId, transferResourceRequest.recipientUserId) && Objects.equals((Object)this.status, (Object)transferResourceRequest.status) && Objects.equals(this.userId, transferResourceRequest.userId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.resourceId, this.resourceType, this.recipientUserId, this.status, this.userId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferResourceRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    recipientUserId: ").append(this.toIndentedString(this.recipientUserId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACCEPTED("accepted"),
        DECLINED("declined"),
        PENDING("pending"),
        REVOKED("revoked");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ResourceTypeEnum {
        APPLICATIONS("applications"),
        DATASETS("datasets"),
        GROUPS("groups"),
        WORKSPACES("workspaces");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResourceTypeEnum fromValue(String value) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

