/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"datasetId", "batchSize", "startingRecordId", "credentialsSubset"})
@JsonTypeName(value="SequenceReadRequest")
public class SequenceReadRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private String datasetId;
    public static final String JSON_PROPERTY_BATCH_SIZE = "batchSize";
    private Integer batchSize;
    public static final String JSON_PROPERTY_STARTING_RECORD_ID = "startingRecordId";
    private String startingRecordId;
    public static final String JSON_PROPERTY_CREDENTIALS_SUBSET = "credentialsSubset";
    private List<String> credentialsSubset = null;

    public SequenceReadRequest datasetId(String datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0fc3f37a-6e55-4879-b085-c541859ab456", value="ID of the dataset (uuid)")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public SequenceReadRequest batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum number of records that should be included in this batch")
    @JsonProperty(value="batchSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public SequenceReadRequest startingRecordId(String startingRecordId) {
        this.startingRecordId = startingRecordId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the record that will be the start of the range for the read request")
    @JsonProperty(value="startingRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartingRecordId() {
        return this.startingRecordId;
    }

    @JsonProperty(value="startingRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartingRecordId(String startingRecordId) {
        this.startingRecordId = startingRecordId;
    }

    public SequenceReadRequest credentialsSubset(List<String> credentialsSubset) {
        this.credentialsSubset = credentialsSubset;
        return this;
    }

    public SequenceReadRequest addCredentialsSubsetItem(String credentialsSubsetItem) {
        if (this.credentialsSubset == null) {
            this.credentialsSubset = new ArrayList<String>();
        }
        this.credentialsSubset.add(credentialsSubsetItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of credentials that can be provided to return records of a more limited subset than that of the authenticated caller")
    @JsonProperty(value="credentialsSubset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCredentialsSubset() {
        return this.credentialsSubset;
    }

    @JsonProperty(value="credentialsSubset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentialsSubset(List<String> credentialsSubset) {
        this.credentialsSubset = credentialsSubset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceReadRequest sequenceReadRequest = (SequenceReadRequest)o;
        return Objects.equals(this.datasetId, sequenceReadRequest.datasetId) && Objects.equals(this.batchSize, sequenceReadRequest.batchSize) && Objects.equals(this.startingRecordId, sequenceReadRequest.startingRecordId) && Objects.equals(this.credentialsSubset, sequenceReadRequest.credentialsSubset);
    }

    public int hashCode() {
        return Objects.hash(this.datasetId, this.batchSize, this.startingRecordId, this.credentialsSubset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SequenceReadRequest {\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    batchSize: ").append(this.toIndentedString(this.batchSize)).append("\n");
        sb.append("    startingRecordId: ").append(this.toIndentedString(this.startingRecordId)).append("\n");
        sb.append("    credentialsSubset: ").append(this.toIndentedString(this.credentialsSubset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

