/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "config", "stage", "status", "error", "datasetId", "workspaceId", "jobId", "processedBy", "uploadId"})
@JsonTypeName(value="Segment")
public class Segment
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private Object config;
    public static final String JSON_PROPERTY_STAGE = "stage";
    private BigDecimal stage;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_ERROR = "error";
    private Object error;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private UUID datasetId;
    public static final String JSON_PROPERTY_WORKSPACE_ID = "workspaceId";
    private String workspaceId;
    public static final String JSON_PROPERTY_JOB_ID = "jobId";
    private UUID jobId;
    public static final String JSON_PROPERTY_PROCESSED_BY = "processedBy";
    private String processedBy;
    public static final String JSON_PROPERTY_UPLOAD_ID = "uploadId";
    private UUID uploadId;

    public Segment id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="segment ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(UUID id) {
        this.id = id;
    }

    public Segment config(Object config) {
        this.config = config;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="segment config")
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfig(Object config) {
        this.config = config;
    }

    public Segment stage(BigDecimal stage) {
        this.stage = stage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="segment stage number")
    @JsonProperty(value="stage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getStage() {
        return this.stage;
    }

    @JsonProperty(value="stage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStage(BigDecimal stage) {
        this.stage = stage;
    }

    public Segment status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="segment status")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Segment error(Object error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="segment error")
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(Object error) {
        this.error = error;
    }

    public Segment datasetId(UUID datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="dataset ID")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDatasetId(UUID datasetId) {
        this.datasetId = datasetId;
    }

    public Segment workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="workspace ID")
    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public Segment jobId(UUID jobId) {
        this.jobId = jobId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="job ID")
    @JsonProperty(value="jobId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="jobId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setJobId(UUID jobId) {
        this.jobId = jobId;
    }

    public Segment processedBy(String processedBy) {
        this.processedBy = processedBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="service that processed the segment")
    @JsonProperty(value="processedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessedBy() {
        return this.processedBy;
    }

    @JsonProperty(value="processedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessedBy(String processedBy) {
        this.processedBy = processedBy;
    }

    public Segment uploadId(UUID uploadId) {
        this.uploadId = uploadId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="upload ID")
    @JsonProperty(value="uploadId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getUploadId() {
        return this.uploadId;
    }

    @JsonProperty(value="uploadId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUploadId(UUID uploadId) {
        this.uploadId = uploadId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        return Objects.equals(this.id, segment.id) && Objects.equals(this.config, segment.config) && Objects.equals(this.stage, segment.stage) && Objects.equals((Object)this.status, (Object)segment.status) && Objects.equals(this.error, segment.error) && Objects.equals(this.datasetId, segment.datasetId) && Objects.equals(this.workspaceId, segment.workspaceId) && Objects.equals(this.jobId, segment.jobId) && Objects.equals(this.processedBy, segment.processedBy) && Objects.equals(this.uploadId, segment.uploadId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.config, this.stage, this.status, this.error, this.datasetId, this.workspaceId, this.jobId, this.processedBy, this.uploadId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Segment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    stage: ").append(this.toIndentedString(this.stage)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    processedBy: ").append(this.toIndentedString(this.processedBy)).append("\n");
        sb.append("    uploadId: ").append(this.toIndentedString(this.uploadId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        QUEUED("queued"),
        RUNNING("running"),
        COMPLETED("completed"),
        CANCELED("canceled"),
        FAILED("failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

