/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.koverse.kdpapi.client.model.Index;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"datasetId", "created", "deleted", "searchAnyFieldChanged"})
@JsonTypeName(value="ReindexRequest")
public class ReindexRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private UUID datasetId;
    public static final String JSON_PROPERTY_CREATED = "created";
    private List<Index> created = null;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    private List<Index> deleted = null;
    public static final String JSON_PROPERTY_SEARCH_ANY_FIELD_CHANGED = "searchAnyFieldChanged";
    private Boolean searchAnyFieldChanged;

    public ReindexRequest datasetId(UUID datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0fc3f37a-6e55-4879-b085-c541859ab456", required=true, value="ID of the dataset (uuid)")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDatasetId(UUID datasetId) {
        this.datasetId = datasetId;
    }

    public ReindexRequest created(List<Index> created) {
        this.created = created;
        return this;
    }

    public ReindexRequest addCreatedItem(Index createdItem) {
        if (this.created == null) {
            this.created = new ArrayList<Index>();
        }
        this.created.add(createdItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Index> getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreated(List<Index> created) {
        this.created = created;
    }

    public ReindexRequest deleted(List<Index> deleted) {
        this.deleted = deleted;
        return this;
    }

    public ReindexRequest addDeletedItem(Index deletedItem) {
        if (this.deleted == null) {
            this.deleted = new ArrayList<Index>();
        }
        this.deleted.add(deletedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Index> getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeleted(List<Index> deleted) {
        this.deleted = deleted;
    }

    public ReindexRequest searchAnyFieldChanged(Boolean searchAnyFieldChanged) {
        this.searchAnyFieldChanged = searchAnyFieldChanged;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="searchAnyFieldChanged")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSearchAnyFieldChanged() {
        return this.searchAnyFieldChanged;
    }

    @JsonProperty(value="searchAnyFieldChanged")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchAnyFieldChanged(Boolean searchAnyFieldChanged) {
        this.searchAnyFieldChanged = searchAnyFieldChanged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReindexRequest reindexRequest = (ReindexRequest)o;
        return Objects.equals(this.datasetId, reindexRequest.datasetId) && Objects.equals(this.created, reindexRequest.created) && Objects.equals(this.deleted, reindexRequest.deleted) && Objects.equals(this.searchAnyFieldChanged, reindexRequest.searchAnyFieldChanged);
    }

    public int hashCode() {
        return Objects.hash(this.datasetId, this.created, this.deleted, this.searchAnyFieldChanged);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReindexRequest {\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    searchAnyFieldChanged: ").append(this.toIndentedString(this.searchAnyFieldChanged)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

