/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"datasetId", "startingRecordId", "endingRecordId", "excludeStartingRecordId", "includeInternalRecordId", "batchSize", "credentialsSubset"})
@JsonTypeName(value="ReadRangeRequest")
public class ReadRangeRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private String datasetId;
    public static final String JSON_PROPERTY_STARTING_RECORD_ID = "startingRecordId";
    private String startingRecordId;
    public static final String JSON_PROPERTY_ENDING_RECORD_ID = "endingRecordId";
    private String endingRecordId;
    public static final String JSON_PROPERTY_EXCLUDE_STARTING_RECORD_ID = "excludeStartingRecordId";
    private Boolean excludeStartingRecordId;
    public static final String JSON_PROPERTY_INCLUDE_INTERNAL_RECORD_ID = "includeInternalRecordId";
    private Boolean includeInternalRecordId;
    public static final String JSON_PROPERTY_BATCH_SIZE = "batchSize";
    private Integer batchSize;
    public static final String JSON_PROPERTY_CREDENTIALS_SUBSET = "credentialsSubset";
    private List<String> credentialsSubset = null;

    public ReadRangeRequest datasetId(String datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0fc3f37a-6e55-4879-b085-c541859ab456", value="ID of the dataset (uuid)")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public ReadRangeRequest startingRecordId(String startingRecordId) {
        this.startingRecordId = startingRecordId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the record that will be the start of the range for the read request")
    @JsonProperty(value="startingRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartingRecordId() {
        return this.startingRecordId;
    }

    @JsonProperty(value="startingRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartingRecordId(String startingRecordId) {
        this.startingRecordId = startingRecordId;
    }

    public ReadRangeRequest endingRecordId(String endingRecordId) {
        this.endingRecordId = endingRecordId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the record that will be the end of the range for the read request")
    @JsonProperty(value="endingRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndingRecordId() {
        return this.endingRecordId;
    }

    @JsonProperty(value="endingRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndingRecordId(String endingRecordId) {
        this.endingRecordId = endingRecordId;
    }

    public ReadRangeRequest excludeStartingRecordId(Boolean excludeStartingRecordId) {
        this.excludeStartingRecordId = excludeStartingRecordId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean that indicates if the first record should be included in the range of the read request")
    @JsonProperty(value="excludeStartingRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getExcludeStartingRecordId() {
        return this.excludeStartingRecordId;
    }

    @JsonProperty(value="excludeStartingRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcludeStartingRecordId(Boolean excludeStartingRecordId) {
        this.excludeStartingRecordId = excludeStartingRecordId;
    }

    public ReadRangeRequest includeInternalRecordId(Boolean includeInternalRecordId) {
        this.includeInternalRecordId = includeInternalRecordId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean that indicates if the Koverse Internal Record Id should be included")
    @JsonProperty(value="includeInternalRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeInternalRecordId() {
        return this.includeInternalRecordId;
    }

    @JsonProperty(value="includeInternalRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeInternalRecordId(Boolean includeInternalRecordId) {
        this.includeInternalRecordId = includeInternalRecordId;
    }

    public ReadRangeRequest batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum number of records that should be included in this batch")
    @JsonProperty(value="batchSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public ReadRangeRequest credentialsSubset(List<String> credentialsSubset) {
        this.credentialsSubset = credentialsSubset;
        return this;
    }

    public ReadRangeRequest addCredentialsSubsetItem(String credentialsSubsetItem) {
        if (this.credentialsSubset == null) {
            this.credentialsSubset = new ArrayList<String>();
        }
        this.credentialsSubset.add(credentialsSubsetItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of credentials that can be provided to return records of a more limited subset than that of the authenticated caller")
    @JsonProperty(value="credentialsSubset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCredentialsSubset() {
        return this.credentialsSubset;
    }

    @JsonProperty(value="credentialsSubset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentialsSubset(List<String> credentialsSubset) {
        this.credentialsSubset = credentialsSubset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadRangeRequest readRangeRequest = (ReadRangeRequest)o;
        return Objects.equals(this.datasetId, readRangeRequest.datasetId) && Objects.equals(this.startingRecordId, readRangeRequest.startingRecordId) && Objects.equals(this.endingRecordId, readRangeRequest.endingRecordId) && Objects.equals(this.excludeStartingRecordId, readRangeRequest.excludeStartingRecordId) && Objects.equals(this.includeInternalRecordId, readRangeRequest.includeInternalRecordId) && Objects.equals(this.batchSize, readRangeRequest.batchSize) && Objects.equals(this.credentialsSubset, readRangeRequest.credentialsSubset);
    }

    public int hashCode() {
        return Objects.hash(this.datasetId, this.startingRecordId, this.endingRecordId, this.excludeStartingRecordId, this.includeInternalRecordId, this.batchSize, this.credentialsSubset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadRangeRequest {\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    startingRecordId: ").append(this.toIndentedString(this.startingRecordId)).append("\n");
        sb.append("    endingRecordId: ").append(this.toIndentedString(this.endingRecordId)).append("\n");
        sb.append("    excludeStartingRecordId: ").append(this.toIndentedString(this.excludeStartingRecordId)).append("\n");
        sb.append("    includeInternalRecordId: ").append(this.toIndentedString(this.includeInternalRecordId)).append("\n");
        sb.append("    batchSize: ").append(this.toIndentedString(this.batchSize)).append("\n");
        sb.append("    credentialsSubset: ").append(this.toIndentedString(this.credentialsSubset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

