/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.koverse.kdpapi.client.model.QueryDocumentLuceneResponseRecords;
import com.koverse.kdpapi.client.model.SchemaField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A batch of records returned from the query")
@JsonPropertyOrder(value={"records", "schema", "total"})
@JsonTypeName(value="QueryDocumentLuceneResponse")
public class QueryDocumentLuceneResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_RECORDS = "records";
    private List<QueryDocumentLuceneResponseRecords> records = null;
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    private Map<String, SchemaField> schema = null;
    public static final String JSON_PROPERTY_TOTAL = "total";
    private Integer total;

    public QueryDocumentLuceneResponse records(List<QueryDocumentLuceneResponseRecords> records) {
        this.records = records;
        return this;
    }

    public QueryDocumentLuceneResponse addRecordsItem(QueryDocumentLuceneResponseRecords recordsItem) {
        if (this.records == null) {
            this.records = new ArrayList<QueryDocumentLuceneResponseRecords>();
        }
        this.records.add(recordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="records")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<QueryDocumentLuceneResponseRecords> getRecords() {
        return this.records;
    }

    @JsonProperty(value="records")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecords(List<QueryDocumentLuceneResponseRecords> records) {
        this.records = records;
    }

    public QueryDocumentLuceneResponse schema(Map<String, SchemaField> schema) {
        this.schema = schema;
        return this;
    }

    public QueryDocumentLuceneResponse putSchemaItem(String key, SchemaField schemaItem) {
        if (this.schema == null) {
            this.schema = new HashMap<String, SchemaField>();
        }
        this.schema.put(key, schemaItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The schema of the records returned in a batch")
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, SchemaField> getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchema(Map<String, SchemaField> schema) {
        this.schema = schema;
    }

    public QueryDocumentLuceneResponse total(Integer total) {
        this.total = total;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total count of all records the query can return, includes records even if they are not in the current batch result")
    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotal() {
        return this.total;
    }

    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotal(Integer total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryDocumentLuceneResponse queryDocumentLuceneResponse = (QueryDocumentLuceneResponse)o;
        return Objects.equals(this.records, queryDocumentLuceneResponse.records) && Objects.equals(this.schema, queryDocumentLuceneResponse.schema) && Objects.equals(this.total, queryDocumentLuceneResponse.total);
    }

    public int hashCode() {
        return Objects.hash(this.records, this.schema, this.total);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryDocumentLuceneResponse {\n");
        sb.append("    records: ").append(this.toIndentedString(this.records)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

