/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.koverse.kdpapi.client.model.QueryDatasetsSummaryDatasets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="A summary of datasets that contain matching records")
@JsonPropertyOrder(value={"datasets", "totalRecords", "totalDatasets", "searchId"})
@JsonTypeName(value="QueryDatasetsSummary")
public class QueryDatasetsSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DATASETS = "datasets";
    private List<QueryDatasetsSummaryDatasets> datasets = null;
    public static final String JSON_PROPERTY_TOTAL_RECORDS = "totalRecords";
    private Integer totalRecords;
    public static final String JSON_PROPERTY_TOTAL_DATASETS = "totalDatasets";
    private Integer totalDatasets;
    public static final String JSON_PROPERTY_SEARCH_ID = "searchId";
    private UUID searchId;

    public QueryDatasetsSummary datasets(List<QueryDatasetsSummaryDatasets> datasets) {
        this.datasets = datasets;
        return this;
    }

    public QueryDatasetsSummary addDatasetsItem(QueryDatasetsSummaryDatasets datasetsItem) {
        if (this.datasets == null) {
            this.datasets = new ArrayList<QueryDatasetsSummaryDatasets>();
        }
        this.datasets.add(datasetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of datasets that contain matching records, sorted by the number of matches.")
    @JsonProperty(value="datasets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<QueryDatasetsSummaryDatasets> getDatasets() {
        return this.datasets;
    }

    @JsonProperty(value="datasets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatasets(List<QueryDatasetsSummaryDatasets> datasets) {
        this.datasets = datasets;
    }

    public QueryDatasetsSummary totalRecords(Integer totalRecords) {
        this.totalRecords = totalRecords;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of records across all datasets that match the search term.")
    @JsonProperty(value="totalRecords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalRecords() {
        return this.totalRecords;
    }

    @JsonProperty(value="totalRecords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalRecords(Integer totalRecords) {
        this.totalRecords = totalRecords;
    }

    public QueryDatasetsSummary totalDatasets(Integer totalDatasets) {
        this.totalDatasets = totalDatasets;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total count of all datasets that contain matching records, includes datasets even if they are not in the current result")
    @JsonProperty(value="totalDatasets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalDatasets() {
        return this.totalDatasets;
    }

    @JsonProperty(value="totalDatasets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDatasets(Integer totalDatasets) {
        this.totalDatasets = totalDatasets;
    }

    public QueryDatasetsSummary searchId(UUID searchId) {
        this.searchId = searchId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The uuid asscoiated with this search request, used for paging through results.")
    @JsonProperty(value="searchId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getSearchId() {
        return this.searchId;
    }

    @JsonProperty(value="searchId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchId(UUID searchId) {
        this.searchId = searchId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryDatasetsSummary queryDatasetsSummary = (QueryDatasetsSummary)o;
        return Objects.equals(this.datasets, queryDatasetsSummary.datasets) && Objects.equals(this.totalRecords, queryDatasetsSummary.totalRecords) && Objects.equals(this.totalDatasets, queryDatasetsSummary.totalDatasets) && Objects.equals(this.searchId, queryDatasetsSummary.searchId);
    }

    public int hashCode() {
        return Objects.hash(this.datasets, this.totalRecords, this.totalDatasets, this.searchId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryDatasetsSummary {\n");
        sb.append("    datasets: ").append(this.toIndentedString(this.datasets)).append("\n");
        sb.append("    totalRecords: ").append(this.toIndentedString(this.totalRecords)).append("\n");
        sb.append("    totalDatasets: ").append(this.toIndentedString(this.totalDatasets)).append("\n");
        sb.append("    searchId: ").append(this.toIndentedString(this.searchId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

