/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.koverse.kdpapi.client.model.ConnectionInfo;
import com.koverse.kdpapi.client.model.SecurityLabelInfoParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains the configuration parameters for the datasource")
@JsonPropertyOrder(value={"type", "connectionInfo", "securityLabelInfo", "securityLabeled"})
@JsonTypeName(value="DataSourceParams")
public class DataSourceParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_CONNECTION_INFO = "connectionInfo";
    private ConnectionInfo connectionInfo;
    public static final String JSON_PROPERTY_SECURITY_LABEL_INFO = "securityLabelInfo";
    private SecurityLabelInfoParams securityLabelInfo;
    public static final String JSON_PROPERTY_SECURITY_LABELED = "securityLabeled";
    private Boolean securityLabeled;

    public DataSourceParams type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the datasource, see Enum for types")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DataSourceParams connectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="connectionInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @JsonProperty(value="connectionInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public DataSourceParams securityLabelInfo(SecurityLabelInfoParams securityLabelInfo) {
        this.securityLabelInfo = securityLabelInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="securityLabelInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityLabelInfoParams getSecurityLabelInfo() {
        return this.securityLabelInfo;
    }

    @JsonProperty(value="securityLabelInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityLabelInfo(SecurityLabelInfoParams securityLabelInfo) {
        this.securityLabelInfo = securityLabelInfo;
    }

    public DataSourceParams securityLabeled(Boolean securityLabeled) {
        this.securityLabeled = securityLabeled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set to `true` if the ingest source data contains security labels")
    @JsonProperty(value="securityLabeled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSecurityLabeled() {
        return this.securityLabeled;
    }

    @JsonProperty(value="securityLabeled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityLabeled(Boolean securityLabeled) {
        this.securityLabeled = securityLabeled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceParams dataSourceParams = (DataSourceParams)o;
        return Objects.equals((Object)this.type, (Object)dataSourceParams.type) && Objects.equals(this.connectionInfo, dataSourceParams.connectionInfo) && Objects.equals(this.securityLabelInfo, dataSourceParams.securityLabelInfo) && Objects.equals(this.securityLabeled, dataSourceParams.securityLabeled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.connectionInfo, this.securityLabelInfo, this.securityLabeled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataSourceParams {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    connectionInfo: ").append(this.toIndentedString(this.connectionInfo)).append("\n");
        sb.append("    securityLabelInfo: ").append(this.toIndentedString(this.securityLabelInfo)).append("\n");
        sb.append("    securityLabeled: ").append(this.toIndentedString(this.securityLabeled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        URL("URL"),
        JDBC("JDBC"),
        S3("S3"),
        KAFKA("KAFKA"),
        OTHER("OTHER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

