/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.koverse.kdpapi.client.model.SchemaFieldSecurityLabel;
import com.koverse.kdpapi.client.model.SecurityLabelInfoParams;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"records", "securityLabelInfo", "columnSecurityLabelInfo"})
@JsonTypeName(value="BatchWriteRequest")
public class BatchWriteRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_RECORDS = "records";
    private List<Map<String, Object>> records = null;
    public static final String JSON_PROPERTY_SECURITY_LABEL_INFO = "securityLabelInfo";
    private SecurityLabelInfoParams securityLabelInfo;
    public static final String JSON_PROPERTY_COLUMN_SECURITY_LABEL_INFO = "columnSecurityLabelInfo";
    private Map<String, SchemaFieldSecurityLabel> columnSecurityLabelInfo = null;

    public BatchWriteRequest records(List<Map<String, Object>> records) {
        this.records = records;
        return this;
    }

    public BatchWriteRequest addRecordsItem(Map<String, Object> recordsItem) {
        if (this.records == null) {
            this.records = new ArrayList<Map<String, Object>>();
        }
        this.records.add(recordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"date\":\"2022-01-01\",\"description\":\"this is the description.\",\"id\":\"10\"}]", value="Array of json documents to write into KDP.")
    @JsonProperty(value="records")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Map<String, Object>> getRecords() {
        return this.records;
    }

    @JsonProperty(value="records")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecords(List<Map<String, Object>> records) {
        this.records = records;
    }

    public BatchWriteRequest securityLabelInfo(SecurityLabelInfoParams securityLabelInfo) {
        this.securityLabelInfo = securityLabelInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="securityLabelInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityLabelInfoParams getSecurityLabelInfo() {
        return this.securityLabelInfo;
    }

    @JsonProperty(value="securityLabelInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityLabelInfo(SecurityLabelInfoParams securityLabelInfo) {
        this.securityLabelInfo = securityLabelInfo;
    }

    public BatchWriteRequest columnSecurityLabelInfo(Map<String, SchemaFieldSecurityLabel> columnSecurityLabelInfo) {
        this.columnSecurityLabelInfo = columnSecurityLabelInfo;
        return this;
    }

    public BatchWriteRequest putColumnSecurityLabelInfoItem(String key, SchemaFieldSecurityLabel columnSecurityLabelInfoItem) {
        if (this.columnSecurityLabelInfo == null) {
            this.columnSecurityLabelInfo = new HashMap<String, SchemaFieldSecurityLabel>();
        }
        this.columnSecurityLabelInfo.put(key, columnSecurityLabelInfoItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The schema of the records returned in a record batch")
    @JsonProperty(value="columnSecurityLabelInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, SchemaFieldSecurityLabel> getColumnSecurityLabelInfo() {
        return this.columnSecurityLabelInfo;
    }

    @JsonProperty(value="columnSecurityLabelInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumnSecurityLabelInfo(Map<String, SchemaFieldSecurityLabel> columnSecurityLabelInfo) {
        this.columnSecurityLabelInfo = columnSecurityLabelInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchWriteRequest batchWriteRequest = (BatchWriteRequest)o;
        return Objects.equals(this.records, batchWriteRequest.records) && Objects.equals(this.securityLabelInfo, batchWriteRequest.securityLabelInfo) && Objects.equals(this.columnSecurityLabelInfo, batchWriteRequest.columnSecurityLabelInfo);
    }

    public int hashCode() {
        return Objects.hash(this.records, this.securityLabelInfo, this.columnSecurityLabelInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchWriteRequest {\n");
        sb.append("    records: ").append(this.toIndentedString(this.records)).append("\n");
        sb.append("    securityLabelInfo: ").append(this.toIndentedString(this.securityLabelInfo)).append("\n");
        sb.append("    columnSecurityLabelInfo: ").append(this.toIndentedString(this.columnSecurityLabelInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

