/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client;

import com.koverse.kdpapi.client.invoker.ApiClient;
import com.koverse.kdpapi.client.model.AbacLabelParserPaginator;
import com.koverse.kdpapi.client.model.AbacLabelParsers;
import com.koverse.kdpapi.client.model.BatchWriteRequest;
import com.koverse.kdpapi.client.model.IngestCreateRequest;
import com.koverse.kdpapi.client.model.UploadResponse;
import com.koverse.kdpapi.client.model.WriteBatchResponse;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.koverse.kdpapi.client.WriteApi")
public class WriteApi {
    private ApiClient apiClient;

    public WriteApi() {
        this(new ApiClient());
    }

    @Autowired
    public WriteApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AbacLabelParserPaginator getAbacLabelParsers(Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        return (AbacLabelParserPaginator)this.getAbacLabelParsersWithHttpInfo($limit, $skip, $sort, filter).getBody();
    }

    public ResponseEntity<AbacLabelParserPaginator> getAbacLabelParsersWithHttpInfo(Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        Object postBody = null;
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$skip", $skip));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$sort", $sort));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<AbacLabelParserPaginator> returnType = new ParameterizedTypeReference<AbacLabelParserPaginator>(){};
        return this.apiClient.invokeAPI("/abac-label-parsers", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public AbacLabelParsers getAbacLabelParsersId(String id) throws RestClientException {
        return (AbacLabelParsers)this.getAbacLabelParsersIdWithHttpInfo(id).getBody();
    }

    public ResponseEntity<AbacLabelParsers> getAbacLabelParsersIdWithHttpInfo(String id) throws RestClientException {
        Object postBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getAbacLabelParsersId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<AbacLabelParsers> returnType = new ParameterizedTypeReference<AbacLabelParsers>(){};
        return this.apiClient.invokeAPI("/abac-label-parsers/{id}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public UUID postIngest(IngestCreateRequest ingestCreateRequest, Boolean isAsync) throws RestClientException {
        return (UUID)this.postIngestWithHttpInfo(ingestCreateRequest, isAsync).getBody();
    }

    public ResponseEntity<UUID> postIngestWithHttpInfo(IngestCreateRequest ingestCreateRequest, Boolean isAsync) throws RestClientException {
        IngestCreateRequest postBody = ingestCreateRequest;
        if (ingestCreateRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'ingestCreateRequest' when calling postIngest");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "isAsync", isAsync));
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<UUID> returnType = new ParameterizedTypeReference<UUID>(){};
        return this.apiClient.invokeAPI("/ingest", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public UploadResponse postUploads(UUID datasetId, List<File> files, Object accessControlLabel, Object customMetadata, Boolean processAsDocument) throws RestClientException {
        return (UploadResponse)this.postUploadsWithHttpInfo(datasetId, files, accessControlLabel, customMetadata, processAsDocument).getBody();
    }

    public ResponseEntity<UploadResponse> postUploadsWithHttpInfo(UUID datasetId, List<File> files, Object accessControlLabel, Object customMetadata, Boolean processAsDocument) throws RestClientException {
        Object postBody = null;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling postUploads");
        }
        if (files == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'files' when calling postUploads");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accessControlLabel != null) {
            formParams.add((Object)"accessControlLabel", accessControlLabel);
        }
        if (customMetadata != null) {
            formParams.add((Object)"customMetadata", customMetadata);
        }
        if (datasetId != null) {
            formParams.add((Object)"datasetId", (Object)datasetId);
        }
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        if (processAsDocument != null) {
            formParams.add((Object)"processAsDocument", (Object)processAsDocument);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<UploadResponse> returnType = new ParameterizedTypeReference<UploadResponse>(){};
        return this.apiClient.invokeAPI("/uploads", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public WriteBatchResponse postV2WriteId(UUID datasetId, BatchWriteRequest batchWriteRequest, Boolean isAsync) throws RestClientException {
        return (WriteBatchResponse)this.postV2WriteIdWithHttpInfo(datasetId, batchWriteRequest, isAsync).getBody();
    }

    public ResponseEntity<WriteBatchResponse> postV2WriteIdWithHttpInfo(UUID datasetId, BatchWriteRequest batchWriteRequest, Boolean isAsync) throws RestClientException {
        BatchWriteRequest postBody = batchWriteRequest;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling postV2WriteId");
        }
        if (batchWriteRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'batchWriteRequest' when calling postV2WriteId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("datasetId", datasetId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "isAsync", isAsync));
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<WriteBatchResponse> returnType = new ParameterizedTypeReference<WriteBatchResponse>(){};
        return this.apiClient.invokeAPI("/v2/write/{datasetId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public WriteBatchResponse postWriteId(UUID datasetId, List<Map<String, Object>> requestBody, Boolean isAsync) throws RestClientException {
        return (WriteBatchResponse)this.postWriteIdWithHttpInfo(datasetId, requestBody, isAsync).getBody();
    }

    public ResponseEntity<WriteBatchResponse> postWriteIdWithHttpInfo(UUID datasetId, List<Map<String, Object>> requestBody, Boolean isAsync) throws RestClientException {
        List<Map<String, Object>> postBody = requestBody;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling postWriteId");
        }
        if (requestBody == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'requestBody' when calling postWriteId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("datasetId", datasetId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "isAsync", isAsync));
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<WriteBatchResponse> returnType = new ParameterizedTypeReference<WriteBatchResponse>(){};
        return this.apiClient.invokeAPI("/write/{datasetId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}

