/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client;

import com.koverse.kdpapi.client.invoker.ApiClient;
import com.koverse.kdpapi.client.model.InlineResponse200;
import com.koverse.kdpapi.client.model.LuceneQueryRequest;
import com.koverse.kdpapi.client.model.Query;
import com.koverse.kdpapi.client.model.QueryDatasetsSummary;
import com.koverse.kdpapi.client.model.QueryDatasetsSummaryRequest;
import com.koverse.kdpapi.client.model.QueryDocumentLuceneRequest;
import com.koverse.kdpapi.client.model.QueryDocumentLuceneResponse;
import com.koverse.kdpapi.client.model.ReadRangeRequest;
import com.koverse.kdpapi.client.model.RecordBatch;
import com.koverse.kdpapi.client.model.SplitPoints;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.koverse.kdpapi.client.ReadAndQueryApi")
public class ReadAndQueryApi {
    private ApiClient apiClient;

    public ReadAndQueryApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReadAndQueryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public InlineResponse200 getServeMedia(String datasetId, String documentId, Boolean download) throws RestClientException {
        return (InlineResponse200)this.getServeMediaWithHttpInfo(datasetId, documentId, download).getBody();
    }

    public ResponseEntity<InlineResponse200> getServeMediaWithHttpInfo(String datasetId, String documentId, Boolean download) throws RestClientException {
        Object postBody = null;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling getServeMedia");
        }
        if (documentId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'documentId' when calling getServeMedia");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("datasetId", datasetId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "documentId", documentId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "download", download));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<InlineResponse200> returnType = new ParameterizedTypeReference<InlineResponse200>(){};
        return this.apiClient.invokeAPI("/serve-media/{datasetId}?documentId=documentId", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public SplitPoints getSplitsId(String datasetId) throws RestClientException {
        return (SplitPoints)this.getSplitsIdWithHttpInfo(datasetId).getBody();
    }

    public ResponseEntity<SplitPoints> getSplitsIdWithHttpInfo(String datasetId) throws RestClientException {
        Object postBody = null;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling getSplitsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("datasetId", datasetId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<SplitPoints> returnType = new ParameterizedTypeReference<SplitPoints>(){};
        return this.apiClient.invokeAPI("/splits/{datasetId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public RecordBatch postLuceneQuery(LuceneQueryRequest luceneQueryRequest, Boolean includeInternalFields) throws RestClientException {
        return (RecordBatch)this.postLuceneQueryWithHttpInfo(luceneQueryRequest, includeInternalFields).getBody();
    }

    public ResponseEntity<RecordBatch> postLuceneQueryWithHttpInfo(LuceneQueryRequest luceneQueryRequest, Boolean includeInternalFields) throws RestClientException {
        LuceneQueryRequest postBody = luceneQueryRequest;
        if (luceneQueryRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'luceneQueryRequest' when calling postLuceneQuery");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "includeInternalFields", includeInternalFields));
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<RecordBatch> returnType = new ParameterizedTypeReference<RecordBatch>(){};
        return this.apiClient.invokeAPI("/query/lucene", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public QueryDocumentLuceneResponse postLuceneQueryDocument(QueryDocumentLuceneRequest queryDocumentLuceneRequest) throws RestClientException {
        return (QueryDocumentLuceneResponse)this.postLuceneQueryDocumentWithHttpInfo(queryDocumentLuceneRequest).getBody();
    }

    public ResponseEntity<QueryDocumentLuceneResponse> postLuceneQueryDocumentWithHttpInfo(QueryDocumentLuceneRequest queryDocumentLuceneRequest) throws RestClientException {
        QueryDocumentLuceneRequest postBody = queryDocumentLuceneRequest;
        if (queryDocumentLuceneRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'queryDocumentLuceneRequest' when calling postLuceneQueryDocument");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<QueryDocumentLuceneResponse> returnType = new ParameterizedTypeReference<QueryDocumentLuceneResponse>(){};
        return this.apiClient.invokeAPI("/query/document/lucene", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public RecordBatch postQuery(Query query) throws RestClientException {
        return (RecordBatch)this.postQueryWithHttpInfo(query).getBody();
    }

    public ResponseEntity<RecordBatch> postQueryWithHttpInfo(Query query) throws RestClientException {
        Query postBody = query;
        if (query == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'query' when calling postQuery");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<RecordBatch> returnType = new ParameterizedTypeReference<RecordBatch>(){};
        return this.apiClient.invokeAPI("/query", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public QueryDatasetsSummary postQuerySummary(QueryDatasetsSummaryRequest queryDatasetsSummaryRequest) throws RestClientException {
        return (QueryDatasetsSummary)this.postQuerySummaryWithHttpInfo(queryDatasetsSummaryRequest).getBody();
    }

    public ResponseEntity<QueryDatasetsSummary> postQuerySummaryWithHttpInfo(QueryDatasetsSummaryRequest queryDatasetsSummaryRequest) throws RestClientException {
        QueryDatasetsSummaryRequest postBody = queryDatasetsSummaryRequest;
        if (queryDatasetsSummaryRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'queryDatasetsSummaryRequest' when calling postQuerySummary");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<QueryDatasetsSummary> returnType = new ParameterizedTypeReference<QueryDatasetsSummary>(){};
        return this.apiClient.invokeAPI("/query/datasets/summary", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public RecordBatch postRead(ReadRangeRequest readRangeRequest) throws RestClientException {
        return (RecordBatch)this.postReadWithHttpInfo(readRangeRequest).getBody();
    }

    public ResponseEntity<RecordBatch> postReadWithHttpInfo(ReadRangeRequest readRangeRequest) throws RestClientException {
        ReadRangeRequest postBody = readRangeRequest;
        if (readRangeRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'readRangeRequest' when calling postRead");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<RecordBatch> returnType = new ParameterizedTypeReference<RecordBatch>(){};
        return this.apiClient.invokeAPI("/read", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public RecordBatch postReadInSequence(ReadRangeRequest readRangeRequest) throws RestClientException {
        return (RecordBatch)this.postReadInSequenceWithHttpInfo(readRangeRequest).getBody();
    }

    public ResponseEntity<RecordBatch> postReadInSequenceWithHttpInfo(ReadRangeRequest readRangeRequest) throws RestClientException {
        ReadRangeRequest postBody = readRangeRequest;
        if (readRangeRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'readRangeRequest' when calling postReadInSequence");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<RecordBatch> returnType = new ParameterizedTypeReference<RecordBatch>(){};
        return this.apiClient.invokeAPI("/readInSequence", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}

