/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client;

import com.koverse.kdpapi.client.invoker.ApiClient;
import com.koverse.kdpapi.client.model.Index;
import com.koverse.kdpapi.client.model.IndexPaginator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.koverse.kdpapi.client.IndexingApi")
public class IndexingApi {
    private ApiClient apiClient;

    public IndexingApi() {
        this(new ApiClient());
    }

    @Autowired
    public IndexingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Index deleteIndexesId(String id) throws RestClientException {
        return (Index)this.deleteIndexesIdWithHttpInfo(id).getBody();
    }

    public ResponseEntity<Index> deleteIndexesIdWithHttpInfo(String id) throws RestClientException {
        Object postBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling deleteIndexesId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Index> returnType = new ParameterizedTypeReference<Index>(){};
        return this.apiClient.invokeAPI("/indexes/{id}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public IndexPaginator getIndexes(String datasetId, Boolean fields, Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        return (IndexPaginator)this.getIndexesWithHttpInfo(datasetId, fields, $limit, $skip, $sort, filter).getBody();
    }

    public ResponseEntity<IndexPaginator> getIndexesWithHttpInfo(String datasetId, Boolean fields, Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        Object postBody = null;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling getIndexes");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "datasetId", datasetId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "fields", fields));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$skip", $skip));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$sort", $sort));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<IndexPaginator> returnType = new ParameterizedTypeReference<IndexPaginator>(){};
        return this.apiClient.invokeAPI("/indexes", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Index getIndexesId(String id) throws RestClientException {
        return (Index)this.getIndexesIdWithHttpInfo(id).getBody();
    }

    public ResponseEntity<Index> getIndexesIdWithHttpInfo(String id) throws RestClientException {
        Object postBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getIndexesId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Index> returnType = new ParameterizedTypeReference<Index>(){};
        return this.apiClient.invokeAPI("/indexes/{id}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Index patchIndexesId(String id, Index index) throws RestClientException {
        return (Index)this.patchIndexesIdWithHttpInfo(id, index).getBody();
    }

    public ResponseEntity<Index> patchIndexesIdWithHttpInfo(String id, Index index) throws RestClientException {
        Index postBody = index;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling patchIndexesId");
        }
        if (index == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'index' when calling patchIndexesId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Index> returnType = new ParameterizedTypeReference<Index>(){};
        return this.apiClient.invokeAPI("/indexes/{id}", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Index postIndexes(Index index) throws RestClientException {
        return (Index)this.postIndexesWithHttpInfo(index).getBody();
    }

    public ResponseEntity<Index> postIndexesWithHttpInfo(Index index) throws RestClientException {
        Index postBody = index;
        if (index == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'index' when calling postIndexes");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Index> returnType = new ParameterizedTypeReference<Index>(){};
        return this.apiClient.invokeAPI("/indexes", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Index putIndexesId(String id, Index index) throws RestClientException {
        return (Index)this.putIndexesIdWithHttpInfo(id, index).getBody();
    }

    public ResponseEntity<Index> putIndexesIdWithHttpInfo(String id, Index index) throws RestClientException {
        Index postBody = index;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling putIndexesId");
        }
        if (index == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'index' when calling putIndexesId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Index> returnType = new ParameterizedTypeReference<Index>(){};
        return this.apiClient.invokeAPI("/indexes/{id}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}

