/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client;

import com.koverse.kdpapi.client.invoker.ApiClient;
import com.koverse.kdpapi.client.model.Dataset;
import com.koverse.kdpapi.client.model.DatasetCreateRequest;
import com.koverse.kdpapi.client.model.DatasetPaginator;
import com.koverse.kdpapi.client.model.DatasetPatchRequest;
import com.koverse.kdpapi.client.model.DatasetUpdateRequest;
import com.koverse.kdpapi.client.model.Job;
import com.koverse.kdpapi.client.model.JobPaginator;
import com.koverse.kdpapi.client.model.SchemaField;
import com.koverse.kdpapi.client.model.Segment;
import com.koverse.kdpapi.client.model.SegmentPaginator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.koverse.kdpapi.client.DatasetsApi")
public class DatasetsApi {
    private ApiClient apiClient;

    public DatasetsApi() {
        this(new ApiClient());
    }

    @Autowired
    public DatasetsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Dataset deleteDatasetsId(String id) throws RestClientException {
        return (Dataset)this.deleteDatasetsIdWithHttpInfo(id).getBody();
    }

    public ResponseEntity<Dataset> deleteDatasetsIdWithHttpInfo(String id) throws RestClientException {
        Object postBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling deleteDatasetsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Dataset> returnType = new ParameterizedTypeReference<Dataset>(){};
        return this.apiClient.invokeAPI("/datasets/{id}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public DatasetPaginator getDatasets(Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        return (DatasetPaginator)this.getDatasetsWithHttpInfo($limit, $skip, $sort, filter).getBody();
    }

    public ResponseEntity<DatasetPaginator> getDatasetsWithHttpInfo(Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        Object postBody = null;
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$skip", $skip));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$sort", $sort));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<DatasetPaginator> returnType = new ParameterizedTypeReference<DatasetPaginator>(){};
        return this.apiClient.invokeAPI("/datasets", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Dataset getDatasetsId(String id) throws RestClientException {
        return (Dataset)this.getDatasetsIdWithHttpInfo(id).getBody();
    }

    public ResponseEntity<Dataset> getDatasetsIdWithHttpInfo(String id) throws RestClientException {
        Object postBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getDatasetsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Dataset> returnType = new ParameterizedTypeReference<Dataset>(){};
        return this.apiClient.invokeAPI("/datasets/{id}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public JobPaginator getJobs(String datasetId, String workspaceId, Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        return (JobPaginator)this.getJobsWithHttpInfo(datasetId, workspaceId, $limit, $skip, $sort, filter).getBody();
    }

    public ResponseEntity<JobPaginator> getJobsWithHttpInfo(String datasetId, String workspaceId, Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        Object postBody = null;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling getJobs");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "workspaceId", workspaceId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "datasetId", datasetId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$skip", $skip));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$sort", $sort));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<JobPaginator> returnType = new ParameterizedTypeReference<JobPaginator>(){};
        return this.apiClient.invokeAPI("/jobs", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Job getJobsId(String id) throws RestClientException {
        return (Job)this.getJobsIdWithHttpInfo(id).getBody();
    }

    public ResponseEntity<Job> getJobsIdWithHttpInfo(String id) throws RestClientException {
        Object postBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getJobsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Job> returnType = new ParameterizedTypeReference<Job>(){};
        return this.apiClient.invokeAPI("/jobs/{id}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Map<String, SchemaField> getSchema(UUID datasetId, Boolean includeSecurityField, Boolean includeNestedFields) throws RestClientException {
        return (Map)this.getSchemaWithHttpInfo(datasetId, includeSecurityField, includeNestedFields).getBody();
    }

    public ResponseEntity<Map<String, SchemaField>> getSchemaWithHttpInfo(UUID datasetId, Boolean includeSecurityField, Boolean includeNestedFields) throws RestClientException {
        Object postBody = null;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling getSchema");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("datasetId", datasetId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "includeSecurityField", includeSecurityField));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "includeNestedFields", includeNestedFields));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Map<String, SchemaField>> returnType = new ParameterizedTypeReference<Map<String, SchemaField>>(){};
        return this.apiClient.invokeAPI("/query/schema/{datasetId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public SegmentPaginator getSegments(String datasetId, String workspaceId, String jobId, Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        return (SegmentPaginator)this.getSegmentsWithHttpInfo(datasetId, workspaceId, jobId, $limit, $skip, $sort, filter).getBody();
    }

    public ResponseEntity<SegmentPaginator> getSegmentsWithHttpInfo(String datasetId, String workspaceId, String jobId, Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        Object postBody = null;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling getSegments");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "workspaceId", workspaceId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "datasetId", datasetId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "jobId", jobId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$skip", $skip));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$sort", $sort));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<SegmentPaginator> returnType = new ParameterizedTypeReference<SegmentPaginator>(){};
        return this.apiClient.invokeAPI("/segments", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Segment getSegmentsId(String id) throws RestClientException {
        return (Segment)this.getSegmentsIdWithHttpInfo(id).getBody();
    }

    public ResponseEntity<Segment> getSegmentsIdWithHttpInfo(String id) throws RestClientException {
        Object postBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getSegmentsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Segment> returnType = new ParameterizedTypeReference<Segment>(){};
        return this.apiClient.invokeAPI("/segments/{id}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Dataset patchDatasetsId(String id, DatasetPatchRequest datasetPatchRequest) throws RestClientException {
        return (Dataset)this.patchDatasetsIdWithHttpInfo(id, datasetPatchRequest).getBody();
    }

    public ResponseEntity<Dataset> patchDatasetsIdWithHttpInfo(String id, DatasetPatchRequest datasetPatchRequest) throws RestClientException {
        DatasetPatchRequest postBody = datasetPatchRequest;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling patchDatasetsId");
        }
        if (datasetPatchRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetPatchRequest' when calling patchDatasetsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Dataset> returnType = new ParameterizedTypeReference<Dataset>(){};
        return this.apiClient.invokeAPI("/datasets/{id}", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Job patchJobsId(String id, Job job) throws RestClientException {
        return (Job)this.patchJobsIdWithHttpInfo(id, job).getBody();
    }

    public ResponseEntity<Job> patchJobsIdWithHttpInfo(String id, Job job) throws RestClientException {
        Job postBody = job;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling patchJobsId");
        }
        if (job == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'job' when calling patchJobsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Job> returnType = new ParameterizedTypeReference<Job>(){};
        return this.apiClient.invokeAPI("/jobs/{id}", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Dataset postDatasets(DatasetCreateRequest datasetCreateRequest) throws RestClientException {
        return (Dataset)this.postDatasetsWithHttpInfo(datasetCreateRequest).getBody();
    }

    public ResponseEntity<Dataset> postDatasetsWithHttpInfo(DatasetCreateRequest datasetCreateRequest) throws RestClientException {
        DatasetCreateRequest postBody = datasetCreateRequest;
        if (datasetCreateRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetCreateRequest' when calling postDatasets");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Dataset> returnType = new ParameterizedTypeReference<Dataset>(){};
        return this.apiClient.invokeAPI("/datasets", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Job postJobs(Job job) throws RestClientException {
        return (Job)this.postJobsWithHttpInfo(job).getBody();
    }

    public ResponseEntity<Job> postJobsWithHttpInfo(Job job) throws RestClientException {
        Job postBody = job;
        if (job == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'job' when calling postJobs");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Job> returnType = new ParameterizedTypeReference<Job>(){};
        return this.apiClient.invokeAPI("/jobs", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Dataset putDatasetsId(String id, DatasetUpdateRequest datasetUpdateRequest) throws RestClientException {
        return (Dataset)this.putDatasetsIdWithHttpInfo(id, datasetUpdateRequest).getBody();
    }

    public ResponseEntity<Dataset> putDatasetsIdWithHttpInfo(String id, DatasetUpdateRequest datasetUpdateRequest) throws RestClientException {
        DatasetUpdateRequest postBody = datasetUpdateRequest;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling putDatasetsId");
        }
        if (datasetUpdateRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetUpdateRequest' when calling putDatasetsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Dataset> returnType = new ParameterizedTypeReference<Dataset>(){};
        return this.apiClient.invokeAPI("/datasets/{id}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Job putJobsId(String id, Job job) throws RestClientException {
        return (Job)this.putJobsIdWithHttpInfo(id, job).getBody();
    }

    public ResponseEntity<Job> putJobsIdWithHttpInfo(String id, Job job) throws RestClientException {
        Job postBody = job;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling putJobsId");
        }
        if (job == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'job' when calling putJobsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Job> returnType = new ParameterizedTypeReference<Job>(){};
        return this.apiClient.invokeAPI("/jobs/{id}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}

