/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client;

import com.koverse.kdpapi.client.invoker.ApiClient;
import com.koverse.kdpapi.client.model.Authentication;
import com.koverse.kdpapi.client.model.AuthenticationDetails;
import com.koverse.kdpapi.client.model.AuthenticationSSO;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.koverse.kdpapi.client.AuthenticateApi")
public class AuthenticateApi {
    private ApiClient apiClient;

    public AuthenticateApi() {
        this(new ApiClient());
    }

    @Autowired
    public AuthenticateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Authentication deleteAuthenticationId(String id) throws RestClientException {
        return (Authentication)this.deleteAuthenticationIdWithHttpInfo(id).getBody();
    }

    public ResponseEntity<Authentication> deleteAuthenticationIdWithHttpInfo(String id) throws RestClientException {
        Object postBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling deleteAuthenticationId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Authentication> returnType = new ParameterizedTypeReference<Authentication>(){};
        return this.apiClient.invokeAPI("/authentication/{id}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public AuthenticationDetails postAuthentication(Authentication authentication) throws RestClientException {
        return (AuthenticationDetails)this.postAuthenticationWithHttpInfo(authentication).getBody();
    }

    public ResponseEntity<AuthenticationDetails> postAuthenticationWithHttpInfo(Authentication authentication) throws RestClientException {
        Authentication postBody = authentication;
        if (authentication == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'authentication' when calling postAuthentication");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<AuthenticationDetails> returnType = new ParameterizedTypeReference<AuthenticationDetails>(){};
        return this.apiClient.invokeAPI("/authentication", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public AuthenticationDetails postAuthenticationSso(String workspaceId, AuthenticationSSO authenticationSSO) throws RestClientException {
        return (AuthenticationDetails)this.postAuthenticationSsoWithHttpInfo(workspaceId, authenticationSSO).getBody();
    }

    public ResponseEntity<AuthenticationDetails> postAuthenticationSsoWithHttpInfo(String workspaceId, AuthenticationSSO authenticationSSO) throws RestClientException {
        AuthenticationSSO postBody = authenticationSSO;
        if (workspaceId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'workspaceId' when calling postAuthenticationSso");
        }
        if (authenticationSSO == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'authenticationSSO' when calling postAuthenticationSso");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("workspaceId", workspaceId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<AuthenticationDetails> returnType = new ParameterizedTypeReference<AuthenticationDetails>(){};
        return this.apiClient.invokeAPI("/authentication?workspaceId={workspaceId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}

