/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.net.Uri;
import android.util.Log;
import com.koushikdutta.async.AsyncSSLException;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.ProtocolVersion;
import com.koushikdutta.async.http.RequestLine;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import java.util.Locale;

public class AsyncHttpRequest {
    private String requestLineProtocol = "HTTP/1.1";
    private String mMethod;
    public static final String HEADER_ACCEPT_ALL = "*/*";
    Uri uri;
    private Headers mRawHeaders = new Headers();
    private boolean mFollowRedirect = true;
    private AsyncHttpRequestBody mBody;
    public static final int DEFAULT_TIMEOUT = 30000;
    int mTimeout = 30000;
    String proxyHost;
    int proxyPort = -1;
    String LOGTAG;
    int logLevel;
    long executionTime;

    public RequestLine getRequestLine() {
        return new RequestLine(){

            @Override
            public String getUri() {
                return AsyncHttpRequest.this.getUri().toString();
            }

            @Override
            public ProtocolVersion getProtocolVersion() {
                return new ProtocolVersion("HTTP", 1, 1);
            }

            @Override
            public String getMethod() {
                return AsyncHttpRequest.this.mMethod;
            }

            public String toString() {
                String query;
                if (AsyncHttpRequest.this.proxyHost != null) {
                    return String.format(Locale.ENGLISH, "%s %s %s", AsyncHttpRequest.this.mMethod, AsyncHttpRequest.this.getUri(), AsyncHttpRequest.this.requestLineProtocol);
                }
                String path = AsyncHttpRequest.this.getPath();
                if (path == null || path.length() == 0) {
                    path = "/";
                }
                if ((query = AsyncHttpRequest.this.getUri().getEncodedQuery()) != null && query.length() != 0) {
                    path = path + "?" + query;
                }
                return String.format(Locale.ENGLISH, "%s %s %s", AsyncHttpRequest.this.mMethod, path, AsyncHttpRequest.this.requestLineProtocol);
            }
        };
    }

    public boolean hasBody() {
        return true;
    }

    public String getPath() {
        return this.getUri().getEncodedPath();
    }

    protected static String getDefaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? agent : "Java" + System.getProperty("java.version");
    }

    public String getMethod() {
        return this.mMethod;
    }

    public void setRequestLineProtocol(String scheme) {
        this.requestLineProtocol = scheme;
    }

    public String getRequestLineProtocol() {
        return this.requestLineProtocol;
    }

    public AsyncHttpRequest setMethod(String method) {
        if (this.getClass() != AsyncHttpRequest.class) {
            throw new UnsupportedOperationException("can't change method on a subclass of AsyncHttpRequest");
        }
        this.mMethod = method;
        return this;
    }

    public AsyncHttpRequest(Uri uri, String method) {
        this(uri, method, null);
    }

    public static void setDefaultHeaders(Headers ret, Uri uri) {
        if (uri != null) {
            String host = uri.getHost();
            if (uri.getPort() != -1) {
                host = host + ":" + uri.getPort();
            }
            if (host != null) {
                ret.set("Host", host);
            }
        }
        ret.set("User-Agent", AsyncHttpRequest.getDefaultUserAgent());
        ret.set("Accept-Encoding", "gzip, deflate");
        ret.set("Connection", "keep-alive");
        ret.set("Accept", HEADER_ACCEPT_ALL);
    }

    public AsyncHttpRequest(Uri uri, String method, Headers headers) {
        this.mMethod = method;
        this.uri = uri;
        this.mRawHeaders = headers == null ? new Headers() : headers;
        if (headers == null) {
            AsyncHttpRequest.setDefaultHeaders(this.mRawHeaders, uri);
        }
    }

    public Uri getUri() {
        return this.uri;
    }

    public Headers getHeaders() {
        return this.mRawHeaders;
    }

    public boolean getFollowRedirect() {
        return this.mFollowRedirect;
    }

    public AsyncHttpRequest setFollowRedirect(boolean follow) {
        this.mFollowRedirect = follow;
        return this;
    }

    public void setBody(AsyncHttpRequestBody body) {
        this.mBody = body;
    }

    public AsyncHttpRequestBody getBody() {
        return this.mBody;
    }

    public void onHandshakeException(AsyncSSLException e) {
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public AsyncHttpRequest setTimeout(int timeout) {
        this.mTimeout = timeout;
        return this;
    }

    public AsyncHttpRequest setHeader(String name, String value) {
        this.getHeaders().set(name, value);
        return this;
    }

    public AsyncHttpRequest addHeader(String name, String value) {
        this.getHeaders().add(name, value);
        return this;
    }

    public void enableProxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
    }

    public void disableProxy() {
        this.proxyHost = null;
        this.proxyPort = -1;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String toString() {
        if (this.mRawHeaders == null) {
            return super.toString();
        }
        return this.mRawHeaders.toPrefixString(this.uri.toString());
    }

    public void setLogging(String tag, int level) {
        this.LOGTAG = tag;
        this.logLevel = level;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public String getLogTag() {
        return this.LOGTAG;
    }

    private String getLogMessage(String message) {
        long elapsed = this.executionTime != 0L ? System.currentTimeMillis() - this.executionTime : 0L;
        return String.format(Locale.ENGLISH, "(%d ms) %s: %s", elapsed, this.getUri(), message);
    }

    public void logi(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 4) {
            return;
        }
        Log.i((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logv(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 2) {
            return;
        }
        Log.v((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logw(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 5) {
            return;
        }
        Log.w((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logd(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 3) {
            return;
        }
        Log.d((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logd(String message, Exception e) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 3) {
            return;
        }
        Log.d((String)this.LOGTAG, (String)this.getLogMessage(message));
        Log.d((String)this.LOGTAG, (String)e.getMessage(), (Throwable)e);
    }

    public void loge(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 6) {
            return;
        }
        Log.e((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void loge(String message, Exception e) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 6) {
            return;
        }
        Log.e((String)this.LOGTAG, (String)this.getLogMessage(message));
        Log.e((String)this.LOGTAG, (String)e.getMessage(), (Throwable)e);
    }
}

