/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import android.content.Context;
import android.os.Build;
import android.util.Base64;
import android.util.Pair;
import com.koushikdutta.async.AsyncSSLException;
import com.koushikdutta.async.AsyncSSLServerSocket;
import com.koushikdutta.async.AsyncSSLSocket;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncServerSocket;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.BufferedDataSink;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.ListenCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.SimpleCancellable;
import com.koushikdutta.async.http.SSLEngineSNIConfigurator;
import com.koushikdutta.async.util.Allocator;
import com.koushikdutta.async.util.StreamUtility;
import com.koushikdutta.async.wrapper.AsyncSocketWrapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Calendar;
import java.util.Date;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class AsyncSSLSocketWrapper
implements AsyncSocketWrapper,
AsyncSSLSocket {
    private static final String LOGTAG = "AsyncSSLSocketWrapper";
    static SSLContext defaultSSLContext;
    static SSLContext trustAllSSLContext;
    static TrustManager[] trustAllManagers;
    static HostnameVerifier trustAllVerifier;
    AsyncSocket mSocket;
    BufferedDataSink mSink;
    boolean mUnwrapping;
    SSLEngine engine;
    boolean finishedHandshake;
    private int mPort;
    private String mHost;
    private boolean mWrapping;
    HostnameVerifier hostnameVerifier;
    HandshakeCallback handshakeCallback;
    X509Certificate[] peerCertificates;
    WritableCallback mWriteableCallback;
    DataCallback mDataCallback;
    TrustManager[] trustManagers;
    boolean clientMode;
    boolean mEnded;
    Exception mEndException;
    final ByteBufferList pending = new ByteBufferList();
    final DataCallback dataCallback = new DataCallback(){
        final Allocator allocator = new Allocator().setMinAlloc(8192);
        final ByteBufferList buffered = new ByteBufferList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            if (AsyncSSLSocketWrapper.this.mUnwrapping) {
                return;
            }
            try {
                block12: {
                    int before;
                    int remaining;
                    AsyncSSLSocketWrapper.this.mUnwrapping = true;
                    bb.get(this.buffered);
                    if (this.buffered.hasRemaining()) {
                        ByteBuffer all = this.buffered.getAll();
                        this.buffered.add(all);
                    }
                    ByteBuffer b = ByteBufferList.EMPTY_BYTEBUFFER;
                    do {
                        if (b.remaining() == 0 && this.buffered.size() > 0) {
                            b = this.buffered.remove();
                        }
                        remaining = b.remaining();
                        before = AsyncSSLSocketWrapper.this.pending.remaining();
                        ByteBuffer readBuf = this.allocator.allocate();
                        SSLEngineResult res = AsyncSSLSocketWrapper.this.engine.unwrap(b, readBuf);
                        AsyncSSLSocketWrapper.this.addToPending(AsyncSSLSocketWrapper.this.pending, readBuf);
                        this.allocator.track(AsyncSSLSocketWrapper.this.pending.remaining() - before);
                        if (res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                            this.allocator.setMinAlloc(this.allocator.getMinAlloc() * 2);
                            remaining = -1;
                        } else if (res.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            this.buffered.addFirst(b);
                            if (this.buffered.size() <= 1) break block12;
                            remaining = -1;
                            b = this.buffered.getAll();
                            this.buffered.addFirst(b);
                            b = ByteBufferList.EMPTY_BYTEBUFFER;
                        }
                        AsyncSSLSocketWrapper.this.handleHandshakeStatus(res.getHandshakeStatus());
                    } while (b.remaining() != remaining || before != AsyncSSLSocketWrapper.this.pending.remaining());
                    this.buffered.addFirst(b);
                }
                AsyncSSLSocketWrapper.this.onDataAvailable();
            }
            catch (SSLException ex) {
                AsyncSSLSocketWrapper.this.report(ex);
            }
            finally {
                AsyncSSLSocketWrapper.this.mUnwrapping = false;
            }
        }
    };
    ByteBufferList writeList = new ByteBufferList();
    CompletedCallback mEndCallback;

    public static SSLContext getDefaultSSLContext() {
        return defaultSSLContext;
    }

    public static void handshake(AsyncSocket socket, String host, int port, SSLEngine sslEngine, TrustManager[] trustManagers, HostnameVerifier verifier, boolean clientMode, final HandshakeCallback callback) {
        AsyncSSLSocketWrapper wrapper = new AsyncSSLSocketWrapper(socket, host, port, sslEngine, trustManagers, verifier, clientMode);
        wrapper.handshakeCallback = callback;
        socket.setClosedCallback(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                if (ex != null) {
                    callback.onHandshakeCompleted(ex, null);
                } else {
                    callback.onHandshakeCompleted(new SSLException("socket closed during handshake"), null);
                }
            }
        });
        try {
            wrapper.engine.beginHandshake();
            wrapper.handleHandshakeStatus(wrapper.engine.getHandshakeStatus());
        }
        catch (SSLException e) {
            wrapper.report(e);
        }
    }

    public static Cancellable connectSocket(AsyncServer server, String host, int port, ConnectCallback callback) {
        return AsyncSSLSocketWrapper.connectSocket(server, host, port, false, callback);
    }

    public static Cancellable connectSocket(AsyncServer server, String host, int port, boolean trustAllCerts, ConnectCallback callback) {
        SimpleCancellable cancellable = new SimpleCancellable();
        Cancellable connect = server.connectSocket(host, port, (ex, netSocket) -> {
            if (ex != null) {
                if (cancellable.setComplete()) {
                    callback.onConnectCompleted(ex, null);
                }
                return;
            }
            AsyncSSLSocketWrapper.handshake(netSocket, host, port, (trustAllCerts ? trustAllSSLContext : defaultSSLContext).createSSLEngine(host, port), (TrustManager[])(trustAllCerts ? trustAllManagers : null), trustAllCerts ? trustAllVerifier : null, true, (e, socket) -> {
                if (!cancellable.setComplete()) {
                    if (socket != null) {
                        socket.close();
                    }
                    return;
                }
                if (e != null) {
                    callback.onConnectCompleted(e, null);
                } else {
                    callback.onConnectCompleted(null, socket);
                }
            });
        });
        cancellable.setParent(connect);
        return cancellable;
    }

    private AsyncSSLSocketWrapper(AsyncSocket socket, String host, int port, SSLEngine sslEngine, TrustManager[] trustManagers, HostnameVerifier verifier, boolean clientMode) {
        this.mSocket = socket;
        this.hostnameVerifier = verifier;
        this.clientMode = clientMode;
        this.trustManagers = trustManagers;
        this.engine = sslEngine;
        this.mHost = host;
        this.mPort = port;
        this.engine.setUseClientMode(clientMode);
        this.mSink = new BufferedDataSink(socket);
        this.mSink.setWriteableCallback(new WritableCallback(){

            @Override
            public void onWriteable() {
                if (AsyncSSLSocketWrapper.this.mWriteableCallback != null) {
                    AsyncSSLSocketWrapper.this.mWriteableCallback.onWriteable();
                }
            }
        });
        this.mSocket.setEndCallback(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                if (AsyncSSLSocketWrapper.this.mEnded) {
                    return;
                }
                AsyncSSLSocketWrapper.this.mEnded = true;
                AsyncSSLSocketWrapper.this.mEndException = ex;
                if (!AsyncSSLSocketWrapper.this.pending.hasRemaining() && AsyncSSLSocketWrapper.this.mEndCallback != null) {
                    AsyncSSLSocketWrapper.this.mEndCallback.onCompleted(ex);
                }
            }
        });
        this.mSocket.setDataCallback(this.dataCallback);
    }

    public void onDataAvailable() {
        Util.emitAllData(this, this.pending);
        if (this.mEnded && !this.pending.hasRemaining() && this.mEndCallback != null) {
            this.mEndCallback.onCompleted(this.mEndException);
        }
    }

    @Override
    public SSLEngine getSSLEngine() {
        return this.engine;
    }

    void addToPending(ByteBufferList out, ByteBuffer mReadTmp) {
        mReadTmp.flip();
        if (mReadTmp.hasRemaining()) {
            out.add(mReadTmp);
        } else {
            ByteBufferList.reclaim(mReadTmp);
        }
    }

    @Override
    public void end() {
        this.mSocket.end();
    }

    public String getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    private void handleHandshakeStatus(SSLEngineResult.HandshakeStatus status) {
        block15: {
            if (status == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable task = this.engine.getDelegatedTask();
                task.run();
            }
            if (status == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                this.write(this.writeList);
            }
            if (status == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                this.dataCallback.onDataAvailable(this, new ByteBufferList());
            }
            try {
                if (this.finishedHandshake || this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break block15;
                if (this.clientMode) {
                    SSLException peerUnverifiedCause = null;
                    boolean trusted = false;
                    try {
                        this.peerCertificates = (X509Certificate[])this.engine.getSession().getPeerCertificates();
                        if (this.mHost != null) {
                            if (this.hostnameVerifier == null) {
                                StrictHostnameVerifier verifier = new StrictHostnameVerifier();
                                verifier.verify(this.mHost, StrictHostnameVerifier.getCNs((X509Certificate)this.peerCertificates[0]), StrictHostnameVerifier.getDNSSubjectAlts((X509Certificate)this.peerCertificates[0]));
                            } else if (!this.hostnameVerifier.verify(this.mHost, this.engine.getSession())) {
                                throw new SSLException("hostname <" + this.mHost + "> has been denied");
                            }
                        }
                        trusted = true;
                    }
                    catch (SSLException ex) {
                        peerUnverifiedCause = ex;
                    }
                    this.finishedHandshake = true;
                    if (!trusted) {
                        AsyncSSLException e = new AsyncSSLException(peerUnverifiedCause);
                        this.report(e);
                        if (!e.getIgnore()) {
                            throw e;
                        }
                    }
                } else {
                    this.finishedHandshake = true;
                }
                this.handshakeCallback.onHandshakeCompleted(null, this);
                this.handshakeCallback = null;
                this.mSocket.setClosedCallback(null);
                this.getServer().post(new Runnable(){

                    @Override
                    public void run() {
                        if (AsyncSSLSocketWrapper.this.mWriteableCallback != null) {
                            AsyncSSLSocketWrapper.this.mWriteableCallback.onWriteable();
                        }
                    }
                });
                this.onDataAvailable();
            }
            catch (Exception ex) {
                this.report(ex);
            }
        }
    }

    int calculateAlloc(int remaining) {
        int alloc = remaining * 3 / 2;
        if (alloc == 0) {
            alloc = 8192;
        }
        return alloc;
    }

    @Override
    public void write(ByteBufferList bb) {
        if (this.mWrapping) {
            return;
        }
        if (this.mSink.remaining() > 0) {
            return;
        }
        this.mWrapping = true;
        SSLEngineResult res = null;
        ByteBuffer writeBuf = ByteBufferList.obtain(this.calculateAlloc(bb.remaining()));
        while (!this.finishedHandshake || bb.remaining() != 0) {
            int remaining = bb.remaining();
            try {
                ByteBuffer[] arr = bb.getAllArray();
                res = this.engine.wrap(arr, writeBuf);
                bb.addAll(arr);
                writeBuf.flip();
                this.writeList.add(writeBuf);
                if (this.writeList.remaining() > 0) {
                    this.mSink.write(this.writeList);
                }
                int previousCapacity = writeBuf.capacity();
                writeBuf = null;
                if (res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    writeBuf = ByteBufferList.obtain(previousCapacity * 2);
                    remaining = -1;
                } else {
                    writeBuf = ByteBufferList.obtain(this.calculateAlloc(bb.remaining()));
                    this.handleHandshakeStatus(res.getHandshakeStatus());
                }
            }
            catch (SSLException e) {
                this.report(e);
            }
            if ((remaining != bb.remaining() || res != null && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) && this.mSink.remaining() == 0) continue;
        }
        this.mWrapping = false;
        ByteBufferList.reclaim(writeBuf);
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mWriteableCallback = handler;
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mWriteableCallback;
    }

    private void report(Exception e) {
        HandshakeCallback hs = this.handshakeCallback;
        if (hs != null) {
            this.handshakeCallback = null;
            this.mSocket.setDataCallback(new DataCallback.NullDataCallback());
            this.mSocket.end();
            this.mSocket.setClosedCallback(null);
            this.mSocket.close();
            hs.onHandshakeCompleted(e, null);
            return;
        }
        CompletedCallback cb = this.getEndCallback();
        if (cb != null) {
            cb.onCompleted(e);
        }
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        this.mDataCallback = callback;
    }

    @Override
    public DataCallback getDataCallback() {
        return this.mDataCallback;
    }

    @Override
    public boolean isChunked() {
        return this.mSocket.isChunked();
    }

    @Override
    public boolean isOpen() {
        return this.mSocket.isOpen();
    }

    @Override
    public void close() {
        this.mSocket.close();
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mSocket.setClosedCallback(handler);
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mSocket.getClosedCallback();
    }

    @Override
    public void setEndCallback(CompletedCallback callback) {
        this.mEndCallback = callback;
    }

    @Override
    public CompletedCallback getEndCallback() {
        return this.mEndCallback;
    }

    @Override
    public void pause() {
        this.mSocket.pause();
    }

    @Override
    public void resume() {
        this.mSocket.resume();
        this.onDataAvailable();
    }

    @Override
    public boolean isPaused() {
        return this.mSocket.isPaused();
    }

    @Override
    public AsyncServer getServer() {
        return this.mSocket.getServer();
    }

    @Override
    public AsyncSocket getSocket() {
        return this.mSocket;
    }

    @Override
    public DataEmitter getDataEmitter() {
        return this.mSocket;
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        return this.peerCertificates;
    }

    @Override
    public String charset() {
        return null;
    }

    private static Certificate selfSign(KeyPair keyPair, String subjectDN) throws Exception {
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcProvider);
        long now = System.currentTimeMillis();
        Date startDate = new Date(now);
        X500Name dnName = new X500Name("CN=" + subjectDN);
        BigInteger certSerialNumber = new BigInteger(Long.toString(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(1, 1);
        Date endDate = calendar.getTime();
        String signatureAlgorithm = "SHA256WithRSA";
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(keyPair.getPrivate());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(dnName, certSerialNumber, startDate, endDate, dnName, keyPair.getPublic());
        BasicConstraints basicConstraints = new BasicConstraints(true);
        certBuilder.addExtension(new ASN1ObjectIdentifier("2.5.29.19"), true, (ASN1Encodable)basicConstraints);
        return new JcaX509CertificateConverter().setProvider((Provider)bcProvider).getCertificate(certBuilder.build(contentSigner));
    }

    public static Pair<KeyPair, Certificate> selfSignCertificate(Context context, String subjectName) throws Exception {
        KeyPair pair;
        Certificate cert;
        File keyPath = context.getFileStreamPath(subjectName + "-key.txt");
        try {
            String[] keyParts = StreamUtility.readFile(keyPath).split("\n");
            X509EncodedKeySpec pub = new X509EncodedKeySpec(Base64.decode((String)keyParts[0], (int)0));
            PKCS8EncodedKeySpec priv = new PKCS8EncodedKeySpec(Base64.decode((String)keyParts[1], (int)0));
            cert = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(Base64.decode((String)keyParts[2], (int)0)));
            KeyFactory fact = KeyFactory.getInstance("RSA");
            pair = new KeyPair(fact.generatePublic(pub), fact.generatePrivate(priv));
        }
        catch (Exception e) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048);
            pair = keyGen.generateKeyPair();
            cert = AsyncSSLSocketWrapper.selfSign(pair, subjectName);
            StreamUtility.writeFile(keyPath, Base64.encodeToString((byte[])pair.getPublic().getEncoded(), (int)2) + "\n" + Base64.encodeToString((byte[])pair.getPrivate().getEncoded(), (int)2) + "\n" + Base64.encodeToString((byte[])cert.getEncoded(), (int)2));
        }
        return new Pair((Object)pair, (Object)cert);
    }

    public static AsyncSSLServerSocket listenSecure(Context context, AsyncServer server, String subjectName, InetAddress host, int port, ListenCallback handler) {
        ObjectHolder holder = new ObjectHolder();
        server.run(() -> {
            try {
                Pair<KeyPair, Certificate> keyCert = AsyncSSLSocketWrapper.selfSignCertificate(context, subjectName);
                KeyPair pair = (KeyPair)keyCert.first;
                Certificate cert = (Certificate)keyCert.second;
                holder.held = AsyncSSLSocketWrapper.listenSecure(server, pair.getPrivate(), cert, host, port, handler);
            }
            catch (Exception e) {
                handler.onCompleted(e);
            }
        });
        return (AsyncSSLServerSocket)holder.held;
    }

    public static AsyncSSLServerSocket listenSecure(AsyncServer server, String keyDer, String certDer, InetAddress host, int port, ListenCallback handler) {
        return AsyncSSLSocketWrapper.listenSecure(server, Base64.decode((String)keyDer, (int)0), Base64.decode((String)certDer, (int)0), host, port, handler);
    }

    public static AsyncSSLServerSocket listenSecure(AsyncServer server, byte[] keyDer, byte[] certDer, InetAddress host, int port, ListenCallback handler) {
        ObjectHolder holder = new ObjectHolder();
        server.run(() -> {
            try {
                PKCS8EncodedKeySpec key = new PKCS8EncodedKeySpec(keyDer);
                Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certDer));
                PrivateKey pk = KeyFactory.getInstance("RSA").generatePrivate(key);
                holder.held = AsyncSSLSocketWrapper.listenSecure(server, pk, cert, host, port, handler);
            }
            catch (Exception e) {
                handler.onCompleted(e);
            }
        });
        return (AsyncSSLServerSocket)holder.held;
    }

    public static AsyncSSLServerSocket listenSecure(AsyncServer server, final PrivateKey pk, final Certificate cert, InetAddress host, int port, ListenCallback handler) {
        ObjectHolder holder = new ObjectHolder();
        server.run(() -> {
            try {
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null);
                ks.setKeyEntry("key", pk, null, new Certificate[]{cert});
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("X509");
                kmf.init(ks, "".toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                final AsyncServerSocket socket = AsyncSSLSocketWrapper.listenSecure(server, sslContext, host, port, handler);
                holder.held = new AsyncSSLServerSocket(){

                    @Override
                    public PrivateKey getPrivateKey() {
                        return pk;
                    }

                    @Override
                    public Certificate getCertificate() {
                        return cert;
                    }

                    @Override
                    public void stop() {
                        socket.stop();
                    }

                    @Override
                    public int getLocalPort() {
                        return socket.getLocalPort();
                    }
                };
            }
            catch (Exception e) {
                handler.onCompleted(e);
            }
        });
        return (AsyncSSLServerSocket)holder.held;
    }

    public static AsyncServerSocket listenSecure(AsyncServer server, final SSLContext sslContext, InetAddress host, final int port, final ListenCallback handler) {
        final SSLEngineSNIConfigurator conf = new SSLEngineSNIConfigurator(){

            @Override
            public SSLEngine createEngine(SSLContext sslContext, String peerHost, int peerPort) {
                SSLEngine engine = super.createEngine(sslContext, peerHost, peerPort);
                engine.setEnabledCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"});
                return engine;
            }
        };
        return server.listen(host, port, new ListenCallback(){

            @Override
            public void onAccepted(AsyncSocket socket) {
                AsyncSSLSocketWrapper.handshake(socket, null, port, conf.createEngine(sslContext, null, port), null, null, false, (e, sslSocket) -> {
                    if (e != null) {
                        socket.close();
                        return;
                    }
                    handler.onAccepted(sslSocket);
                });
            }

            @Override
            public void onListening(AsyncServerSocket socket) {
                handler.onListening(socket);
            }

            @Override
            public void onCompleted(Exception ex) {
                handler.onCompleted(ex);
            }
        });
    }

    static {
        try {
            if (Build.VERSION.SDK_INT <= 15) {
                throw new Exception();
            }
            defaultSSLContext = SSLContext.getInstance("Default");
        }
        catch (Exception ex) {
            try {
                defaultSSLContext = SSLContext.getInstance("TLS");
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        for (X509Certificate cert : certs) {
                            if (cert == null || cert.getCriticalExtensionOIDs() == null) continue;
                            cert.getCriticalExtensionOIDs().remove("2.5.29.15");
                        }
                    }
                }};
                defaultSSLContext.init(null, trustAllCerts, null);
            }
            catch (Exception ex2) {
                ex.printStackTrace();
                ex2.printStackTrace();
            }
        }
        try {
            trustAllSSLContext = SSLContext.getInstance("TLS");
            trustAllManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            trustAllSSLContext.init(null, trustAllManagers, null);
            trustAllVerifier = (hostname, session) -> true;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    private static class ObjectHolder<T> {
        T held;

        private ObjectHolder() {
        }
    }

    public static interface HandshakeCallback {
        public void onHandshakeCompleted(Exception var1, AsyncSSLSocket var2);
    }
}

