/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.future;

import android.text.TextUtils;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.MultiFuture;
import com.koushikdutta.async.future.MultiTransformFuture;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.future.TypeConverter;
import java.io.InvalidObjectException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.json.JSONObject;

public class Converter<R> {
    Converters<Object, Object> outputs;
    MultiFuture<R> future = new MultiFuture();
    String futureMime;
    private static final String MIME_ALL = "*/*";
    public static final ConverterEntries Converters = new ConverterEntries();

    public static <T> Converter<T> convert(Future<T> future, String mime) {
        return new Converter(future, mime);
    }

    public static <T> Converter<T> convert(Future<T> future) {
        return Converter.convert(future, null);
    }

    protected ConverterEntries getConverters() {
        return new ConverterEntries(Converters);
    }

    protected Converter(Future future, String mime) {
        if (TextUtils.isEmpty((CharSequence)mime)) {
            mime = MIME_ALL;
        }
        this.futureMime = mime;
        this.future.setComplete(future);
    }

    private final synchronized <T> Future<T> to(Object value, Class<T> clazz, String mime) {
        if (clazz.isInstance(value)) {
            return new SimpleFuture<Object>(value);
        }
        return this.to(value.getClass(), clazz, mime);
    }

    private final synchronized <T> Future<T> to(Class fromClass, Class<T> clazz, String mime) {
        ArrayDeque<PathInfo> currentPath;
        ArrayDeque<PathInfo> bestMatch;
        MimedType<T> target;
        if (TextUtils.isEmpty((CharSequence)mime)) {
            mime = MIME_ALL;
        }
        if (this.outputs == null) {
            this.outputs = new Converters();
            ConverterEntries converters = this.getConverters();
            for (ConverterEntry entry : converters.list) {
                ((ConverterTransformers)this.outputs.ensure(entry.from)).put(entry.to, new MultiTransformer(entry.typeConverter, entry.to.mime, entry.distance));
            }
        }
        if (this.search(target = new MimedType<T>(clazz, mime), bestMatch = new ArrayDeque<PathInfo>(), currentPath = new ArrayDeque<PathInfo>(), new MimedType(fromClass, this.futureMime), new HashSet<MimedType>())) {
            PathInfo current = bestMatch.removeFirst();
            new SimpleFuture<MimedData<MultiFuture<R>>>(new MimedData<MultiFuture<R>>(this.future, this.futureMime)).setCallback(current.transformer);
            while (!bestMatch.isEmpty()) {
                PathInfo next = bestMatch.removeFirst();
                current.transformer.setCallback(next.transformer);
                current = next;
            }
            return current.transformer.then(from -> (Future)from.data);
        }
        return new SimpleFuture(new InvalidObjectException("unable to find converter"));
    }

    static String mimeReplace(String mime1, String mime2) {
        String[] parts = mime2.split("/");
        String[] myParts = mime1.split("/");
        String primary = !"*".equals(parts[0]) ? parts[0] : myParts[0];
        String secondary = !"*".equals(parts[1]) ? parts[1] : myParts[1];
        return primary + "/" + secondary;
    }

    public final <T> Future<T> to(Class<T> clazz) {
        return this.to(clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> boolean search(MimedType<T> target, ArrayDeque<PathInfo> bestMatch, ArrayDeque<PathInfo> currentPath, MimedType currentSearch, HashSet<MimedType> searched) {
        if (target.isTypeOf(currentSearch)) {
            bestMatch.clear();
            bestMatch.addAll(currentPath);
            return true;
        }
        if (!bestMatch.isEmpty() && PathInfo.distance(currentPath) >= PathInfo.distance(bestMatch)) {
            return false;
        }
        if (searched.contains(currentSearch)) {
            return false;
        }
        boolean found = false;
        searched.add(currentSearch);
        ConverterTransformers<Object, Object> converterTransformers = this.outputs.getAll(currentSearch);
        for (MimedType candidate : converterTransformers.keySet()) {
            MimedType newSearch = new MimedType(candidate.type, Converter.mimeReplace(currentSearch.mime, candidate.mime));
            PathInfo path = new PathInfo();
            path.transformer = (MultiTransformer)converterTransformers.get(candidate);
            path.mime = newSearch.mime;
            path.candidate = candidate;
            currentPath.addLast(path);
            try {
                found |= this.search(target, bestMatch, currentPath, newSearch, searched);
            }
            finally {
                currentPath.removeLast();
            }
        }
        if (found) {
            searched.remove(currentSearch);
        }
        return found;
    }

    public <T> Future<T> to(Class<T> clazz, String mime) {
        return this.future.then(from -> this.to(from, clazz, mime));
    }

    static {
        TypeConverter ByteArrayToByteBufferList = (from, fromMime) -> new SimpleFuture<ByteBufferList>(new ByteBufferList(ByteBufferList.deepCopy(ByteBuffer.wrap(from))));
        TypeConverter ByteBufferListToByteArray = (from, fromMime) -> new SimpleFuture<byte[]>(from.getAllByteArray());
        TypeConverter ByteBufferListToByteBuffer = (from, fromMime) -> new SimpleFuture<ByteBuffer>(from.getAll());
        TypeConverter ByteBufferListToString = (from, fromMime) -> new SimpleFuture<String>(from.peekString());
        TypeConverter ByteArrayToByteBuffer = (from, fromMime) -> new SimpleFuture<ByteBuffer>(ByteBufferList.deepCopy(ByteBuffer.wrap(from)));
        TypeConverter ByteBufferToByteBufferList = (from, fromMime) -> new SimpleFuture<ByteBufferList>(new ByteBufferList(ByteBufferList.deepCopy(from)));
        TypeConverter StringToByteArray = (from, fromMime) -> new SimpleFuture<byte[]>(from.getBytes());
        TypeConverter StringToJSONObject = (from, fromMime) -> new SimpleFuture<String>((String)from).thenConvert(JSONObject::new);
        TypeConverter JSONObjectToString = (from, fromMime) -> new SimpleFuture<JSONObject>((JSONObject)from).thenConvert(JSONObject::toString);
        TypeConverter ByteArrayToString = (from, fromMime) -> new SimpleFuture<String>(new String((byte[])from));
        Converters.addConverter(ByteBuffer.class, null, ByteBufferList.class, null, ByteBufferToByteBufferList);
        Converters.addConverter(String.class, null, byte[].class, "text/plain", StringToByteArray);
        Converters.addConverter(byte[].class, null, ByteBufferList.class, null, ByteArrayToByteBufferList);
        Converters.addConverter(ByteBufferList.class, null, byte[].class, null, ByteBufferListToByteArray);
        Converters.addConverter(ByteBufferList.class, null, ByteBuffer.class, null, ByteBufferListToByteBuffer);
        Converters.addConverter(ByteBufferList.class, "text/plain", String.class, null, ByteBufferListToString);
        Converters.addConverter(byte[].class, null, ByteBuffer.class, null, ByteArrayToByteBuffer);
        Converters.addConverter(String.class, "application/json", JSONObject.class, null, StringToJSONObject);
        Converters.addConverter(JSONObject.class, null, String.class, "application/json", JSONObjectToString);
        Converters.addConverter(byte[].class, "text/plain", String.class, null, ByteArrayToString);
    }

    public static class ConverterEntries {
        public ArrayList<ConverterEntry> list = new ArrayList();

        public ConverterEntries() {
        }

        public ConverterEntries(ConverterEntries other) {
            this.list.addAll(other.list);
        }

        public synchronized <F, T> void addConverter(Class<F> from, String fromMime, Class<T> to, String toMime, TypeConverter<T, F> typeConverter) {
            this.addConverter(from, fromMime, to, toMime, 1, typeConverter);
        }

        public synchronized <F, T> void addConverter(Class<F> from, String fromMime, Class<T> to, String toMime, int distance, TypeConverter<T, F> typeConverter) {
            if (TextUtils.isEmpty((CharSequence)fromMime)) {
                fromMime = Converter.MIME_ALL;
            }
            if (TextUtils.isEmpty((CharSequence)toMime)) {
                toMime = Converter.MIME_ALL;
            }
            this.list.add(new ConverterEntry<F, T>(from, fromMime, to, toMime, distance, typeConverter));
        }

        public synchronized boolean removeConverter(TypeConverter typeConverter) {
            for (ConverterEntry entry : this.list) {
                if (entry.typeConverter != typeConverter) continue;
                return this.list.remove(entry);
            }
            return false;
        }
    }

    static class ConverterEntry<F, T> {
        MimedType<F> from;
        MimedType<T> to;
        int distance;
        TypeConverter<T, F> typeConverter;

        ConverterEntry(Class<F> from, String fromMime, Class<T> to, String toMime, int distance, TypeConverter<T, F> typeConverter) {
            this.from = new MimedType<F>(from, fromMime);
            this.to = new MimedType<T>(to, toMime);
            this.distance = distance;
            this.typeConverter = typeConverter;
        }

        public int hashCode() {
            return this.from.hashCode() ^ this.to.hashCode();
        }

        public boolean equals(Object obj) {
            ConverterEntry other = (ConverterEntry)obj;
            return this.from.equals(other.from) && this.to.equals(other.to);
        }
    }

    static class PathInfo {
        MultiTransformer<Object, Object> transformer;
        String mime;
        MimedType candidate;

        PathInfo() {
        }

        static int distance(ArrayDeque<PathInfo> path) {
            int distance = 0;
            for (PathInfo entry : path) {
                distance += entry.transformer.distance;
            }
            return distance;
        }
    }

    static class Converters<F, T>
    extends EnsureHashMap<MimedType<F>, ConverterTransformers<F, T>> {
        Converters() {
        }

        @Override
        protected ConverterTransformers makeDefault() {
            return new ConverterTransformers();
        }

        private static <F, T> void add(ConverterTransformers<F, T> set, ConverterTransformers<F, T> more) {
            if (more == null) {
                return;
            }
            set.putAll(more);
        }

        public ConverterTransformers<F, T> getAll(MimedType<T> mimedType) {
            ConverterTransformers ret = new ConverterTransformers();
            for (MimedType candidate : this.keySet()) {
                if (!candidate.isTypeOf(mimedType)) continue;
                com.koushikdutta.async.future.Converter$Converters.add(ret, (ConverterTransformers)this.get(candidate));
            }
            return ret;
        }
    }

    static class ConverterTransformers<F, T>
    extends LinkedHashMap<MimedType<T>, MultiTransformer<T, F>> {
        ConverterTransformers() {
        }
    }

    static class MimedType<T> {
        Class<T> type;
        String mime;

        MimedType(Class<T> type, String mime) {
            this.type = type;
            this.mime = mime;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.mime.hashCode();
        }

        public boolean equals(Object obj) {
            MimedType other = (MimedType)obj;
            return this.type.equals(other.type) && this.mime.equals(other.mime);
        }

        public boolean isTypeOf(MimedType other) {
            if (!this.type.isAssignableFrom(other.type)) {
                return false;
            }
            return this.isTypeOf(other.mime);
        }

        public String primary() {
            return this.mime.split("/")[0];
        }

        public String secondary() {
            return this.mime.split("/")[1];
        }

        public boolean isTypeOf(String mime) {
            String[] otherParts = mime.split("/");
            String[] myParts = this.mime.split("/");
            if (!"*".equals(myParts[0]) && !otherParts[0].equals(myParts[0])) {
                return false;
            }
            return "*".equals(myParts[1]) || otherParts[1].equals(myParts[1]);
        }

        public String toString() {
            return this.type.getSimpleName() + " " + this.mime;
        }
    }

    static abstract class EnsureHashMap<K, V>
    extends LinkedHashMap<K, V> {
        EnsureHashMap() {
        }

        synchronized V ensure(K k) {
            if (!this.containsKey(k)) {
                this.put(k, this.makeDefault());
            }
            return this.get(k);
        }

        protected abstract V makeDefault();
    }

    static class MultiTransformer<T, F>
    extends MultiTransformFuture<MimedData<Future<T>>, MimedData<Future<F>>> {
        TypeConverter<T, F> converter;
        String converterMime;
        int distance;

        public MultiTransformer(TypeConverter<T, F> converter, String converterMime, int distance) {
            this.converter = converter;
            this.converterMime = converterMime;
            this.distance = distance;
        }

        @Override
        protected void transform(MimedData<Future<F>> converting) {
            String mime = converting.mime;
            MultiFuture converted = new MultiFuture();
            this.setComplete(new MimedData(converted, Converter.mimeReplace(mime, this.converterMime)));
            ((Future)converting.data).thenConvert(data -> this.converter.convert(data, mime)).setCallback((e, result1) -> {
                if (e != null) {
                    converted.setComplete(e);
                } else {
                    converted.setComplete(result1);
                }
            });
        }
    }

    static class MimedData<T> {
        T data;
        String mime;

        public MimedData(T data, String mime) {
            this.data = data;
            this.mime = mime;
        }
    }
}

