/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.koushikdutta.async.AsyncSSLException;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncHttpGet;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.AsyncHttpResponseImpl;
import com.koushikdutta.async.http.AsyncSocketMiddleware;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.HttpTransportMiddleware;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.RedirectLimitExceededException;
import com.koushikdutta.async.http.SSLEngineSNIConfigurator;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.WebSocketHandshakeException;
import com.koushikdutta.async.http.WebSocketImpl;
import com.koushikdutta.async.http.callback.HttpConnectCallback;
import com.koushikdutta.async.http.callback.RequestCallback;
import com.koushikdutta.async.http.spdy.SpdyMiddleware;
import com.koushikdutta.async.parser.AsyncParser;
import com.koushikdutta.async.parser.ByteBufferListParser;
import com.koushikdutta.async.parser.JSONArrayParser;
import com.koushikdutta.async.parser.JSONObjectParser;
import com.koushikdutta.async.parser.StringParser;
import com.koushikdutta.async.stream.OutputStreamDataCallback;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONObject;

public class AsyncHttpClient {
    private static AsyncHttpClient mDefaultInstance;
    final List<AsyncHttpClientMiddleware> mMiddleware = new CopyOnWriteArrayList<AsyncHttpClientMiddleware>();
    SpdyMiddleware sslSocketMiddleware;
    AsyncSocketMiddleware socketMiddleware;
    HttpTransportMiddleware httpTransportMiddleware;
    AsyncServer mServer;
    private static final String LOGTAG = "AsyncHttp";

    public static AsyncHttpClient getDefaultInstance() {
        if (mDefaultInstance == null) {
            mDefaultInstance = new AsyncHttpClient(AsyncServer.getDefault());
        }
        return mDefaultInstance;
    }

    public Collection<AsyncHttpClientMiddleware> getMiddleware() {
        return this.mMiddleware;
    }

    public void insertMiddleware(AsyncHttpClientMiddleware middleware) {
        this.mMiddleware.add(0, middleware);
    }

    public AsyncHttpClient(AsyncServer server) {
        this.mServer = server;
        this.socketMiddleware = new AsyncSocketMiddleware(this);
        this.insertMiddleware(this.socketMiddleware);
        this.sslSocketMiddleware = new SpdyMiddleware(this);
        this.insertMiddleware(this.sslSocketMiddleware);
        this.httpTransportMiddleware = new HttpTransportMiddleware();
        this.insertMiddleware(this.httpTransportMiddleware);
        this.sslSocketMiddleware.addEngineConfigurator(new SSLEngineSNIConfigurator());
    }

    @SuppressLint(value={"NewApi"})
    private static void setupAndroidProxy(AsyncHttpRequest request) {
        InetAddress address;
        List<Proxy> proxies;
        if (request.proxyHost != null) {
            return;
        }
        try {
            proxies = ProxySelector.getDefault().select(URI.create(request.getUri().toString()));
        }
        catch (Exception e) {
            return;
        }
        if (proxies.isEmpty()) {
            return;
        }
        Proxy proxy = proxies.get(0);
        if (proxy.type() != Proxy.Type.HTTP) {
            return;
        }
        if (!(proxy.address() instanceof InetSocketAddress)) {
            return;
        }
        InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
        String proxyHost = Build.VERSION.SDK_INT >= 14 ? proxyAddress.getHostString() : ((address = proxyAddress.getAddress()) != null ? address.getHostAddress() : proxyAddress.getHostName());
        request.enableProxy(proxyHost, proxyAddress.getPort());
    }

    public AsyncSocketMiddleware getSocketMiddleware() {
        return this.socketMiddleware;
    }

    public SpdyMiddleware getSSLSocketMiddleware() {
        return this.sslSocketMiddleware;
    }

    public Future<AsyncHttpResponse> execute(AsyncHttpRequest request, HttpConnectCallback callback) {
        FutureAsyncHttpResponse ret = new FutureAsyncHttpResponse();
        this.execute(request, 0, ret, callback);
        return ret;
    }

    public Future<AsyncHttpResponse> execute(String uri, HttpConnectCallback callback) {
        return this.execute(new AsyncHttpGet(uri), callback);
    }

    private void reportConnectedCompleted(FutureAsyncHttpResponse cancel, Exception ex, AsyncHttpResponseImpl response, AsyncHttpRequest request, HttpConnectCallback callback) {
        boolean complete;
        assert (callback != null);
        this.mServer.removeAllCallbacks(cancel.scheduled);
        if (ex != null) {
            request.loge("Connection error", ex);
            complete = cancel.setComplete(ex);
        } else {
            request.logd("Connection successful");
            complete = cancel.setComplete(response);
        }
        if (complete) {
            callback.onConnectCompleted(ex, response);
            assert (ex != null || response.socket() == null || response.getDataCallback() != null || response.isPaused());
            return;
        }
        if (response != null) {
            response.setDataCallback(new DataCallback.NullDataCallback());
            response.close();
        }
    }

    private void execute(final AsyncHttpRequest request, final int redirectCount, final FutureAsyncHttpResponse cancel, final HttpConnectCallback callback) {
        if (this.mServer.isAffinityThread()) {
            this.executeAffinity(request, redirectCount, cancel, callback);
        } else {
            this.mServer.post(new Runnable(){

                @Override
                public void run() {
                    AsyncHttpClient.this.executeAffinity(request, redirectCount, cancel, callback);
                }
            });
        }
    }

    private static long getTimeoutRemaining(AsyncHttpRequest request) {
        return request.getTimeout();
    }

    private static void copyHeader(AsyncHttpRequest from, AsyncHttpRequest to, String header) {
        String value = from.getHeaders().get(header);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            to.getHeaders().set(header, value);
        }
    }

    private void executeAffinity(final AsyncHttpRequest request, final int redirectCount, final FutureAsyncHttpResponse cancel, final HttpConnectCallback callback) {
        assert (this.mServer.isAffinityThread());
        if (redirectCount > 15) {
            this.reportConnectedCompleted(cancel, new RedirectLimitExceededException("too many redirects"), null, request, callback);
            return;
        }
        Uri uri = request.getUri();
        final AsyncHttpClientMiddleware.OnResponseCompleteDataOnRequestSentData data = new AsyncHttpClientMiddleware.OnResponseCompleteDataOnRequestSentData();
        request.executionTime = System.currentTimeMillis();
        data.request = request;
        request.logd("Executing request.");
        for (AsyncHttpClientMiddleware middleware : this.mMiddleware) {
            middleware.onRequest(data);
        }
        if (request.getTimeout() > 0) {
            cancel.timeoutRunnable = new Runnable(){

                @Override
                public void run() {
                    if (data.socketCancellable != null) {
                        data.socketCancellable.cancel();
                        if (data.socket != null) {
                            data.socket.close();
                        }
                    }
                    AsyncHttpClient.this.reportConnectedCompleted(cancel, new TimeoutException(), null, request, callback);
                }
            };
            cancel.scheduled = this.mServer.postDelayed(cancel.timeoutRunnable, AsyncHttpClient.getTimeoutRemaining(request));
        }
        data.connectCallback = new ConnectCallback(){
            boolean reported;

            @Override
            public void onConnectCompleted(Exception ex, AsyncSocket socket) {
                if (this.reported && socket != null) {
                    socket.setDataCallback(new DataCallback.NullDataCallback());
                    socket.setEndCallback(new CompletedCallback.NullCompletedCallback());
                    socket.close();
                    throw new AssertionError((Object)"double connect callback");
                }
                this.reported = true;
                request.logv("socket connected");
                if (cancel.isCancelled()) {
                    if (socket != null) {
                        socket.close();
                    }
                    return;
                }
                if (cancel.timeoutRunnable != null) {
                    AsyncHttpClient.this.mServer.removeAllCallbacks(cancel.scheduled);
                }
                if (ex != null) {
                    AsyncHttpClient.this.reportConnectedCompleted(cancel, ex, null, request, callback);
                    return;
                }
                data.socket = socket;
                cancel.socket = socket;
                AsyncHttpClient.this.executeSocket(request, redirectCount, cancel, callback, data);
            }
        };
        AsyncHttpClient.setupAndroidProxy(request);
        if (request.getBody() != null && request.getHeaders().get("Content-Type") == null) {
            request.getHeaders().set("Content-Type", request.getBody().getContentType());
        }
        for (AsyncHttpClientMiddleware middleware : this.mMiddleware) {
            Cancellable socketCancellable = middleware.getSocket(data);
            if (socketCancellable == null) continue;
            data.socketCancellable = socketCancellable;
            cancel.setParent(socketCancellable);
            return;
        }
        IllegalArgumentException unsupportedURI = new IllegalArgumentException("invalid uri=" + request.getUri() + " middlewares=" + this.mMiddleware);
        this.reportConnectedCompleted(cancel, unsupportedURI, null, request, callback);
    }

    private void executeSocket(final AsyncHttpRequest request, final int redirectCount, final FutureAsyncHttpResponse cancel, final HttpConnectCallback callback, final AsyncHttpClientMiddleware.OnResponseCompleteDataOnRequestSentData data) {
        final AsyncHttpResponseImpl ret = new AsyncHttpResponseImpl(request){

            @Override
            protected void onRequestCompleted(Exception ex) {
                if (ex != null) {
                    AsyncHttpClient.this.reportConnectedCompleted(cancel, ex, null, request, callback);
                    return;
                }
                request.logv("request completed");
                if (cancel.isCancelled()) {
                    return;
                }
                if (cancel.timeoutRunnable != null && this.mHeaders == null) {
                    AsyncHttpClient.this.mServer.removeAllCallbacks(cancel.scheduled);
                    cancel.scheduled = AsyncHttpClient.this.mServer.postDelayed(cancel.timeoutRunnable, AsyncHttpClient.getTimeoutRemaining(request));
                }
                for (AsyncHttpClientMiddleware middleware : AsyncHttpClient.this.mMiddleware) {
                    middleware.onRequestSent(data);
                }
            }

            @Override
            public void setDataEmitter(DataEmitter emitter) {
                data.bodyEmitter = emitter;
                for (AsyncHttpClientMiddleware middleware : AsyncHttpClient.this.mMiddleware) {
                    middleware.onBodyDecoder(data);
                }
                super.setDataEmitter(data.bodyEmitter);
                Headers headers = this.mHeaders;
                int responseCode = this.code();
                if ((responseCode == 301 || responseCode == 302 || responseCode == 307) && request.getFollowRedirect()) {
                    Uri redirect;
                    String location = headers.get("Location");
                    try {
                        redirect = Uri.parse((String)location);
                        if (redirect.getScheme() == null) {
                            redirect = Uri.parse((String)new URL(new URL(request.getUri().toString()), location).toString());
                        }
                    }
                    catch (Exception e) {
                        AsyncHttpClient.this.reportConnectedCompleted(cancel, e, this, request, callback);
                        return;
                    }
                    String method = request.getMethod().equals("HEAD") ? "HEAD" : "GET";
                    AsyncHttpRequest newReq = new AsyncHttpRequest(redirect, method);
                    newReq.executionTime = request.executionTime;
                    newReq.logLevel = request.logLevel;
                    newReq.LOGTAG = request.LOGTAG;
                    newReq.proxyHost = request.proxyHost;
                    newReq.proxyPort = request.proxyPort;
                    AsyncHttpClient.setupAndroidProxy(newReq);
                    AsyncHttpClient.copyHeader(request, newReq, "User-Agent");
                    AsyncHttpClient.copyHeader(request, newReq, "Range");
                    request.logi("Redirecting");
                    newReq.logi("Redirected");
                    AsyncHttpClient.this.execute(newReq, redirectCount + 1, cancel, callback);
                    this.setDataCallback(new DataCallback.NullDataCallback());
                    return;
                }
                request.logv("Final (post cache response) headers:\n" + this.toString());
                AsyncHttpClient.this.reportConnectedCompleted(cancel, null, this, request, callback);
            }

            @Override
            protected void onHeadersReceived() {
                super.onHeadersReceived();
                if (cancel.isCancelled()) {
                    return;
                }
                if (cancel.timeoutRunnable != null) {
                    AsyncHttpClient.this.mServer.removeAllCallbacks(cancel.scheduled);
                }
                request.logv("Received headers:\n" + this.toString());
                for (AsyncHttpClientMiddleware middleware : AsyncHttpClient.this.mMiddleware) {
                    middleware.onHeadersReceived(data);
                }
            }

            @Override
            protected void report(Exception ex) {
                AsyncSocket socket;
                if (ex != null) {
                    request.loge("exception during response", ex);
                }
                if (cancel.isCancelled()) {
                    return;
                }
                if (ex instanceof AsyncSSLException) {
                    request.loge("SSL Exception", ex);
                    AsyncSSLException ase = (AsyncSSLException)ex;
                    request.onHandshakeException(ase);
                    if (ase.getIgnore()) {
                        return;
                    }
                }
                if ((socket = this.socket()) == null) {
                    return;
                }
                super.report(ex);
                if (!(socket.isOpen() && ex == null || this.headers() != null || ex == null)) {
                    AsyncHttpClient.this.reportConnectedCompleted(cancel, ex, null, request, callback);
                }
                data.exception = ex;
                for (AsyncHttpClientMiddleware middleware : AsyncHttpClient.this.mMiddleware) {
                    middleware.onResponseComplete(data);
                }
            }

            @Override
            public AsyncSocket detachSocket() {
                request.logd("Detaching socket");
                AsyncSocket socket = this.socket();
                if (socket == null) {
                    return null;
                }
                socket.setWriteableCallback(null);
                socket.setClosedCallback(null);
                socket.setEndCallback(null);
                socket.setDataCallback(null);
                this.setSocket(null);
                return socket;
            }
        };
        data.sendHeadersCallback = new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                if (ex != null) {
                    ret.report(ex);
                } else {
                    ret.onHeadersSent();
                }
            }
        };
        data.receiveHeadersCallback = new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                if (ex != null) {
                    ret.report(ex);
                } else {
                    ret.onHeadersReceived();
                }
            }
        };
        data.response = ret;
        ret.setSocket(data.socket);
        for (AsyncHttpClientMiddleware middleware : this.mMiddleware) {
            if (middleware.exchangeHeaders(data)) break;
        }
    }

    public Future<ByteBufferList> executeByteBufferList(AsyncHttpRequest request, DownloadCallback callback) {
        return this.execute(request, new ByteBufferListParser(), callback);
    }

    public Future<String> executeString(AsyncHttpRequest req, StringCallback callback) {
        return this.execute(req, new StringParser(), callback);
    }

    public Future<JSONObject> executeJSONObject(AsyncHttpRequest req, JSONObjectCallback callback) {
        return this.execute(req, new JSONObjectParser(), callback);
    }

    public Future<JSONArray> executeJSONArray(AsyncHttpRequest req, JSONArrayCallback callback) {
        return this.execute(req, new JSONArrayParser(), callback);
    }

    private <T> void invokeWithAffinity(RequestCallback<T> callback, SimpleFuture<T> future, AsyncHttpResponse response, Exception e, T result) {
        boolean complete = e != null ? future.setComplete(e) : future.setComplete(result);
        if (!complete) {
            return;
        }
        if (callback != null) {
            callback.onCompleted(e, response, result);
        }
    }

    private <T> void invoke(final RequestCallback<T> callback, final SimpleFuture<T> future, final AsyncHttpResponse response, final Exception e, final T result) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AsyncHttpClient.this.invokeWithAffinity(callback, future, response, e, result);
            }
        };
        this.mServer.post(runnable);
    }

    private void invokeProgress(RequestCallback callback, AsyncHttpResponse response, long downloaded, long total) {
        if (callback != null) {
            callback.onProgress(response, downloaded, total);
        }
    }

    private void invokeConnect(RequestCallback callback, AsyncHttpResponse response) {
        if (callback != null) {
            callback.onConnect(response);
        }
    }

    public Future<File> executeFile(AsyncHttpRequest req, String filename, final FileCallback callback) {
        BufferedOutputStream fout;
        final File file = new File(filename);
        file.getParentFile().mkdirs();
        try {
            fout = new BufferedOutputStream(new FileOutputStream(file), 8192);
        }
        catch (FileNotFoundException e) {
            SimpleFuture<File> ret = new SimpleFuture<File>();
            ret.setComplete(e);
            return ret;
        }
        final FutureAsyncHttpResponse cancel = new FutureAsyncHttpResponse();
        final SimpleFuture<File> ret = new SimpleFuture<File>(){

            @Override
            public void cancelCleanup() {
                try {
                    ((AsyncHttpResponse)cancel.get()).setDataCallback(new DataCallback.NullDataCallback());
                    ((AsyncHttpResponse)cancel.get()).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fout.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                file.delete();
            }
        };
        ret.setParent(cancel);
        this.execute(req, 0, cancel, new HttpConnectCallback(){
            long mDownloaded = 0L;

            @Override
            public void onConnectCompleted(Exception ex, final AsyncHttpResponse response) {
                if (ex != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    file.delete();
                    AsyncHttpClient.this.invoke(callback, ret, response, ex, null);
                    return;
                }
                AsyncHttpClient.this.invokeConnect(callback, response);
                final long contentLength = HttpUtil.contentLength(response.headers());
                response.setDataCallback(new OutputStreamDataCallback(fout){

                    @Override
                    public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                        mDownloaded += (long)bb.remaining();
                        super.onDataAvailable(emitter, bb);
                        AsyncHttpClient.this.invokeProgress(callback, response, mDownloaded, contentLength);
                    }
                });
                response.setEndCallback(new CompletedCallback(){

                    @Override
                    public void onCompleted(Exception ex) {
                        try {
                            fout.close();
                        }
                        catch (IOException e) {
                            ex = e;
                        }
                        if (ex != null) {
                            file.delete();
                            AsyncHttpClient.this.invoke(callback, ret, response, ex, null);
                        } else {
                            AsyncHttpClient.this.invoke(callback, ret, response, null, file);
                        }
                    }
                });
            }
        });
        return ret;
    }

    public <T> SimpleFuture<T> execute(AsyncHttpRequest req, final AsyncParser<T> parser, final RequestCallback<T> callback) {
        FutureAsyncHttpResponse cancel = new FutureAsyncHttpResponse();
        final SimpleFuture ret = new SimpleFuture();
        this.execute(req, 0, cancel, new HttpConnectCallback(){

            @Override
            public void onConnectCompleted(Exception ex, final AsyncHttpResponse response) {
                if (ex != null) {
                    AsyncHttpClient.this.invoke(callback, ret, response, ex, null);
                    return;
                }
                AsyncHttpClient.this.invokeConnect(callback, response);
                Future parsed = parser.parse(response).setCallback(new FutureCallback<T>(){

                    @Override
                    public void onCompleted(Exception e, T result) {
                        AsyncHttpClient.this.invoke(callback, ret, response, e, result);
                    }
                });
                ret.setParent(parsed);
            }
        });
        ret.setParent(cancel);
        return ret;
    }

    public Future<WebSocket> websocket(final AsyncHttpRequest req, String protocol, final WebSocketConnectCallback callback) {
        WebSocketImpl.addWebSocketUpgradeHeaders(req, protocol);
        final SimpleFuture<WebSocket> ret = new SimpleFuture<WebSocket>();
        Future<AsyncHttpResponse> connect = this.execute(req, new HttpConnectCallback(){

            @Override
            public void onConnectCompleted(Exception ex, AsyncHttpResponse response) {
                if (ex != null) {
                    if (ret.setComplete(ex) && callback != null) {
                        callback.onCompleted(ex, null);
                    }
                    return;
                }
                WebSocket ws = WebSocketImpl.finishHandshake(req.getHeaders(), response);
                if (ws == null ? !ret.setComplete(ex = new WebSocketHandshakeException("Unable to complete websocket handshake")) : !ret.setComplete(ws)) {
                    return;
                }
                if (callback != null) {
                    callback.onCompleted(ex, ws);
                }
            }
        });
        ret.setParent(connect);
        return ret;
    }

    public Future<WebSocket> websocket(String uri, String protocol, WebSocketConnectCallback callback) {
        AsyncHttpGet get = new AsyncHttpGet(uri.replace("ws://", "http://").replace("wss://", "https://"));
        return this.websocket(get, protocol, callback);
    }

    public AsyncServer getServer() {
        return this.mServer;
    }

    public static interface WebSocketConnectCallback {
        public void onCompleted(Exception var1, WebSocket var2);
    }

    public static abstract class FileCallback
    extends RequestCallbackBase<File> {
    }

    public static abstract class JSONArrayCallback
    extends RequestCallbackBase<JSONArray> {
    }

    public static abstract class JSONObjectCallback
    extends RequestCallbackBase<JSONObject> {
    }

    public static abstract class StringCallback
    extends RequestCallbackBase<String> {
    }

    public static abstract class DownloadCallback
    extends RequestCallbackBase<ByteBufferList> {
    }

    public static abstract class RequestCallbackBase<T>
    implements RequestCallback<T> {
        @Override
        public void onProgress(AsyncHttpResponse response, long downloaded, long total) {
        }

        @Override
        public void onConnect(AsyncHttpResponse response) {
        }
    }

    private class FutureAsyncHttpResponse
    extends SimpleFuture<AsyncHttpResponse> {
        public AsyncSocket socket;
        public Object scheduled;
        public Runnable timeoutRunnable;

        private FutureAsyncHttpResponse() {
        }

        @Override
        public boolean cancel() {
            if (!super.cancel()) {
                return false;
            }
            if (this.socket != null) {
                this.socket.setDataCallback(new DataCallback.NullDataCallback());
                this.socket.close();
            }
            if (this.scheduled != null) {
                AsyncHttpClient.this.mServer.removeAllCallbacks(this.scheduled);
            }
            return true;
        }
    }
}

