/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataEmitterReader;
import com.koushikdutta.async.callback.DataCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

abstract class HybiParser {
    private static final String TAG = "HybiParser";
    private boolean mMasking = true;
    private boolean mDeflate = false;
    private int mStage;
    private boolean mFinal;
    private boolean mMasked;
    private boolean mDeflated;
    private int mOpcode;
    private int mLengthSize;
    private int mLength;
    private int mMode;
    private byte[] mMask = new byte[0];
    private byte[] mPayload = new byte[0];
    private boolean mClosed = false;
    private final ByteArrayOutputStream mBuffer = new ByteArrayOutputStream();
    private final byte[] mInflateBuffer = new byte[4096];
    private static final int BYTE = 255;
    private static final int FIN = 128;
    private static final int MASK = 128;
    private static final int RSV1 = 64;
    private static final int RSV2 = 32;
    private static final int RSV3 = 16;
    private static final int OPCODE = 15;
    private static final int LENGTH = 127;
    private static final int MODE_TEXT = 1;
    private static final int MODE_BINARY = 2;
    private static final int OP_CONTINUATION = 0;
    private static final int OP_TEXT = 1;
    private static final int OP_BINARY = 2;
    private static final int OP_CLOSE = 8;
    private static final int OP_PING = 9;
    private static final int OP_PONG = 10;
    private static final List<Integer> OPCODES = Arrays.asList(0, 1, 2, 8, 9, 10);
    private static final List<Integer> FRAGMENTED_OPCODES = Arrays.asList(0, 1, 2);
    DataCallback mStage0 = new DataCallback(){

        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            try {
                HybiParser.this.parseOpcode(bb.get());
            }
            catch (ProtocolError e) {
                HybiParser.this.report(e);
                e.printStackTrace();
            }
            HybiParser.this.parse();
        }
    };
    DataCallback mStage1 = new DataCallback(){

        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            HybiParser.this.parseLength(bb.get());
            HybiParser.this.parse();
        }
    };
    DataCallback mStage2 = new DataCallback(){

        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            byte[] bytes = new byte[HybiParser.this.mLengthSize];
            bb.get(bytes);
            try {
                HybiParser.this.parseExtendedLength(bytes);
            }
            catch (ProtocolError e) {
                HybiParser.this.report(e);
                e.printStackTrace();
            }
            HybiParser.this.parse();
        }
    };
    DataCallback mStage3 = new DataCallback(){

        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            HybiParser.access$402(HybiParser.this, new byte[4]);
            bb.get(HybiParser.this.mMask);
            HybiParser.this.mStage = 4;
            HybiParser.this.parse();
        }
    };
    DataCallback mStage4 = new DataCallback(){

        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            assert (bb.remaining() == HybiParser.this.mLength);
            HybiParser.access$702(HybiParser.this, new byte[HybiParser.this.mLength]);
            bb.get(HybiParser.this.mPayload);
            try {
                HybiParser.this.emitFrame();
            }
            catch (IOException e) {
                HybiParser.this.report(e);
                e.printStackTrace();
            }
            HybiParser.this.mStage = 0;
            HybiParser.this.parse();
        }
    };
    private DataEmitterReader mReader = new DataEmitterReader();
    private static final long BASE = 2L;
    private static final long _2_TO_8_ = 256L;
    private static final long _2_TO_16_ = 65536L;
    private static final long _2_TO_24 = 0x1000000L;
    private static final long _2_TO_32_ = 0x100000000L;
    private static final long _2_TO_40_ = 0x10000000000L;
    private static final long _2_TO_48_ = 0x1000000000000L;
    private static final long _2_TO_56_ = 0x100000000000000L;

    private static byte[] mask(byte[] payload, byte[] mask, int offset) {
        if (mask.length == 0) {
            return payload;
        }
        for (int i = 0; i < payload.length - offset; ++i) {
            payload[offset + i] = (byte)(payload[offset + i] ^ mask[i % 4]);
        }
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] inflate(byte[] payload) throws DataFormatException {
        int chunkSize;
        ByteArrayOutputStream inflated = new ByteArrayOutputStream();
        Inflater inflater = new Inflater(true);
        inflater.setInput(payload);
        while (!inflater.needsInput()) {
            chunkSize = inflater.inflate(this.mInflateBuffer);
            inflated.write(this.mInflateBuffer, 0, chunkSize);
        }
        inflater.setInput(new byte[]{0, 0, -1, -1});
        while (!inflater.needsInput()) {
            chunkSize = inflater.inflate(this.mInflateBuffer);
            inflated.write(this.mInflateBuffer, 0, chunkSize);
        }
        try {
            byte[] byArray = inflated.toByteArray();
            return byArray;
        }
        finally {
            inflater.end();
        }
    }

    public void setMasking(boolean masking) {
        this.mMasking = masking;
    }

    public void setDeflate(boolean deflate) {
        this.mDeflate = deflate;
    }

    void parse() {
        switch (this.mStage) {
            case 0: {
                this.mReader.read(1, this.mStage0);
                break;
            }
            case 1: {
                this.mReader.read(1, this.mStage1);
                break;
            }
            case 2: {
                this.mReader.read(this.mLengthSize, this.mStage2);
                break;
            }
            case 3: {
                this.mReader.read(4, this.mStage3);
                break;
            }
            case 4: {
                this.mReader.read(this.mLength, this.mStage4);
            }
        }
    }

    public HybiParser(DataEmitter socket) {
        socket.setDataCallback(this.mReader);
        this.parse();
    }

    private void parseOpcode(byte data) throws ProtocolError {
        boolean rsv3;
        boolean rsv1 = (data & 0x40) == 64;
        boolean rsv2 = (data & 0x20) == 32;
        boolean bl = rsv3 = (data & 0x10) == 16;
        if (!this.mDeflate && rsv1 || rsv2 || rsv3) {
            throw new ProtocolError("RSV not zero");
        }
        this.mFinal = (data & 0x80) == 128;
        this.mOpcode = data & 0xF;
        this.mDeflated = rsv1;
        this.mMask = new byte[0];
        this.mPayload = new byte[0];
        if (!OPCODES.contains(this.mOpcode)) {
            throw new ProtocolError("Bad opcode");
        }
        if (!FRAGMENTED_OPCODES.contains(this.mOpcode) && !this.mFinal) {
            throw new ProtocolError("Expected non-final packet");
        }
        this.mStage = 1;
    }

    private void parseLength(byte data) {
        this.mMasked = (data & 0x80) == 128;
        this.mLength = data & 0x7F;
        if (this.mLength >= 0 && this.mLength <= 125) {
            this.mStage = this.mMasked ? 3 : 4;
        } else {
            this.mLengthSize = this.mLength == 126 ? 2 : 8;
            this.mStage = 2;
        }
    }

    private void parseExtendedLength(byte[] buffer) throws ProtocolError {
        this.mLength = this.getInteger(buffer);
        this.mStage = this.mMasked ? 3 : 4;
    }

    public byte[] frame(String data) {
        return this.frame(1, data, -1);
    }

    public byte[] frame(byte[] data) {
        return this.frame(2, data, -1);
    }

    public byte[] frame(byte[] data, int offset, int length) {
        return this.frame(2, data, -1, offset, length);
    }

    public byte[] pingFrame(String data) {
        return this.frame(9, data, -1);
    }

    public byte[] pongFrame(String data) {
        return this.frame(10, data, -1);
    }

    private byte[] frame(int opcode, byte[] data, int errorCode) {
        return this.frame(opcode, data, errorCode, 0, data.length);
    }

    private byte[] frame(int opcode, String data, int errorCode) {
        return this.frame(opcode, this.decode(data), errorCode);
    }

    private byte[] frame(int opcode, byte[] data, int errorCode, int dataOffset, int dataLength) {
        if (this.mClosed) {
            return null;
        }
        byte[] buffer = data;
        int insert = errorCode > 0 ? 2 : 0;
        int length = dataLength + insert - dataOffset;
        int header = length <= 125 ? 2 : (length <= 65535 ? 4 : 10);
        int offset = header + (this.mMasking ? 4 : 0);
        int masked = this.mMasking ? 128 : 0;
        byte[] frame = new byte[length + offset];
        frame[0] = (byte)(0xFFFFFF80 | (byte)opcode);
        if (length <= 125) {
            frame[1] = (byte)(masked | length);
        } else if (length <= 65535) {
            frame[1] = (byte)(masked | 0x7E);
            frame[2] = (byte)(length / 256);
            frame[3] = (byte)(length & 0xFF);
        } else {
            frame[1] = (byte)(masked | 0x7F);
            frame[2] = (byte)((long)length / 0x100000000000000L & 0xFFL);
            frame[3] = (byte)((long)length / 0x1000000000000L & 0xFFL);
            frame[4] = (byte)((long)length / 0x10000000000L & 0xFFL);
            frame[5] = (byte)((long)length / 0x100000000L & 0xFFL);
            frame[6] = (byte)((long)length / 0x1000000L & 0xFFL);
            frame[7] = (byte)((long)length / 65536L & 0xFFL);
            frame[8] = (byte)((long)length / 256L & 0xFFL);
            frame[9] = (byte)(length & 0xFF);
        }
        if (errorCode > 0) {
            frame[offset] = (byte)(errorCode / 256 & 0xFF);
            frame[offset + 1] = (byte)(errorCode & 0xFF);
        }
        System.arraycopy(buffer, dataOffset, frame, offset + insert, dataLength - dataOffset);
        if (this.mMasking) {
            byte[] mask = new byte[]{(byte)Math.floor(Math.random() * 256.0), (byte)Math.floor(Math.random() * 256.0), (byte)Math.floor(Math.random() * 256.0), (byte)Math.floor(Math.random() * 256.0)};
            System.arraycopy(mask, 0, frame, header, mask.length);
            HybiParser.mask(frame, mask, offset);
        }
        return frame;
    }

    public void close(int code, String reason) {
        if (this.mClosed) {
            return;
        }
        this.sendFrame(this.frame(8, reason, code));
        this.mClosed = true;
    }

    private void emitFrame() throws IOException {
        int opcode;
        byte[] payload = HybiParser.mask(this.mPayload, this.mMask, 0);
        if (this.mDeflated) {
            try {
                payload = this.inflate(payload);
            }
            catch (DataFormatException e) {
                throw new IOException("Invalid deflated data");
            }
        }
        if ((opcode = this.mOpcode) == 0) {
            if (this.mMode == 0) {
                throw new ProtocolError("Mode was not set.");
            }
            this.mBuffer.write(payload);
            if (this.mFinal) {
                byte[] message = this.mBuffer.toByteArray();
                if (this.mMode == 1) {
                    this.onMessage(this.encode(message));
                } else {
                    this.onMessage(message);
                }
                this.reset();
            }
        } else if (opcode == 1) {
            if (this.mFinal) {
                String messageText = this.encode(payload);
                this.onMessage(messageText);
            } else {
                this.mMode = 1;
                this.mBuffer.write(payload);
            }
        } else if (opcode == 2) {
            if (this.mFinal) {
                this.onMessage(payload);
            } else {
                this.mMode = 2;
                this.mBuffer.write(payload);
            }
        } else if (opcode == 8) {
            int code = payload.length >= 2 ? 256 * (payload[0] & 0xFF) + (payload[1] & 0xFF) : 0;
            String reason = payload.length > 2 ? this.encode(this.slice(payload, 2)) : null;
            this.onDisconnect(code, reason);
        } else if (opcode == 9) {
            if (payload.length > 125) {
                throw new ProtocolError("Ping payload too large");
            }
            String message = this.encode(payload);
            this.sendFrame(this.frame(10, payload, -1));
            this.onPing(message);
        } else if (opcode == 10) {
            String message = this.encode(payload);
            this.onPong(message);
        }
    }

    protected abstract void onMessage(byte[] var1);

    protected abstract void onMessage(String var1);

    protected abstract void onPong(String var1);

    protected abstract void onPing(String var1);

    protected abstract void onDisconnect(int var1, String var2);

    protected abstract void report(Exception var1);

    protected abstract void sendFrame(byte[] var1);

    private void reset() {
        this.mMode = 0;
        this.mBuffer.reset();
    }

    private String encode(byte[] buffer) {
        try {
            return new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] decode(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private int getInteger(byte[] bytes) throws ProtocolError {
        long i = HybiParser.byteArrayToLong(bytes, 0, bytes.length);
        if (i < 0L || i > Integer.MAX_VALUE) {
            throw new ProtocolError("Bad integer: " + i);
        }
        return (int)i;
    }

    private byte[] slice(byte[] array, int start) {
        byte[] copy = new byte[array.length - start];
        System.arraycopy(array, start, copy, 0, array.length - start);
        return copy;
    }

    private static long byteArrayToLong(byte[] b, int offset, int length) {
        if (b.length < length) {
            throw new IllegalArgumentException("length must be less than or equal to b.length");
        }
        long value = 0L;
        for (int i = 0; i < length; ++i) {
            int shift = (length - 1 - i) * 8;
            value += (long)((b[i + offset] & 0xFF) << shift);
        }
        return value;
    }

    static /* synthetic */ byte[] access$402(HybiParser x0, byte[] x1) {
        x0.mMask = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$702(HybiParser x0, byte[] x1) {
        x0.mPayload = x1;
        return x1;
    }

    public static class ProtocolError
    extends IOException {
        public ProtocolError(String detailMessage) {
            super(detailMessage);
        }
    }
}

