/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.net.Uri;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Multimap
extends LinkedHashMap<String, List<String>>
implements Iterable<NameValuePair> {
    private static final StringDecoder QUERY_DECODER = new StringDecoder(){

        @Override
        public String decode(String s) {
            return Uri.decode((String)s);
        }
    };
    private static final StringDecoder URL_DECODER = new StringDecoder(){

        @Override
        public String decode(String s) {
            return URLDecoder.decode(s);
        }
    };

    public Multimap() {
    }

    protected List<String> newList() {
        return new ArrayList<String>();
    }

    public String getString(String name) {
        List ret = (List)this.get(name);
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return (String)ret.get(0);
    }

    public void add(String name, String value) {
        List<String> ret = (List<String>)this.get(name);
        if (ret == null) {
            ret = this.newList();
            this.put(name, ret);
        }
        ret.add(value);
    }

    @Override
    public void put(String name, String value) {
        List<String> ret = this.newList();
        ret.add(value);
        this.put(name, ret);
    }

    public Multimap(List<NameValuePair> pairs) {
        for (NameValuePair pair : pairs) {
            this.add(pair.getName(), pair.getValue());
        }
    }

    public Multimap(Multimap m) {
        this.putAll(m);
    }

    public static Multimap parse(String value, String delimiter, boolean unquote, StringDecoder decoder) {
        String[] parts;
        Multimap map = new Multimap();
        if (value == null) {
            return map;
        }
        for (String part : parts = value.split(delimiter)) {
            String[] pair = part.split("=", 2);
            String key = pair[0].trim();
            String v = null;
            if (pair.length > 1) {
                v = pair[1];
            }
            if (unquote && v != null && v.endsWith("\"") && v.startsWith("\"")) {
                v = v.substring(1, v.length() - 1);
            }
            if (decoder != null) {
                key = decoder.decode(key);
                v = decoder.decode(v);
            }
            map.add(key, v);
        }
        return map;
    }

    public static Multimap parseSemicolonDelimited(String header) {
        return Multimap.parse(header, ";", true, null);
    }

    public static Multimap parseCommaDelimited(String header) {
        return Multimap.parse(header, ",", true, null);
    }

    public static Multimap parseQuery(String query) {
        return Multimap.parse(query, "&", false, QUERY_DECODER);
    }

    public static Multimap parseUrlEncoded(String query) {
        return Multimap.parse(query, "&", false, URL_DECODER);
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        ArrayList<BasicNameValuePair> ret = new ArrayList<BasicNameValuePair>();
        for (String name : this.keySet()) {
            List values = (List)this.get(name);
            for (String value : values) {
                ret.add(new BasicNameValuePair(name, value));
            }
        }
        return ret.iterator();
    }

    public static interface StringDecoder {
        public String decode(String var1);
    }
}

