/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.spdy;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.BufferedDataSink;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.spdy.ByteString;
import com.koushikdutta.async.http.spdy.ErrorCode;
import com.koushikdutta.async.http.spdy.FrameReader;
import com.koushikdutta.async.http.spdy.FrameWriter;
import com.koushikdutta.async.http.spdy.Header;
import com.koushikdutta.async.http.spdy.HeadersMode;
import com.koushikdutta.async.http.spdy.Http20Draft13;
import com.koushikdutta.async.http.spdy.Ping;
import com.koushikdutta.async.http.spdy.Settings;
import com.koushikdutta.async.http.spdy.Spdy3;
import com.koushikdutta.async.http.spdy.Variant;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AsyncSpdyConnection
implements FrameReader.Handler {
    AsyncSocket socket;
    BufferedDataSink bufferedSocket;
    FrameReader reader;
    FrameWriter writer;
    Variant variant;
    Hashtable<Integer, SpdySocket> sockets = new Hashtable();
    Protocol protocol;
    boolean client = true;
    int totalWindowRead;
    final Settings okHttpSettings = new Settings();
    private int nextPingId;
    private static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    private int lastGoodStreamId;
    private int nextStreamId;
    long bytesLeftInWriteWindow;
    Settings peerSettings = new Settings();
    private boolean receivedInitialPeerSettings = false;
    private Map<Integer, Ping> pings;
    boolean shutdown;

    public SpdySocket newStream(List<Header> requestHeaders, boolean out, boolean in) {
        return this.newStream(0, requestHeaders, out, in);
    }

    private SpdySocket newStream(int associatedStreamId, List<Header> requestHeaders, boolean out, boolean in) {
        boolean inFinished;
        boolean outFinished = !out;
        boolean bl = inFinished = !in;
        if (this.shutdown) {
            return null;
        }
        int streamId = this.nextStreamId;
        this.nextStreamId += 2;
        SpdySocket socket = new SpdySocket(streamId, outFinished, inFinished, requestHeaders);
        if (socket.isOpen()) {
            this.sockets.put(streamId, socket);
        }
        try {
            if (associatedStreamId == 0) {
                this.writer.synStream(outFinished, inFinished, streamId, associatedStreamId, requestHeaders);
            } else {
                if (this.client) {
                    throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                }
                this.writer.pushPromise(associatedStreamId, streamId, requestHeaders);
            }
            return socket;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    void updateWindowRead(int length) {
        this.totalWindowRead += length;
        if (this.totalWindowRead >= this.okHttpSettings.getInitialWindowSize(65536) / 2) {
            try {
                this.writer.windowUpdate(0, this.totalWindowRead);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.totalWindowRead = 0;
        }
    }

    public AsyncSpdyConnection(AsyncSocket socket, Protocol protocol) {
        this.protocol = protocol;
        this.socket = socket;
        this.bufferedSocket = new BufferedDataSink(socket);
        if (protocol == Protocol.SPDY_3) {
            this.variant = new Spdy3();
        } else if (protocol == Protocol.HTTP_2) {
            this.variant = new Http20Draft13();
        }
        this.reader = this.variant.newReader(socket, this, true);
        this.writer = this.variant.newWriter(this.bufferedSocket, true);
        boolean client = true;
        int n = this.nextStreamId = client ? 1 : 2;
        if (client && protocol == Protocol.HTTP_2) {
            this.nextStreamId += 2;
        }
        int n2 = this.nextPingId = client ? 1 : 2;
        if (client) {
            this.okHttpSettings.set(7, 0, 0x1000000);
        }
    }

    public void sendConnectionPreface() throws IOException {
        this.writer.connectionPreface();
        this.writer.settings(this.okHttpSettings);
        int windowSize = this.okHttpSettings.getInitialWindowSize(65536);
        if (windowSize != 65536) {
            this.writer.windowUpdate(0, windowSize - 65536);
        }
    }

    private boolean pushedStream(int streamId) {
        return this.protocol == Protocol.HTTP_2 && streamId != 0 && (streamId & 1) == 0;
    }

    @Override
    public void data(boolean inFinished, int streamId, ByteBufferList source) {
        if (this.pushedStream(streamId)) {
            throw new AssertionError((Object)"push");
        }
        SpdySocket socket = this.sockets.get(streamId);
        if (socket == null) {
            try {
                this.writer.rstStream(streamId, ErrorCode.INVALID_STREAM);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            source.recycle();
            return;
        }
        int length = source.remaining();
        source.get(socket.pending);
        socket.updateWindowRead(length);
        Util.emitAllData(socket, socket.pending);
        if (inFinished) {
            this.sockets.remove(streamId);
            socket.close();
            Util.end(socket, null);
        }
    }

    @Override
    public void headers(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock, HeadersMode headersMode) {
        if (this.pushedStream(streamId)) {
            throw new AssertionError((Object)"push");
        }
        if (this.shutdown) {
            return;
        }
        SpdySocket socket = this.sockets.get(streamId);
        if (socket == null) {
            if (headersMode.failIfStreamAbsent()) {
                try {
                    this.writer.rstStream(streamId, ErrorCode.INVALID_STREAM);
                    return;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (streamId <= this.lastGoodStreamId) {
                return;
            }
            if (streamId % 2 == this.nextStreamId % 2) {
                return;
            }
            throw new AssertionError((Object)"unexpected receive stream");
        }
        if (headersMode.failIfStreamPresent()) {
            try {
                this.writer.rstStream(streamId, ErrorCode.INVALID_STREAM);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.sockets.remove(streamId);
            return;
        }
        socket.receiveHeaders(headerBlock, headersMode);
        if (inFinished) {
            this.sockets.remove(streamId);
            Util.end(socket, null);
        }
    }

    @Override
    public void rstStream(int streamId, ErrorCode errorCode) {
        if (this.pushedStream(streamId)) {
            throw new AssertionError((Object)"push");
        }
        SpdySocket rstStream = this.sockets.remove(streamId);
        if (rstStream != null) {
            Util.end(rstStream, (Exception)new IOException(errorCode.toString()));
        }
    }

    @Override
    public void settings(boolean clearPrevious, Settings settings) {
        long delta = 0L;
        int priorWriteWindowSize = this.peerSettings.getInitialWindowSize(65536);
        if (clearPrevious) {
            this.peerSettings.clear();
        }
        this.peerSettings.merge(settings);
        try {
            this.writer.ackSettings();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        int peerInitialWindowSize = this.peerSettings.getInitialWindowSize(65536);
        if (peerInitialWindowSize != -1 && peerInitialWindowSize != priorWriteWindowSize) {
            delta = peerInitialWindowSize - priorWriteWindowSize;
            if (!this.receivedInitialPeerSettings) {
                this.addBytesToWriteWindow(delta);
                this.receivedInitialPeerSettings = true;
            }
        }
        for (SpdySocket socket : this.sockets.values()) {
            socket.addBytesToWriteWindow(delta);
        }
    }

    void addBytesToWriteWindow(long delta) {
        this.bytesLeftInWriteWindow += delta;
        for (SpdySocket socket : this.sockets.values()) {
            Util.writable(socket);
        }
    }

    @Override
    public void ackSettings() {
        try {
            this.writer.ackSettings();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void writePing(boolean reply, int payload1, int payload2, Ping ping) throws IOException {
        if (ping != null) {
            ping.send();
        }
        this.writer.ping(reply, payload1, payload2);
    }

    private synchronized Ping removePing(int id) {
        return this.pings != null ? this.pings.remove(id) : null;
    }

    @Override
    public void ping(boolean ack, int payload1, int payload2) {
        if (ack) {
            Ping ping = this.removePing(payload1);
            if (ping != null) {
                ping.receive();
            }
        } else {
            try {
                this.writePing(true, payload1, payload2, null);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
        this.shutdown = true;
        Iterator<Map.Entry<Integer, SpdySocket>> i = this.sockets.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, SpdySocket> entry = i.next();
            int streamId = entry.getKey();
            if (streamId <= lastGoodStreamId || !entry.getValue().isLocallyInitiated()) continue;
            Util.end(entry.getValue(), (Exception)new IOException(ErrorCode.REFUSED_STREAM.toString()));
            i.remove();
        }
    }

    @Override
    public void windowUpdate(int streamId, long windowSizeIncrement) {
        if (streamId == 0) {
            this.addBytesToWriteWindow(windowSizeIncrement);
            return;
        }
        SpdySocket socket = this.sockets.get(streamId);
        if (socket != null) {
            socket.addBytesToWriteWindow(windowSizeIncrement);
        }
    }

    @Override
    public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
    }

    @Override
    public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) {
        throw new AssertionError((Object)"pushPromise");
    }

    @Override
    public void alternateService(int streamId, String origin, ByteString protocol, String host, int port, long maxAge) {
    }

    @Override
    public void error(Exception e) {
        this.socket.close();
        Iterator<Map.Entry<Integer, SpdySocket>> i = this.sockets.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, SpdySocket> entry = i.next();
            Util.end(entry.getValue(), e);
            i.remove();
        }
    }

    public class SpdySocket
    implements AsyncSocket {
        long bytesLeftInWriteWindow;
        WritableCallback writable;
        final int id;
        CompletedCallback closedCallback;
        CompletedCallback endCallback;
        DataCallback dataCallback;
        ByteBufferList pending;
        SimpleFuture<List<Header>> headers;
        boolean isOpen;
        int totalWindowRead;
        boolean paused;
        ByteBufferList writing;

        public AsyncSpdyConnection getConnection() {
            return AsyncSpdyConnection.this;
        }

        public SimpleFuture<List<Header>> headers() {
            return this.headers;
        }

        void updateWindowRead(int length) {
            this.totalWindowRead += length;
            if (this.totalWindowRead >= AsyncSpdyConnection.this.okHttpSettings.getInitialWindowSize(65536) / 2) {
                try {
                    AsyncSpdyConnection.this.writer.windowUpdate(this.id, this.totalWindowRead);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                this.totalWindowRead = 0;
            }
            AsyncSpdyConnection.this.updateWindowRead(length);
        }

        public SpdySocket(int id, boolean outFinished, boolean inFinished, List<Header> headerBlock) {
            this.bytesLeftInWriteWindow = AsyncSpdyConnection.this.peerSettings.getInitialWindowSize(65536);
            this.pending = new ByteBufferList();
            this.headers = new SimpleFuture();
            this.isOpen = true;
            this.writing = new ByteBufferList();
            this.id = id;
        }

        public boolean isLocallyInitiated() {
            boolean streamIsClient = (this.id & 1) == 1;
            return AsyncSpdyConnection.this.client == streamIsClient;
        }

        public void addBytesToWriteWindow(long delta) {
            long prev = this.bytesLeftInWriteWindow;
            this.bytesLeftInWriteWindow += delta;
            if (this.bytesLeftInWriteWindow > 0L && prev <= 0L) {
                Util.writable(this.writable);
            }
        }

        @Override
        public AsyncServer getServer() {
            return AsyncSpdyConnection.this.socket.getServer();
        }

        @Override
        public void setDataCallback(DataCallback callback) {
            this.dataCallback = callback;
        }

        @Override
        public DataCallback getDataCallback() {
            return this.dataCallback;
        }

        @Override
        public boolean isChunked() {
            return false;
        }

        @Override
        public void pause() {
            this.paused = true;
        }

        @Override
        public void resume() {
            this.paused = false;
        }

        @Override
        public void close() {
            this.isOpen = false;
        }

        @Override
        public boolean isPaused() {
            return this.paused;
        }

        @Override
        public void setEndCallback(CompletedCallback callback) {
            this.endCallback = callback;
        }

        @Override
        public CompletedCallback getEndCallback() {
            return this.endCallback;
        }

        @Override
        public String charset() {
            return null;
        }

        @Override
        public void write(ByteBufferList bb) {
            int canWrite = (int)Math.min(this.bytesLeftInWriteWindow, AsyncSpdyConnection.this.bytesLeftInWriteWindow);
            canWrite = Math.min(bb.remaining(), canWrite);
            if (canWrite == 0) {
                return;
            }
            if (canWrite < bb.remaining()) {
                if (this.writing.hasRemaining()) {
                    throw new AssertionError((Object)"wtf");
                }
                bb.get(this.writing, canWrite);
                bb = this.writing;
            }
            try {
                AsyncSpdyConnection.this.writer.data(false, this.id, bb);
                this.bytesLeftInWriteWindow -= (long)canWrite;
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void setWriteableCallback(WritableCallback handler) {
            this.writable = handler;
        }

        @Override
        public WritableCallback getWriteableCallback() {
            return this.writable;
        }

        @Override
        public boolean isOpen() {
            return this.isOpen;
        }

        @Override
        public void end() {
            try {
                AsyncSpdyConnection.this.writer.data(true, this.id, this.writing);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void setClosedCallback(CompletedCallback handler) {
            this.closedCallback = handler;
        }

        @Override
        public CompletedCallback getClosedCallback() {
            return this.closedCallback;
        }

        public void receiveHeaders(List<Header> headers, HeadersMode headerMode) {
            this.headers.setComplete(headers);
        }
    }
}

