/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import android.os.Build;
import com.koushikdutta.async.AsyncSSLException;
import com.koushikdutta.async.AsyncSSLSocket;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.BufferedDataSink;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.util.Allocator;
import com.koushikdutta.async.wrapper.AsyncSocketWrapper;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.StrictHostnameVerifier;

public class AsyncSSLSocketWrapper
implements AsyncSocketWrapper,
AsyncSSLSocket {
    static SSLContext defaultSSLContext;
    AsyncSocket mSocket;
    BufferedDataSink mSink;
    boolean mUnwrapping;
    SSLEngine engine;
    boolean finishedHandshake;
    private int mPort;
    private String mHost;
    private boolean mWrapping;
    HostnameVerifier hostnameVerifier;
    HandshakeCallback handshakeCallback;
    X509Certificate[] peerCertificates;
    WritableCallback mWriteableCallback;
    DataCallback mDataCallback;
    TrustManager[] trustManagers;
    boolean clientMode;
    boolean mEnded;
    Exception mEndException;
    final ByteBufferList pending = new ByteBufferList();
    final DataCallback dataCallback = new DataCallback(){
        final Allocator allocator = new Allocator().setMinAlloc(8192);
        final ByteBufferList buffered = new ByteBufferList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            if (AsyncSSLSocketWrapper.this.mUnwrapping) {
                return;
            }
            try {
                block12: {
                    int before;
                    int remaining;
                    AsyncSSLSocketWrapper.this.mUnwrapping = true;
                    bb.get(this.buffered);
                    if (this.buffered.hasRemaining()) {
                        ByteBuffer all = this.buffered.getAll();
                        this.buffered.add(all);
                    }
                    ByteBuffer b = ByteBufferList.EMPTY_BYTEBUFFER;
                    do {
                        if (b.remaining() == 0 && this.buffered.size() > 0) {
                            b = this.buffered.remove();
                        }
                        remaining = b.remaining();
                        before = AsyncSSLSocketWrapper.this.pending.remaining();
                        ByteBuffer readBuf = this.allocator.allocate();
                        SSLEngineResult res = AsyncSSLSocketWrapper.this.engine.unwrap(b, readBuf);
                        AsyncSSLSocketWrapper.this.addToPending(AsyncSSLSocketWrapper.this.pending, readBuf);
                        this.allocator.track(AsyncSSLSocketWrapper.this.pending.remaining() - before);
                        if (res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                            this.allocator.setMinAlloc(this.allocator.getMinAlloc() * 2);
                            remaining = -1;
                        } else if (res.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            this.buffered.addFirst(b);
                            if (this.buffered.size() <= 1) break block12;
                            remaining = -1;
                            b = this.buffered.getAll();
                            this.buffered.addFirst(b);
                            b = ByteBufferList.EMPTY_BYTEBUFFER;
                        }
                        AsyncSSLSocketWrapper.this.handleHandshakeStatus(res.getHandshakeStatus());
                    } while (b.remaining() != remaining || before != AsyncSSLSocketWrapper.this.pending.remaining());
                    this.buffered.addFirst(b);
                }
                AsyncSSLSocketWrapper.this.onDataAvailable();
            }
            catch (SSLException ex) {
                ex.printStackTrace();
                AsyncSSLSocketWrapper.this.report(ex);
            }
            finally {
                AsyncSSLSocketWrapper.this.mUnwrapping = false;
            }
        }
    };
    ByteBufferList writeList = new ByteBufferList();
    CompletedCallback mEndCallback;

    public static SSLContext getDefaultSSLContext() {
        return defaultSSLContext;
    }

    public static void handshake(AsyncSocket socket, String host, int port, SSLEngine sslEngine, TrustManager[] trustManagers, HostnameVerifier verifier, boolean clientMode, final HandshakeCallback callback) {
        AsyncSSLSocketWrapper wrapper = new AsyncSSLSocketWrapper(socket, host, port, sslEngine, trustManagers, verifier, clientMode);
        wrapper.handshakeCallback = callback;
        socket.setClosedCallback(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                callback.onHandshakeCompleted(new SSLException(ex), null);
            }
        });
        try {
            wrapper.engine.beginHandshake();
            wrapper.handleHandshakeStatus(wrapper.engine.getHandshakeStatus());
        }
        catch (SSLException e) {
            wrapper.report(e);
        }
    }

    private AsyncSSLSocketWrapper(AsyncSocket socket, String host, int port, SSLEngine sslEngine, TrustManager[] trustManagers, HostnameVerifier verifier, boolean clientMode) {
        this.mSocket = socket;
        this.hostnameVerifier = verifier;
        this.clientMode = clientMode;
        this.trustManagers = trustManagers;
        this.engine = sslEngine;
        this.mHost = host;
        this.mPort = port;
        this.engine.setUseClientMode(clientMode);
        this.mSink = new BufferedDataSink(socket);
        this.mSink.setWriteableCallback(new WritableCallback(){

            @Override
            public void onWriteable() {
                if (AsyncSSLSocketWrapper.this.mWriteableCallback != null) {
                    AsyncSSLSocketWrapper.this.mWriteableCallback.onWriteable();
                }
            }
        });
        this.mSocket.setEndCallback(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                if (AsyncSSLSocketWrapper.this.mEnded) {
                    return;
                }
                AsyncSSLSocketWrapper.this.mEnded = true;
                AsyncSSLSocketWrapper.this.mEndException = ex;
                if (!AsyncSSLSocketWrapper.this.pending.hasRemaining() && AsyncSSLSocketWrapper.this.mEndCallback != null) {
                    AsyncSSLSocketWrapper.this.mEndCallback.onCompleted(ex);
                }
            }
        });
        this.mSocket.setDataCallback(this.dataCallback);
    }

    public void onDataAvailable() {
        Util.emitAllData(this, this.pending);
        if (this.mEnded && !this.pending.hasRemaining() && this.mEndCallback != null) {
            this.mEndCallback.onCompleted(this.mEndException);
        }
    }

    @Override
    public SSLEngine getSSLEngine() {
        return this.engine;
    }

    void addToPending(ByteBufferList out, ByteBuffer mReadTmp) {
        mReadTmp.flip();
        if (mReadTmp.hasRemaining()) {
            out.add(mReadTmp);
        } else {
            ByteBufferList.reclaim(mReadTmp);
        }
    }

    @Override
    public void end() {
        this.mSocket.end();
    }

    public String getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    private void handleHandshakeStatus(SSLEngineResult.HandshakeStatus status) {
        if (status == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable task = this.engine.getDelegatedTask();
            task.run();
        }
        if (status == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            this.write(this.writeList);
        }
        if (status == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.dataCallback.onDataAvailable(this, new ByteBufferList());
        }
        try {
            if (!(this.finishedHandshake || this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED)) {
                if (this.clientMode) {
                    TrustManager[] trustManagers = this.trustManagers;
                    if (trustManagers == null) {
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init((KeyStore)null);
                        trustManagers = tmf.getTrustManagers();
                    }
                    boolean trusted = false;
                    Exception peerUnverifiedCause = null;
                    for (TrustManager tm : trustManagers) {
                        try {
                            X509TrustManager xtm = (X509TrustManager)tm;
                            this.peerCertificates = (X509Certificate[])this.engine.getSession().getPeerCertificates();
                            xtm.checkServerTrusted(this.peerCertificates, "SSL");
                            if (this.mHost != null) {
                                if (this.hostnameVerifier == null) {
                                    StrictHostnameVerifier verifier = new StrictHostnameVerifier();
                                    verifier.verify(this.mHost, StrictHostnameVerifier.getCNs((X509Certificate)this.peerCertificates[0]), StrictHostnameVerifier.getDNSSubjectAlts((X509Certificate)this.peerCertificates[0]));
                                } else {
                                    this.hostnameVerifier.verify(this.mHost, this.engine.getSession());
                                }
                            }
                            trusted = true;
                            break;
                        }
                        catch (GeneralSecurityException ex) {
                            peerUnverifiedCause = ex;
                        }
                        catch (SSLException ex) {
                            peerUnverifiedCause = ex;
                        }
                    }
                    this.finishedHandshake = true;
                    if (!trusted) {
                        AsyncSSLException e = new AsyncSSLException(peerUnverifiedCause);
                        this.report(e);
                        if (!e.getIgnore()) {
                            throw e;
                        }
                    }
                } else {
                    this.finishedHandshake = true;
                }
                this.handshakeCallback.onHandshakeCompleted(null, this);
                this.handshakeCallback = null;
                if (this.mWriteableCallback != null) {
                    this.mWriteableCallback.onWriteable();
                }
                this.onDataAvailable();
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (GeneralSecurityException ex) {
            this.report(ex);
        }
        catch (AsyncSSLException ex) {
            this.report(ex);
        }
    }

    int calculateAlloc(int remaining) {
        int alloc = remaining * 3 / 2;
        if (alloc == 0) {
            alloc = 8192;
        }
        return alloc;
    }

    @Override
    public void write(ByteBufferList bb) {
        if (this.mWrapping) {
            return;
        }
        if (this.mSink.remaining() > 0) {
            return;
        }
        this.mWrapping = true;
        SSLEngineResult res = null;
        ByteBuffer writeBuf = ByteBufferList.obtain(this.calculateAlloc(bb.remaining()));
        while (!this.finishedHandshake || bb.remaining() != 0) {
            int remaining = bb.remaining();
            try {
                ByteBuffer[] arr = bb.getAllArray();
                res = this.engine.wrap(arr, writeBuf);
                bb.addAll(arr);
                writeBuf.flip();
                this.writeList.add(writeBuf);
                assert (!this.writeList.hasRemaining());
                if (this.writeList.remaining() > 0) {
                    this.mSink.write(this.writeList);
                }
                int previousCapacity = writeBuf.capacity();
                writeBuf = null;
                if (res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    writeBuf = ByteBufferList.obtain(previousCapacity * 2);
                    remaining = -1;
                } else {
                    writeBuf = ByteBufferList.obtain(this.calculateAlloc(bb.remaining()));
                    this.handleHandshakeStatus(res.getHandshakeStatus());
                }
            }
            catch (SSLException e) {
                this.report(e);
            }
            if ((remaining != bb.remaining() || res != null && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) && this.mSink.remaining() == 0) continue;
        }
        this.mWrapping = false;
        ByteBufferList.reclaim(writeBuf);
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mWriteableCallback = handler;
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mWriteableCallback;
    }

    private void report(Exception e) {
        HandshakeCallback hs = this.handshakeCallback;
        if (hs != null) {
            this.handshakeCallback = null;
            this.mSocket.setDataCallback(new DataCallback.NullDataCallback());
            this.mSocket.end();
            this.mSocket.close();
            hs.onHandshakeCompleted(e, null);
            return;
        }
        CompletedCallback cb = this.getEndCallback();
        if (cb != null) {
            cb.onCompleted(e);
        }
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        this.mDataCallback = callback;
    }

    @Override
    public DataCallback getDataCallback() {
        return this.mDataCallback;
    }

    @Override
    public boolean isChunked() {
        return this.mSocket.isChunked();
    }

    @Override
    public boolean isOpen() {
        return this.mSocket.isOpen();
    }

    @Override
    public void close() {
        this.mSocket.close();
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mSocket.setClosedCallback(handler);
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mSocket.getClosedCallback();
    }

    @Override
    public void setEndCallback(CompletedCallback callback) {
        this.mEndCallback = callback;
    }

    @Override
    public CompletedCallback getEndCallback() {
        return this.mEndCallback;
    }

    @Override
    public void pause() {
        this.mSocket.pause();
    }

    @Override
    public void resume() {
        this.mSocket.resume();
        this.onDataAvailable();
    }

    @Override
    public boolean isPaused() {
        return this.mSocket.isPaused();
    }

    @Override
    public AsyncServer getServer() {
        return this.mSocket.getServer();
    }

    @Override
    public AsyncSocket getSocket() {
        return this.mSocket;
    }

    @Override
    public DataEmitter getDataEmitter() {
        return this.mSocket;
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        return this.peerCertificates;
    }

    @Override
    public String charset() {
        return null;
    }

    static {
        try {
            if (Build.VERSION.SDK_INT <= 15) {
                throw new Exception();
            }
            defaultSSLContext = SSLContext.getInstance("Default");
        }
        catch (Exception ex) {
            try {
                defaultSSLContext = SSLContext.getInstance("TLS");
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        for (X509Certificate cert : certs) {
                            if (cert == null || cert.getCriticalExtensionOIDs() == null) continue;
                            cert.getCriticalExtensionOIDs().remove("2.5.29.15");
                        }
                    }
                }};
                defaultSSLContext.init(null, trustAllCerts, null);
            }
            catch (Exception ex2) {
                ex.printStackTrace();
                ex2.printStackTrace();
            }
        }
    }

    public static interface HandshakeCallback {
        public void onHandshakeCompleted(Exception var1, AsyncSSLSocket var2);
    }
}

