/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;

public class BufferedDataEmitter
implements DataEmitter {
    DataEmitter mEmitter;
    boolean mEnded = false;
    Exception mEndException;
    ByteBufferList mBuffers = new ByteBufferList();
    DataCallback mDataCallback;
    CompletedCallback mEndCallback;

    public BufferedDataEmitter(DataEmitter emitter) {
        this.mEmitter = emitter;
        this.mEmitter.setDataCallback(new DataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                bb.get(BufferedDataEmitter.this.mBuffers);
                BufferedDataEmitter.this.onDataAvailable();
            }
        });
        this.mEmitter.setEndCallback(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                BufferedDataEmitter.this.mEnded = true;
                BufferedDataEmitter.this.mEndException = ex;
                if (BufferedDataEmitter.this.mBuffers.remaining() == 0 && BufferedDataEmitter.this.mEndCallback != null) {
                    BufferedDataEmitter.this.mEndCallback.onCompleted(ex);
                }
            }
        });
    }

    @Override
    public void close() {
        this.mEmitter.close();
    }

    public void onDataAvailable() {
        if (this.mDataCallback != null && !this.isPaused() && this.mBuffers.remaining() > 0) {
            this.mDataCallback.onDataAvailable(this, this.mBuffers);
        }
        if (this.mEnded && !this.mBuffers.hasRemaining() && this.mEndCallback != null) {
            this.mEndCallback.onCompleted(this.mEndException);
        }
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        if (this.mDataCallback != null) {
            throw new RuntimeException("Buffered Data Emitter callback may only be set once");
        }
        this.mDataCallback = callback;
    }

    @Override
    public DataCallback getDataCallback() {
        return this.mDataCallback;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public void pause() {
        this.mEmitter.pause();
    }

    @Override
    public void resume() {
        this.mEmitter.resume();
        this.onDataAvailable();
    }

    @Override
    public boolean isPaused() {
        return this.mEmitter.isPaused();
    }

    @Override
    public void setEndCallback(CompletedCallback callback) {
        this.mEndCallback = callback;
    }

    @Override
    public CompletedCallback getEndCallback() {
        return this.mEndCallback;
    }

    @Override
    public AsyncServer getServer() {
        return this.mEmitter.getServer();
    }

    @Override
    public String charset() {
        return this.mEmitter.charset();
    }
}

