/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.koushikdutta.async.AsyncDatagramSocket;
import com.koushikdutta.async.AsyncNetworkSocket;
import com.koushikdutta.async.AsyncServerSocket;
import com.koushikdutta.async.ChannelWrapper;
import com.koushikdutta.async.HostnameResolutionException;
import com.koushikdutta.async.SelectorWrapper;
import com.koushikdutta.async.ServerSocketChannelWrapper;
import com.koushikdutta.async.ThreadQueue;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.callback.ListenCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.future.TransformFuture;
import com.koushikdutta.async.util.StreamUtility;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;

public class AsyncServer {
    public static final String LOGTAG = "NIO";
    static AsyncServer mInstance;
    private SelectorWrapper mSelector;
    String mName;
    PriorityQueue<Scheduled> mQueue = new PriorityQueue<Scheduled>(1, Scheduler.INSTANCE);
    private static ExecutorService synchronousWorkers;
    static final WeakHashMap<Thread, AsyncServer> mServers;
    Thread mAffinity;
    private static final long QUEUE_EMPTY = Long.MAX_VALUE;

    public static void post(Handler handler, Runnable runnable) {
        ThreadQueue threadQueue;
        RunnableWrapper wrapper = new RunnableWrapper();
        wrapper.threadQueue = threadQueue = ThreadQueue.getOrCreateThreadQueue(handler.getLooper().getThread());
        wrapper.handler = handler;
        wrapper.runnable = runnable;
        threadQueue.add(wrapper);
        handler.post((Runnable)wrapper);
        threadQueue.queueSemaphore.release();
    }

    public static AsyncServer getDefault() {
        return mInstance;
    }

    public boolean isRunning() {
        return this.mSelector != null;
    }

    public AsyncServer() {
        this(null);
    }

    public AsyncServer(String name) {
        if (name == null) {
            name = "AsyncServer";
        }
        this.mName = name;
    }

    private void handleSocket(AsyncNetworkSocket handler) throws ClosedChannelException {
        ChannelWrapper sc = handler.getChannel();
        SelectionKey ckey = sc.register(this.mSelector.getSelector());
        ckey.attach(handler);
        handler.setup(this, ckey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCallbacks(Object scheduled) {
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            this.mQueue.remove(scheduled);
        }
    }

    private static void wakeup(final SelectorWrapper selector) {
        synchronousWorkers.execute(new Runnable(){

            @Override
            public void run() {
                selector.wakeupOnce();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object postDelayed(Runnable runnable, long delay) {
        Scheduled s;
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            long time = delay != 0L ? System.currentTimeMillis() + delay : (long)this.mQueue.size();
            s = new Scheduled(runnable, time);
            this.mQueue.add(s);
            if (this.mSelector == null) {
                this.run(true);
            }
            if (!this.isAffinityThread()) {
                AsyncServer.wakeup(this.mSelector);
            }
        }
        return s;
    }

    public Object post(Runnable runnable) {
        return this.postDelayed(runnable, 0L);
    }

    public Object post(final CompletedCallback callback, final Exception e) {
        return this.post(new Runnable(){

            @Override
            public void run() {
                callback.onCompleted(e);
            }
        });
    }

    public void run(final Runnable runnable) {
        if (Thread.currentThread() == this.mAffinity) {
            this.post(runnable);
            AsyncServer.lockAndRunQueue(this, this.mQueue);
            return;
        }
        final Semaphore semaphore = new Semaphore(0);
        this.post(new Runnable(){

            @Override
            public void run() {
                runnable.run();
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"run", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Semaphore semaphore;
        boolean isAffinityThread;
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            isAffinityThread = this.isAffinityThread();
            final SelectorWrapper currentSelector = this.mSelector;
            if (currentSelector == null) {
                return;
            }
            WeakHashMap<Thread, AsyncServer> weakHashMap = mServers;
            synchronized (weakHashMap) {
                mServers.remove(this.mAffinity);
            }
            semaphore = new Semaphore(0);
            this.mQueue.add(new Scheduled(new Runnable(){

                @Override
                public void run() {
                    AsyncServer.shutdownEverything(currentSelector);
                    semaphore.release();
                }
            }, 0L));
            currentSelector.wakeupOnce();
            AsyncServer.shutdownKeys(currentSelector);
            this.mQueue = new PriorityQueue<Scheduled>(1, Scheduler.INSTANCE);
            this.mSelector = null;
            this.mAffinity = null;
        }
        try {
            if (!isAffinityThread) {
                semaphore.acquire();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void onDataReceived(int transmitted) {
    }

    protected void onDataSent(int transmitted) {
    }

    public AsyncServerSocket listen(final InetAddress host, final int port, final ListenCallback handler) {
        final ObjectHolder holder = new ObjectHolder();
        this.run(new Runnable(){

            @Override
            public void run() {
                ServerSocketChannel closeableServer = null;
                ServerSocketChannelWrapper closeableWrapper = null;
                try {
                    closeableServer = ServerSocketChannel.open();
                    closeableWrapper = new ServerSocketChannelWrapper(closeableServer);
                    final ServerSocketChannel server = closeableServer;
                    final ServerSocketChannelWrapper wrapper = closeableWrapper;
                    InetSocketAddress isa = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
                    server.socket().bind(isa);
                    final SelectionKey key = wrapper.register(AsyncServer.this.mSelector.getSelector());
                    key.attach(handler);
                    holder.held = new AsyncServerSocket(){

                        @Override
                        public int getLocalPort() {
                            return server.socket().getLocalPort();
                        }

                        @Override
                        public void stop() {
                            StreamUtility.closeQuietly(wrapper);
                            try {
                                key.cancel();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    handler.onListening((AsyncServerSocket)holder.held);
                }
                catch (IOException e) {
                    StreamUtility.closeQuietly(closeableWrapper, closeableServer);
                    handler.onCompleted(e);
                }
            }
        });
        return (AsyncServerSocket)holder.held;
    }

    private ConnectFuture connectResolvedInetSocketAddress(final InetSocketAddress address, final ConnectCallback callback) {
        final ConnectFuture cancel = new ConnectFuture();
        assert (!address.isUnresolved());
        this.post(new Runnable(){

            @Override
            public void run() {
                if (cancel.isCancelled()) {
                    return;
                }
                cancel.callback = callback;
                SelectionKey ckey = null;
                SocketChannel socket = null;
                try {
                    socket = cancel.socket = SocketChannel.open();
                    socket.configureBlocking(false);
                    ckey = socket.register(AsyncServer.this.mSelector.getSelector(), 8);
                    ckey.attach(cancel);
                    socket.connect(address);
                }
                catch (IOException e) {
                    if (ckey != null) {
                        ckey.cancel();
                    }
                    StreamUtility.closeQuietly(socket);
                    cancel.setComplete(e);
                }
            }
        });
        return cancel;
    }

    public Cancellable connectSocket(final InetSocketAddress remote, final ConnectCallback callback) {
        if (!remote.isUnresolved()) {
            return this.connectResolvedInetSocketAddress(remote, callback);
        }
        final SimpleFuture ret = new SimpleFuture();
        Future<InetAddress> lookup = this.getByName(remote.getHostName());
        ret.setParent(lookup);
        lookup.setCallback(new FutureCallback<InetAddress>(){

            @Override
            public void onCompleted(Exception e, InetAddress result) {
                if (e != null) {
                    callback.onConnectCompleted(e, null);
                    ret.setComplete(e);
                    return;
                }
                ret.setComplete(AsyncServer.this.connectResolvedInetSocketAddress(new InetSocketAddress(remote.getHostName(), remote.getPort()), callback));
            }
        });
        return ret;
    }

    public Cancellable connectSocket(String host, int port, ConnectCallback callback) {
        return this.connectSocket(InetSocketAddress.createUnresolved(host, port), callback);
    }

    public Future<InetAddress[]> getAllByName(final String host) {
        final SimpleFuture<InetAddress[]> ret = new SimpleFuture<InetAddress[]>();
        synchronousWorkers.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final InetAddress[] result = InetAddress.getAllByName(host);
                    if (result == null || result.length == 0) {
                        throw new HostnameResolutionException("no addresses for host");
                    }
                    AsyncServer.this.post(new Runnable(){

                        @Override
                        public void run() {
                            ret.setComplete(null, result);
                        }
                    });
                }
                catch (Exception e) {
                    AsyncServer.this.post(new Runnable(){

                        @Override
                        public void run() {
                            ret.setComplete(e, null);
                        }
                    });
                }
            }
        });
        return ret;
    }

    public Future<InetAddress> getByName(String host) {
        return this.getAllByName(host).then(new TransformFuture<InetAddress, InetAddress[]>(){

            @Override
            protected void transform(InetAddress[] result) throws Exception {
                this.setComplete(result[0]);
            }
        });
    }

    public AsyncDatagramSocket connectDatagram(final String host, final int port) throws IOException {
        final DatagramChannel socket = DatagramChannel.open();
        final AsyncDatagramSocket handler = new AsyncDatagramSocket();
        handler.attach(socket);
        this.run(new Runnable(){

            @Override
            public void run() {
                try {
                    InetSocketAddress remote = new InetSocketAddress(host, port);
                    AsyncServer.this.handleSocket(handler);
                    socket.connect(remote);
                }
                catch (IOException e) {
                    Log.e((String)AsyncServer.LOGTAG, (String)"Datagram error", (Throwable)e);
                    StreamUtility.closeQuietly(socket);
                }
            }
        });
        return handler;
    }

    public AsyncDatagramSocket openDatagram() throws IOException {
        return this.openDatagram(null, false);
    }

    public AsyncDatagramSocket openDatagram(final SocketAddress address, final boolean reuseAddress) throws IOException {
        final DatagramChannel socket = DatagramChannel.open();
        final AsyncDatagramSocket handler = new AsyncDatagramSocket();
        handler.attach(socket);
        this.run(new Runnable(){

            @Override
            public void run() {
                try {
                    if (reuseAddress) {
                        socket.socket().setReuseAddress(reuseAddress);
                    }
                    socket.socket().bind(address);
                    AsyncServer.this.handleSocket(handler);
                }
                catch (IOException e) {
                    Log.e((String)AsyncServer.LOGTAG, (String)"Datagram error", (Throwable)e);
                    StreamUtility.closeQuietly(socket);
                }
            }
        });
        return handler;
    }

    public AsyncDatagramSocket connectDatagram(final SocketAddress remote) throws IOException {
        final DatagramChannel socket = DatagramChannel.open();
        final AsyncDatagramSocket handler = new AsyncDatagramSocket();
        handler.attach(socket);
        this.run(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncServer.this.handleSocket(handler);
                    socket.connect(remote);
                }
                catch (IOException e) {
                    StreamUtility.closeQuietly(socket);
                }
            }
        });
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMe() {
        WeakHashMap<Thread, AsyncServer> weakHashMap = mServers;
        synchronized (weakHashMap) {
            AsyncServer current = mServers.get(this.mAffinity);
            if (current != null) {
                return false;
            }
            mServers.put(this.mAffinity, this);
        }
        return true;
    }

    public static AsyncServer getCurrentThreadServer() {
        return mServers.get(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(boolean newThread) {
        PriorityQueue<Scheduled> queue;
        SelectorWrapper selector;
        boolean reentrant = false;
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            if (this.mSelector != null) {
                Log.i((String)LOGTAG, (String)"Reentrant call");
                assert (Thread.currentThread() == this.mAffinity);
                reentrant = true;
                selector = this.mSelector;
                queue = this.mQueue;
            } else {
                try {
                    selector = this.mSelector = new SelectorWrapper(SelectorProvider.provider().openSelector());
                    queue = this.mQueue;
                }
                catch (IOException e) {
                    return;
                }
                this.mAffinity = newThread ? new Thread(this.mName){

                    @Override
                    public void run() {
                        AsyncServer.run(AsyncServer.this, selector, queue);
                    }
                } : Thread.currentThread();
                if (!this.addMe()) {
                    try {
                        this.mSelector.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.mSelector = null;
                    this.mAffinity = null;
                    return;
                }
                if (newThread) {
                    this.mAffinity.start();
                    return;
                }
            }
        }
        if (reentrant) {
            try {
                AsyncServer.runLoop(this, selector, queue);
            }
            catch (ClosedSelectorException e) {
                // empty catch block
            }
            return;
        }
        AsyncServer.run(this, selector, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void run(AsyncServer server, SelectorWrapper selector, PriorityQueue<Scheduled> queue) {
        Object object;
        while (true) {
            try {
                AsyncServer.runLoop(server, selector, queue);
            }
            catch (ClosedSelectorException closedSelectorException) {
                // empty catch block
            }
            object = server;
            synchronized (object) {
                if (!selector.isOpen() || selector.keys().size() <= 0 && queue.size() <= 0) break;
            }
        }
        {
            AsyncServer.shutdownEverything(selector);
            if (server.mSelector == selector) {
                server.mQueue = new PriorityQueue<Scheduled>(1, Scheduler.INSTANCE);
                server.mSelector = null;
                server.mAffinity = null;
            }
        }
        object = mServers;
        synchronized (object) {
            mServers.remove(Thread.currentThread());
            return;
        }
    }

    private static void shutdownKeys(SelectorWrapper selector) {
        try {
            for (SelectionKey key : selector.keys()) {
                StreamUtility.closeQuietly(key.channel());
                try {
                    key.cancel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void shutdownEverything(SelectorWrapper selector) {
        AsyncServer.shutdownKeys(selector);
        try {
            selector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long lockAndRunQueue(AsyncServer server, PriorityQueue<Scheduled> queue) {
        long wait = Long.MAX_VALUE;
        while (true) {
            Scheduled run = null;
            AsyncServer asyncServer = server;
            synchronized (asyncServer) {
                long now = System.currentTimeMillis();
                if (queue.size() > 0) {
                    Scheduled s = (Scheduled)queue.remove();
                    if (s.time <= now) {
                        run = s;
                    } else {
                        wait = s.time - now;
                        queue.add(s);
                    }
                }
            }
            if (run == null) break;
            run.runnable.run();
        }
        return wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runLoop(AsyncServer server, SelectorWrapper selector, PriorityQueue<Scheduled> queue) throws AsyncSelectorException {
        boolean needsSelect = true;
        long wait = AsyncServer.lockAndRunQueue(server, queue);
        try {
            AsyncServer asyncServer = server;
            synchronized (asyncServer) {
                int readyNow = selector.selectNow();
                if (readyNow == 0) {
                    if (selector.keys().size() == 0 && wait == Long.MAX_VALUE) {
                        return;
                    }
                } else {
                    needsSelect = false;
                }
            }
            if (needsSelect) {
                if (wait == Long.MAX_VALUE) {
                    selector.select();
                } else {
                    selector.select(wait);
                }
            }
        }
        catch (IOException e) {
            throw new AsyncSelectorException(e);
        }
        Set<SelectionKey> readyKeys = selector.selectedKeys();
        for (SelectionKey key : readyKeys) {
            try {
                AsyncNetworkSocket handler;
                if (key.isAcceptable()) {
                    ServerSocketChannel nextReady = (ServerSocketChannel)key.channel();
                    SocketChannel sc = null;
                    SelectionKey ckey = null;
                    try {
                        sc = nextReady.accept();
                        if (sc == null) continue;
                        sc.configureBlocking(false);
                        ckey = sc.register(selector.getSelector(), 1);
                        ListenCallback serverHandler = (ListenCallback)key.attachment();
                        AsyncNetworkSocket handler2 = new AsyncNetworkSocket();
                        handler2.attach(sc, (InetSocketAddress)sc.socket().getRemoteSocketAddress());
                        handler2.setup(server, ckey);
                        ckey.attach(handler2);
                        serverHandler.onAccepted(handler2);
                    }
                    catch (IOException e) {
                        StreamUtility.closeQuietly(sc);
                        if (ckey == null) continue;
                        ckey.cancel();
                    }
                    continue;
                }
                if (key.isReadable()) {
                    handler = (AsyncNetworkSocket)key.attachment();
                    int transmitted = handler.onReadable();
                    server.onDataReceived(transmitted);
                    continue;
                }
                if (key.isWritable()) {
                    handler = (AsyncNetworkSocket)key.attachment();
                    handler.onDataWritable();
                    continue;
                }
                if (key.isConnectable()) {
                    AsyncNetworkSocket newHandler;
                    ConnectFuture cancel = (ConnectFuture)key.attachment();
                    SocketChannel sc = (SocketChannel)key.channel();
                    key.interestOps(1);
                    try {
                        sc.finishConnect();
                        newHandler = new AsyncNetworkSocket();
                        newHandler.setup(server, key);
                        newHandler.attach(sc, (InetSocketAddress)sc.socket().getRemoteSocketAddress());
                        key.attach(newHandler);
                    }
                    catch (IOException ex) {
                        key.cancel();
                        StreamUtility.closeQuietly(sc);
                        if (!cancel.setComplete(ex)) continue;
                        cancel.callback.onConnectCompleted(ex, null);
                        continue;
                    }
                    try {
                        if (!cancel.setComplete(newHandler)) continue;
                        cancel.callback.onConnectCompleted(null, newHandler);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                Log.i((String)LOGTAG, (String)"wtf");
                throw new RuntimeException("Unknown key state.");
            }
            catch (CancelledKeyException ex) {
            }
        }
        readyKeys.clear();
    }

    public void dump() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (AsyncServer.this.mSelector == null) {
                    Log.i((String)AsyncServer.LOGTAG, (String)"Server dump not possible. No selector?");
                    return;
                }
                Log.i((String)AsyncServer.LOGTAG, (String)("Key Count: " + AsyncServer.this.mSelector.keys().size()));
                for (SelectionKey key : AsyncServer.this.mSelector.keys()) {
                    Log.i((String)AsyncServer.LOGTAG, (String)("Key: " + key));
                }
            }
        });
    }

    public Thread getAffinity() {
        return this.mAffinity;
    }

    public boolean isAffinityThread() {
        return this.mAffinity == Thread.currentThread();
    }

    public boolean isAffinityThreadOrStopped() {
        Thread affinity = this.mAffinity;
        return affinity == null || affinity == Thread.currentThread();
    }

    static {
        try {
            if (Build.VERSION.SDK_INT <= 8) {
                System.setProperty("java.net.preferIPv4Stack", "true");
                System.setProperty("java.net.preferIPv6Addresses", "false");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        mInstance = new AsyncServer();
        synchronousWorkers = Executors.newFixedThreadPool(4);
        mServers = new WeakHashMap();
    }

    private static class AsyncSelectorException
    extends RuntimeException {
        public AsyncSelectorException(Exception e) {
            super(e);
        }
    }

    private class ConnectFuture
    extends SimpleFuture<AsyncNetworkSocket> {
        SocketChannel socket;
        ConnectCallback callback;

        private ConnectFuture() {
        }

        @Override
        protected void cancelCleanup() {
            super.cancelCleanup();
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ObjectHolder<T> {
        T held;

        private ObjectHolder() {
        }
    }

    static class Scheduler
    implements Comparator<Scheduled> {
        public static Scheduler INSTANCE = new Scheduler();

        private Scheduler() {
        }

        @Override
        public int compare(Scheduled s1, Scheduled s2) {
            if (s1.time == s2.time) {
                return 0;
            }
            if (s1.time > s2.time) {
                return 1;
            }
            return -1;
        }
    }

    private static class Scheduled {
        public Runnable runnable;
        public long time;

        public Scheduled(Runnable runnable, long time) {
            this.runnable = runnable;
            this.time = time;
        }
    }

    private static class RunnableWrapper
    implements Runnable {
        boolean hasRun;
        Runnable runnable;
        ThreadQueue threadQueue;
        Handler handler;

        private RunnableWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RunnableWrapper runnableWrapper = this;
            synchronized (runnableWrapper) {
                if (this.hasRun) {
                    return;
                }
                this.hasRun = true;
            }
            try {
                this.runnable.run();
            }
            finally {
                this.threadQueue.remove(this);
                this.handler.removeCallbacks((Runnable)this);
                this.threadQueue = null;
                this.handler = null;
                this.runnable = null;
            }
        }
    }
}

