/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.net.Uri;
import com.koushikdutta.async.http.libcore.RawHeaders;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Multimap
extends Hashtable<String, List<String>>
implements Iterable<NameValuePair> {
    public Multimap() {
    }

    public String getString(String name) {
        List ret = (List)this.get(name);
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return (String)ret.get(0);
    }

    public void add(String name, String value) {
        ArrayList<String> ret = (ArrayList<String>)this.get(name);
        if (ret == null) {
            ret = new ArrayList<String>();
            this.put(name, ret);
        }
        ret.add(value);
    }

    @Override
    public void put(String name, String value) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(value);
        this.put(name, ret);
    }

    public Multimap(RawHeaders headers) {
        headers.toMultimap().putAll(this);
    }

    public Multimap(List<NameValuePair> pairs) {
        for (NameValuePair pair : pairs) {
            this.add(pair.getName(), pair.getValue());
        }
    }

    public static Multimap parseHeader(String header) {
        String[] parts;
        Multimap map = new Multimap();
        for (String part : parts = header.split(";")) {
            String[] pair = part.split("=", 2);
            String key = pair[0].trim();
            String v = null;
            if (pair.length > 1) {
                v = pair[1];
            }
            if (v != null && v.endsWith("\"") && v.startsWith("\"")) {
                v = v.substring(1, v.length() - 1);
            }
            map.add(key, v);
        }
        return map;
    }

    public static Multimap parseHeader(RawHeaders headers, String header) {
        return Multimap.parseHeader(headers.get(header));
    }

    public static Multimap parseQuery(String query) {
        String[] pairs;
        Multimap map = new Multimap();
        for (String p : pairs = query.split("&")) {
            String[] pair = p.split("=", 2);
            if (pair.length == 0) continue;
            String name = Uri.decode((String)pair[0]);
            String value = null;
            if (pair.length == 2) {
                value = Uri.decode((String)pair[1]);
            }
            map.add(name, value);
        }
        return map;
    }

    public static Multimap parseUrlEncoded(String query) {
        String[] pairs;
        Multimap map = new Multimap();
        for (String p : pairs = query.split("&")) {
            String[] pair = p.split("=", 2);
            if (pair.length == 0) continue;
            String name = URLDecoder.decode(pair[0]);
            String value = null;
            if (pair.length == 2) {
                value = URLDecoder.decode(pair[1]);
            }
            map.add(name, value);
        }
        return map;
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        ArrayList<BasicNameValuePair> ret = new ArrayList<BasicNameValuePair>();
        for (String name : this.keySet()) {
            List values = (List)this.get(name);
            for (String value : values) {
                ret.add(new BasicNameValuePair(name, value));
            }
        }
        return ret.iterator();
    }
}

