/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.koushikdutta.async.AsyncSSLSocket;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataEmitterBase;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.SimpleCancellable;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.SimpleMiddleware;
import com.koushikdutta.async.http.libcore.Charsets;
import com.koushikdutta.async.http.libcore.DiskLruCache;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.http.libcore.ResponseHeaders;
import com.koushikdutta.async.http.libcore.ResponseSource;
import com.koushikdutta.async.http.libcore.StrictLineReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.SecureCacheResponse;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;

public class ResponseCacheMiddleware
extends SimpleMiddleware {
    private DiskLruCache cache;
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    public static final int ENTRY_COUNT = 2;
    private AsyncServer server;
    public static final String SERVED_FROM = "X-Served-From";
    public static final String CONDITIONAL_CACHE = "conditional-cache";
    public static final String CACHE = "cache";
    long size;
    File cacheDir;
    boolean caching = true;
    private static final String LOGTAG = "AsyncHttpCache";
    private int conditionalCacheHitCount;
    private int cacheHitCount;
    private int networkCount;
    private int cacheStoreCount;
    int writeSuccessCount;
    int writeAbortCount;

    private ResponseCacheMiddleware() {
    }

    public static ResponseCacheMiddleware addCache(AsyncHttpClient client, File cacheDir, long size) throws IOException {
        for (AsyncHttpClientMiddleware middleware : client.getMiddleware()) {
            if (!(middleware instanceof ResponseCacheMiddleware)) continue;
            throw new IOException("Response cache already added to http client");
        }
        ResponseCacheMiddleware ret = new ResponseCacheMiddleware();
        ret.size = size;
        ret.server = client.getServer();
        ret.cacheDir = cacheDir;
        ret.open();
        client.insertMiddleware(ret);
        return ret;
    }

    private void open() throws IOException {
        this.cache = DiskLruCache.open(this.cacheDir, 201105, 2, this.size);
    }

    public DiskLruCache getDiskLruCache() {
        return this.cache;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public boolean getCaching() {
        return this.caching;
    }

    public static String uriToKey(URI uri) {
        return ResponseCacheMiddleware.toKeyString(uri.toString());
    }

    public static String toKeyString(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] md5bytes = messageDigest.digest(string.toString().getBytes());
            return new BigInteger(1, md5bytes).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Cancellable getSocket(final AsyncHttpClientMiddleware.GetSocketData data) {
        InputStream cachedResponseBody;
        Map<String, List<String>> responseHeadersMap;
        Entry entry;
        if (this.cache == null || !this.caching || data.request.getHeaders().isNoCache()) {
            ++this.networkCount;
            return null;
        }
        String key = ResponseCacheMiddleware.uriToKey(data.request.getUri());
        DiskLruCache.Snapshot snapshot = null;
        try {
            snapshot = this.cache.get(key);
            if (snapshot == null) {
                ++this.networkCount;
                return null;
            }
            entry = new Entry(snapshot.getInputStream(0));
        }
        catch (IOException e) {
            ++this.networkCount;
            return null;
        }
        if (!entry.matches(data.request.getUri(), data.request.getMethod(), data.request.getHeaders().getHeaders().toMultimap())) {
            ++this.networkCount;
            snapshot.close();
            return null;
        }
        CacheResponse candidate = entry.isHttps() ? new EntrySecureCacheResponse(entry, snapshot) : new EntryCacheResponse(entry, snapshot);
        try {
            responseHeadersMap = candidate.getHeaders();
            cachedResponseBody = candidate.getBody();
        }
        catch (Exception e) {
            ++this.networkCount;
            snapshot.close();
            return null;
        }
        if (responseHeadersMap == null || cachedResponseBody == null) {
            try {
                cachedResponseBody.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            ++this.networkCount;
            snapshot.close();
            return null;
        }
        RawHeaders rawResponseHeaders = RawHeaders.fromMultimap(responseHeadersMap);
        ResponseHeaders cachedResponseHeaders = new ResponseHeaders(data.request.getUri(), rawResponseHeaders);
        cachedResponseHeaders.setLocalTimestamps(System.currentTimeMillis(), System.currentTimeMillis());
        long now = System.currentTimeMillis();
        ResponseSource responseSource = cachedResponseHeaders.chooseResponseSource(now, data.request.getHeaders());
        long contentLength = snapshot.getLength(1);
        if (responseSource == ResponseSource.CACHE) {
            data.request.logi("Response retrieved from cache");
            final CachedSocket socket = entry.isHttps() ? new CachedSSLSocket((EntrySecureCacheResponse)candidate, contentLength) : new CachedSocket((EntryCacheResponse)candidate, contentLength);
            rawResponseHeaders.removeAll("Content-Encoding");
            rawResponseHeaders.removeAll("Transfer-Encoding");
            rawResponseHeaders.set("Content-Length", String.valueOf(contentLength));
            socket.pending.add(ByteBuffer.wrap(rawResponseHeaders.toHeaderString().getBytes()));
            this.server.post(new Runnable(){

                @Override
                public void run() {
                    data.connectCallback.onConnectCompleted(null, socket);
                    socket.spewInternal();
                }
            });
            ++this.cacheHitCount;
            return new SimpleCancellable();
        }
        if (responseSource == ResponseSource.CONDITIONAL_CACHE) {
            data.request.logi("Response may be served from conditional cache");
            CacheData cacheData = new CacheData();
            cacheData.snapshot = snapshot;
            cacheData.contentLength = contentLength;
            cacheData.cachedResponseHeaders = cachedResponseHeaders;
            cacheData.candidate = candidate;
            data.state.putParcelable("cache-data", (Parcelable)cacheData);
            return null;
        }
        data.request.logd("Response can not be served from cache");
        try {
            cachedResponseBody.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        ++this.networkCount;
        snapshot.close();
        return null;
    }

    public int getConditionalCacheHitCount() {
        return this.conditionalCacheHitCount;
    }

    public int getCacheHitCount() {
        return this.cacheHitCount;
    }

    public int getNetworkCount() {
        return this.networkCount;
    }

    public int getCacheStoreCount() {
        return this.cacheStoreCount;
    }

    @Override
    public void onBodyDecoder(AsyncHttpClientMiddleware.OnBodyData data) {
        CachedSocket cached = Util.getWrappedSocket(data.socket, CachedSocket.class);
        if (cached != null) {
            data.headers.getHeaders().set(SERVED_FROM, CACHE);
            return;
        }
        CacheData cacheData = (CacheData)data.state.getParcelable("cache-data");
        if (cacheData != null) {
            if (cacheData.cachedResponseHeaders.validate(data.headers)) {
                data.request.logi("Serving response from conditional cache");
                data.headers = cacheData.cachedResponseHeaders.combine(data.headers);
                data.headers.getHeaders().setStatusLine(cacheData.cachedResponseHeaders.getHeaders().getStatusLine());
                data.headers.getHeaders().set(SERVED_FROM, CONDITIONAL_CACHE);
                ++this.conditionalCacheHitCount;
                BodySpewer bodySpewer = new BodySpewer(cacheData.contentLength);
                bodySpewer.cacheResponse = cacheData.candidate;
                bodySpewer.setDataEmitter(data.bodyEmitter);
                data.bodyEmitter = bodySpewer;
                bodySpewer.spew();
                return;
            }
            data.state.remove("cache-data");
            cacheData.snapshot.close();
        }
        if (!this.caching) {
            return;
        }
        if (!data.headers.isCacheable(data.request.getHeaders()) || !data.request.getMethod().equals("GET")) {
            ++this.networkCount;
            data.request.logd("Response is not cacheable");
            return;
        }
        String key = ResponseCacheMiddleware.uriToKey(data.request.getUri());
        RawHeaders varyHeaders = data.request.getHeaders().getHeaders().getAll(data.headers.getVaryFields());
        Entry entry = new Entry(data.request.getUri(), varyHeaders, data.request, data.headers);
        DiskLruCache.Editor editor = null;
        BodyCacher cacher = new BodyCacher();
        try {
            editor = this.cache.edit(key);
            if (editor == null) {
                return;
            }
            entry.writeTo(editor);
            cacher.cacheRequest = new CacheRequestImpl(editor);
            if (cacher.cacheRequest.getBody() == null) {
                return;
            }
            cacher.setDataEmitter(data.bodyEmitter);
            data.bodyEmitter = cacher;
            data.state.putParcelable("body-cacher", (Parcelable)cacher);
            data.request.logd("Caching response");
            ++this.cacheStoreCount;
        }
        catch (Exception e) {
            if (cacher.cacheRequest != null) {
                cacher.cacheRequest.abort();
            }
            cacher.cacheRequest = null;
            ++this.networkCount;
        }
    }

    @Override
    public void onRequestComplete(AsyncHttpClientMiddleware.OnRequestCompleteData data) {
        BodyCacher cacher;
        CachedSocket cachedSocket;
        CacheData cacheData = (CacheData)data.state.getParcelable("cache-data");
        if (cacheData != null && cacheData.snapshot != null) {
            cacheData.snapshot.close();
        }
        if ((cachedSocket = Util.getWrappedSocket(data.socket, CachedSocket.class)) != null) {
            ((SnapshotCacheResponse)((Object)cachedSocket.cacheResponse)).getSnapshot().close();
        }
        if ((cacher = (BodyCacher)data.state.getParcelable("body-cacher")) != null) {
            try {
                if (data.exception != null) {
                    cacher.abort();
                } else {
                    cacher.commit();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static InputStream newBodyInputStream(final DiskLruCache.Snapshot snapshot) {
        return new FilterInputStream(snapshot.getInputStream(1)){

            @Override
            public void close() throws IOException {
                snapshot.close();
                super.close();
            }
        };
    }

    public void clear() throws IOException {
        if (this.cache != null) {
            this.cache.delete();
            this.open();
        }
    }

    static class EntrySecureCacheResponse
    extends SecureCacheResponse
    implements SnapshotCacheResponse {
        private final Entry entry;
        private final DiskLruCache.Snapshot snapshot;
        private final InputStream in;

        @Override
        public DiskLruCache.Snapshot getSnapshot() {
            return this.snapshot;
        }

        public EntrySecureCacheResponse(Entry entry, DiskLruCache.Snapshot snapshot) {
            this.entry = entry;
            this.snapshot = snapshot;
            this.in = ResponseCacheMiddleware.newBodyInputStream(snapshot);
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.entry.responseHeaders.toMultimap();
        }

        @Override
        public InputStream getBody() {
            return this.in;
        }

        @Override
        public String getCipherSuite() {
            return this.entry.cipherSuite;
        }

        @Override
        public List<Certificate> getServerCertificateChain() throws SSLPeerUnverifiedException {
            if (this.entry.peerCertificates == null || this.entry.peerCertificates.length == 0) {
                throw new SSLPeerUnverifiedException(null);
            }
            return Arrays.asList((Object[])this.entry.peerCertificates.clone());
        }

        @Override
        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            if (this.entry.peerCertificates == null || this.entry.peerCertificates.length == 0) {
                throw new SSLPeerUnverifiedException(null);
            }
            return ((X509Certificate)this.entry.peerCertificates[0]).getSubjectX500Principal();
        }

        @Override
        public List<Certificate> getLocalCertificateChain() {
            if (this.entry.localCertificates == null || this.entry.localCertificates.length == 0) {
                return null;
            }
            return Arrays.asList((Object[])this.entry.localCertificates.clone());
        }

        @Override
        public Principal getLocalPrincipal() {
            if (this.entry.localCertificates == null || this.entry.localCertificates.length == 0) {
                return null;
            }
            return ((X509Certificate)this.entry.localCertificates[0]).getSubjectX500Principal();
        }
    }

    static class EntryCacheResponse
    extends CacheResponse
    implements SnapshotCacheResponse {
        private final Entry entry;
        private final DiskLruCache.Snapshot snapshot;
        private final InputStream in;

        @Override
        public DiskLruCache.Snapshot getSnapshot() {
            return this.snapshot;
        }

        public EntryCacheResponse(Entry entry, DiskLruCache.Snapshot snapshot) {
            this.entry = entry;
            this.snapshot = snapshot;
            this.in = ResponseCacheMiddleware.newBodyInputStream(snapshot);
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.entry.responseHeaders.toMultimap();
        }

        @Override
        public InputStream getBody() {
            return this.in;
        }
    }

    static interface SnapshotCacheResponse {
        public DiskLruCache.Snapshot getSnapshot();
    }

    private static final class Entry {
        private final String uri;
        private final RawHeaders varyHeaders;
        private final String requestMethod;
        private final RawHeaders responseHeaders;
        private final String cipherSuite;
        private final Certificate[] peerCertificates;
        private final Certificate[] localCertificates;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Entry(InputStream in) throws IOException {
            try {
                StrictLineReader reader = new StrictLineReader(in, Charsets.US_ASCII);
                this.uri = reader.readLine();
                this.requestMethod = reader.readLine();
                this.varyHeaders = new RawHeaders();
                int varyRequestHeaderLineCount = reader.readInt();
                for (int i = 0; i < varyRequestHeaderLineCount; ++i) {
                    this.varyHeaders.addLine(reader.readLine());
                }
                this.responseHeaders = new RawHeaders();
                this.responseHeaders.setStatusLine(reader.readLine());
                int responseHeaderLineCount = reader.readInt();
                for (int i = 0; i < responseHeaderLineCount; ++i) {
                    this.responseHeaders.addLine(reader.readLine());
                }
                this.cipherSuite = null;
                this.peerCertificates = null;
                this.localCertificates = null;
            }
            finally {
                in.close();
            }
        }

        public Entry(URI uri, RawHeaders varyHeaders, AsyncHttpRequest request, ResponseHeaders responseHeaders) {
            this.uri = uri.toString();
            this.varyHeaders = varyHeaders;
            this.requestMethod = request.getMethod();
            this.responseHeaders = responseHeaders.getHeaders();
            this.cipherSuite = null;
            this.peerCertificates = null;
            this.localCertificates = null;
        }

        public void writeTo(DiskLruCache.Editor editor) throws IOException {
            int i;
            OutputStream out = editor.newOutputStream(0);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, Charsets.UTF_8));
            writer.write(this.uri + '\n');
            writer.write(this.requestMethod + '\n');
            writer.write(Integer.toString(this.varyHeaders.length()) + '\n');
            for (i = 0; i < this.varyHeaders.length(); ++i) {
                writer.write(this.varyHeaders.getFieldName(i) + ": " + this.varyHeaders.getValue(i) + '\n');
            }
            writer.write(this.responseHeaders.getStatusLine() + '\n');
            writer.write(Integer.toString(this.responseHeaders.length()) + '\n');
            for (i = 0; i < this.responseHeaders.length(); ++i) {
                writer.write(this.responseHeaders.getFieldName(i) + ": " + this.responseHeaders.getValue(i) + '\n');
            }
            if (this.isHttps()) {
                ((Writer)writer).write(10);
                writer.write(this.cipherSuite + '\n');
                this.writeCertArray(writer, this.peerCertificates);
                this.writeCertArray(writer, this.localCertificates);
            }
            ((Writer)writer).close();
        }

        private boolean isHttps() {
            return this.uri.startsWith("https://");
        }

        private Certificate[] readCertArray(StrictLineReader reader) throws IOException {
            int length = reader.readInt();
            if (length == -1) {
                return null;
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Certificate[] result = new Certificate[length];
                for (int i = 0; i < result.length; ++i) {
                    String line = reader.readLine();
                    byte[] bytes = Base64.decode((String)line, (int)0);
                    result[i] = certificateFactory.generateCertificate(new ByteArrayInputStream(bytes));
                }
                return result;
            }
            catch (CertificateException e) {
                throw new IOException(e.getMessage());
            }
        }

        private void writeCertArray(Writer writer, Certificate[] certificates) throws IOException {
            if (certificates == null) {
                writer.write("-1\n");
                return;
            }
            try {
                writer.write(Integer.toString(certificates.length) + '\n');
                for (Certificate certificate : certificates) {
                    byte[] bytes = certificate.getEncoded();
                    String line = Base64.encodeToString((byte[])bytes, (int)0);
                    writer.write(line + '\n');
                }
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e.getMessage());
            }
        }

        public boolean matches(URI uri, String requestMethod, Map<String, List<String>> requestHeaders) {
            return this.uri.equals(uri.toString()) && this.requestMethod.equals(requestMethod) && new ResponseHeaders(uri, this.responseHeaders).varyMatches(this.varyHeaders.toMultimap(), requestHeaders);
        }
    }

    private final class CacheRequestImpl
    extends CacheRequest {
        private final DiskLruCache.Editor editor;
        private OutputStream cacheOut;
        private boolean done;
        private OutputStream body;

        public CacheRequestImpl(final DiskLruCache.Editor editor) throws IOException {
            this.editor = editor;
            this.cacheOut = editor.newOutputStream(1);
            this.body = new FilterOutputStream(this.cacheOut){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    ResponseCacheMiddleware responseCacheMiddleware = ResponseCacheMiddleware.this;
                    synchronized (responseCacheMiddleware) {
                        if (CacheRequestImpl.this.done) {
                            return;
                        }
                        CacheRequestImpl.this.done = true;
                        ++ResponseCacheMiddleware.this.writeSuccessCount;
                    }
                    super.close();
                    editor.commit();
                }

                @Override
                public void write(byte[] buffer, int offset, int length) throws IOException {
                    this.out.write(buffer, offset, length);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() {
            ResponseCacheMiddleware responseCacheMiddleware = ResponseCacheMiddleware.this;
            synchronized (responseCacheMiddleware) {
                if (this.done) {
                    return;
                }
                this.done = true;
                ++ResponseCacheMiddleware.this.writeAbortCount;
            }
            try {
                this.cacheOut.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.editor.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public OutputStream getBody() throws IOException {
            return this.body;
        }
    }

    private static class BodySpewer
    extends FilteredDataEmitter {
        long contentLength;
        CacheResponse cacheResponse;
        boolean first = true;
        ByteBufferList pending = new ByteBufferList();
        boolean paused;
        boolean allowEnd;

        public BodySpewer(long contentLength) {
            this.contentLength = contentLength;
        }

        void spewInternal() {
            if (this.pending.remaining() > 0) {
                Util.emitAllData(this, this.pending);
                if (this.pending.remaining() > 0) {
                    return;
                }
            }
            try {
                assert (this.first);
                if (!this.first) {
                    return;
                }
                this.first = false;
                ByteBuffer buffer = ByteBufferList.obtain((int)this.contentLength);
                assert (buffer.position() == 0);
                DataInputStream din = new DataInputStream(this.cacheResponse.getBody());
                din.readFully(buffer.array(), buffer.arrayOffset(), (int)this.contentLength);
                buffer.limit((int)this.contentLength);
                this.pending.add(buffer);
                Util.emitAllData(this, this.pending);
                assert (din.read() == -1);
                this.allowEnd = true;
                this.report(null);
            }
            catch (IOException e) {
                this.allowEnd = true;
                this.report(e);
            }
        }

        void spew() {
            this.getServer().post(new Runnable(){

                @Override
                public void run() {
                    BodySpewer.this.spewInternal();
                }
            });
        }

        @Override
        public void resume() {
            this.paused = false;
            this.spew();
        }

        @Override
        public boolean isPaused() {
            return this.paused;
        }

        @Override
        protected void report(Exception e) {
            if (!this.allowEnd) {
                return;
            }
            try {
                this.cacheResponse.getBody().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.report(e);
        }
    }

    private static class BodyCacher
    extends FilteredDataEmitter
    implements Parcelable {
        CacheRequestImpl cacheRequest;
        ByteBufferList cached;

        private BodyCacher() {
        }

        @Override
        protected void report(Exception e) {
            super.report(e);
            if (e != null) {
                this.abort();
            }
        }

        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            if (this.cached != null) {
                Util.emitAllData(this, this.cached);
                if (this.cached.remaining() > 0) {
                    return;
                }
                this.cached = null;
            }
            try {
                if (this.cacheRequest != null) {
                    OutputStream outputStream = this.cacheRequest.getBody();
                    if (outputStream != null) {
                        int count = bb.size();
                        for (int i = 0; i < count; ++i) {
                            ByteBuffer b = bb.remove();
                            outputStream.write(b.array(), b.arrayOffset() + b.position(), b.remaining());
                            bb.add(b);
                        }
                    } else {
                        this.abort();
                    }
                }
            }
            catch (Exception e) {
                this.abort();
            }
            super.onDataAvailable(emitter, bb);
            if (this.cacheRequest != null && bb.remaining() > 0) {
                this.cached = new ByteBufferList();
                bb.get(this.cached);
            }
        }

        public void abort() {
            if (this.cacheRequest != null) {
                this.cacheRequest.abort();
                this.cacheRequest = null;
            }
        }

        public void commit() {
            if (this.cacheRequest != null) {
                try {
                    this.cacheRequest.getBody().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
        }
    }

    public static class CacheData
    implements Parcelable {
        DiskLruCache.Snapshot snapshot;
        CacheResponse candidate;
        long contentLength;
        ResponseHeaders cachedResponseHeaders;

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
        }
    }

    private class CachedSocket
    extends DataEmitterBase
    implements AsyncSocket {
        CacheResponse cacheResponse;
        long contentLength;
        boolean paused;
        boolean closed;
        boolean first = true;
        ByteBufferList pending = new ByteBufferList();
        boolean open;
        CompletedCallback closedCallback;

        public CachedSocket(CacheResponse cacheResponse, long contentLength) {
            this.cacheResponse = cacheResponse;
            this.contentLength = contentLength;
        }

        @Override
        public void end() {
        }

        @Override
        public boolean isChunked() {
            return false;
        }

        @Override
        public void pause() {
            this.paused = true;
        }

        @Override
        protected void report(Exception e) {
            super.report(e);
            try {
                this.cacheResponse.getBody().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.closedCallback != null) {
                this.closedCallback.onCompleted(e);
            }
        }

        void spewInternal() {
            if (this.pending.remaining() > 0) {
                Util.emitAllData(this, this.pending);
                if (this.pending.remaining() > 0) {
                    return;
                }
            }
            try {
                assert (this.first);
                if (!this.first) {
                    return;
                }
                this.first = false;
                ByteBuffer buffer = ByteBufferList.obtain((int)this.contentLength);
                assert (buffer.position() == 0);
                DataInputStream din = new DataInputStream(this.cacheResponse.getBody());
                din.readFully(buffer.array(), buffer.arrayOffset(), (int)this.contentLength);
                buffer.limit((int)this.contentLength);
                this.pending.add(buffer);
                Util.emitAllData(this, this.pending);
                assert (din.read() == -1);
                this.report(null);
            }
            catch (IOException e) {
                this.report(e);
            }
        }

        void spew() {
            this.getServer().post(new Runnable(){

                @Override
                public void run() {
                    CachedSocket.this.spewInternal();
                }
            });
        }

        @Override
        public void resume() {
            this.paused = false;
            this.spew();
        }

        @Override
        public boolean isPaused() {
            return this.paused;
        }

        @Override
        public void write(ByteBuffer bb) {
            bb.limit(bb.position());
        }

        @Override
        public void write(ByteBufferList bb) {
            bb.recycle();
        }

        @Override
        public void setWriteableCallback(WritableCallback handler) {
        }

        @Override
        public WritableCallback getWriteableCallback() {
            return null;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public void close() {
            this.open = false;
        }

        @Override
        public void setClosedCallback(CompletedCallback handler) {
            this.closedCallback = handler;
        }

        @Override
        public CompletedCallback getClosedCallback() {
            return this.closedCallback;
        }

        @Override
        public AsyncServer getServer() {
            return ResponseCacheMiddleware.this.server;
        }
    }

    private class CachedSSLSocket
    extends CachedSocket
    implements AsyncSSLSocket {
        public CachedSSLSocket(CacheResponse cacheResponse, long contentLength) {
            super(cacheResponse, contentLength);
        }

        @Override
        public X509Certificate[] getPeerCertificates() {
            return null;
        }
    }
}

