/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.koushikdutta.async.AsyncSSLException;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.http.libcore.RequestHeaders;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;

public class AsyncHttpRequest {
    private String mMethod;
    private RawHeaders mRawHeaders = new RawHeaders();
    private RequestHeaders mHeaders;
    @Deprecated
    private Handler mHandler = Looper.myLooper() == null ? null : new Handler();
    private boolean mFollowRedirect = true;
    private AsyncHttpRequestBody mBody;
    public static final int DEFAULT_TIMEOUT = 30000;
    int mTimeout = 30000;
    String proxyHost;
    int proxyPort = -1;
    String LOGTAG;
    int logLevel;
    long executionTime;

    public RequestLine getRequestLine() {
        return new RequestLine(){

            public String getUri() {
                return AsyncHttpRequest.this.getUri().toString();
            }

            public ProtocolVersion getProtocolVersion() {
                return new ProtocolVersion("HTTP", 1, 1);
            }

            public String getMethod() {
                return AsyncHttpRequest.this.mMethod;
            }

            public String toString() {
                String query;
                String path = AsyncHttpRequest.this.getUri().getRawPath();
                if (path.length() == 0) {
                    path = "/";
                }
                if ((query = AsyncHttpRequest.this.getUri().getRawQuery()) != null && query.length() != 0) {
                    path = path + "?" + query;
                }
                return String.format("%s %s HTTP/1.1", AsyncHttpRequest.this.mMethod, path);
            }
        };
    }

    public RequestLine getProxyRequestLine() {
        return new RequestLine(){

            public String getUri() {
                return AsyncHttpRequest.this.getUri().toString();
            }

            public ProtocolVersion getProtocolVersion() {
                return new ProtocolVersion("HTTP", 1, 1);
            }

            public String getMethod() {
                return AsyncHttpRequest.this.mMethod;
            }

            public String toString() {
                return String.format("%s %s HTTP/1.1", AsyncHttpRequest.this.mMethod, AsyncHttpRequest.this.getUri());
            }
        };
    }

    protected static String getDefaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? agent : "Java" + System.getProperty("java.version");
    }

    public String getMethod() {
        return this.mMethod;
    }

    public AsyncHttpRequest setMethod(String method) {
        if (this.getClass() != AsyncHttpRequest.class) {
            throw new UnsupportedOperationException("can't change method on a subclass of AsyncHttpRequest");
        }
        this.mMethod = method;
        this.mRawHeaders.setStatusLine(this.getRequestLine().toString());
        return this;
    }

    public AsyncHttpRequest(URI uri, String method) {
        this(uri, method, null);
    }

    public static void setDefaultHeaders(RawHeaders ret, URI uri) {
        if (uri != null) {
            String host = uri.getHost();
            if (uri.getPort() != -1) {
                host = host + ":" + uri.getPort();
            }
            ret.set("Host", host);
        }
        ret.set("User-Agent", AsyncHttpRequest.getDefaultUserAgent());
        ret.set("Accept-Encoding", "gzip, deflate");
        ret.set("Connection", "keep-alive");
        ret.set("Accept", "*/*");
    }

    public AsyncHttpRequest(URI uri, String method, RawHeaders headers) {
        assert (uri != null);
        this.mMethod = method;
        this.mRawHeaders = headers == null ? new RawHeaders() : headers;
        if (headers == null) {
            AsyncHttpRequest.setDefaultHeaders(this.mRawHeaders, uri);
        }
        this.mHeaders = new RequestHeaders(uri, this.mRawHeaders);
        this.mRawHeaders.setStatusLine(this.getRequestLine().toString());
    }

    public URI getUri() {
        return this.mHeaders.getUri();
    }

    @Deprecated
    public Handler getHandler() {
        return this.mHandler;
    }

    @Deprecated
    public AsyncHttpRequest setHandler(Handler handler) {
        this.mHandler = handler;
        return this;
    }

    public RequestHeaders getHeaders() {
        return this.mHeaders;
    }

    public String getRequestString() {
        return this.mRawHeaders.toHeaderString();
    }

    public boolean getFollowRedirect() {
        return this.mFollowRedirect;
    }

    public AsyncHttpRequest setFollowRedirect(boolean follow) {
        this.mFollowRedirect = follow;
        return this;
    }

    public void setBody(AsyncHttpRequestBody body) {
        this.mBody = body;
    }

    public AsyncHttpRequestBody getBody() {
        return this.mBody;
    }

    public void onHandshakeException(AsyncSSLException e) {
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public AsyncHttpRequest setTimeout(int timeout) {
        this.mTimeout = timeout;
        return this;
    }

    public static AsyncHttpRequest create(HttpRequest request) {
        AsyncHttpRequest ret = new AsyncHttpRequest(URI.create(request.getRequestLine().getUri()), request.getRequestLine().getMethod());
        for (Header header : request.getAllHeaders()) {
            ret.getHeaders().getHeaders().add(header.getName(), header.getValue());
        }
        return ret;
    }

    public HttpRequest asHttpRequest() {
        return new HttpRequestWrapper(this);
    }

    public AsyncHttpRequest setHeader(String name, String value) {
        this.getHeaders().getHeaders().set(name, value);
        return this;
    }

    public AsyncHttpRequest addHeader(String name, String value) {
        this.getHeaders().getHeaders().add(name, value);
        return this;
    }

    public void enableProxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
    }

    public void disableProxy() {
        this.proxyHost = null;
        this.proxyPort = -1;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setLogging(String tag, int level) {
        this.LOGTAG = tag;
        this.logLevel = level;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public String getLogTag() {
        return this.LOGTAG;
    }

    private String getLogMessage(String message) {
        long elapsed = this.executionTime != 0L ? System.currentTimeMillis() - this.executionTime : 0L;
        return String.format("(%d ms) %s: %s", elapsed, this.getUri(), message);
    }

    public void logi(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 4) {
            return;
        }
        Log.i((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logv(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 2) {
            return;
        }
        Log.v((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logw(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 5) {
            return;
        }
        Log.w((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logd(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 3) {
            return;
        }
        Log.d((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void logd(String message, Exception e) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 3) {
            return;
        }
        Log.d((String)this.LOGTAG, (String)this.getLogMessage(message));
        Log.d((String)this.LOGTAG, (String)e.getMessage(), (Throwable)e);
    }

    public void loge(String message) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 6) {
            return;
        }
        Log.e((String)this.LOGTAG, (String)this.getLogMessage(message));
    }

    public void loge(String message, Exception e) {
        if (this.LOGTAG == null) {
            return;
        }
        if (this.logLevel > 6) {
            return;
        }
        Log.e((String)this.LOGTAG, (String)this.getLogMessage(message));
        Log.e((String)this.LOGTAG, (String)e.getMessage(), (Throwable)e);
    }

    private static class HttpRequestWrapper
    implements HttpRequest {
        AsyncHttpRequest request;
        HttpParams params;

        public RequestLine getRequestLine() {
            return this.request.getRequestLine();
        }

        public HttpRequestWrapper(AsyncHttpRequest request) {
            this.request = request;
        }

        public void addHeader(Header header) {
            this.request.getHeaders().getHeaders().add(header.getName(), header.getValue());
        }

        public void addHeader(String name, String value) {
            this.request.getHeaders().getHeaders().add(name, value);
        }

        public boolean containsHeader(String name) {
            return this.request.getHeaders().getHeaders().get(name) != null;
        }

        public Header[] getAllHeaders() {
            Header[] ret = new Header[this.request.getHeaders().getHeaders().length()];
            for (int i = 0; i < ret.length; ++i) {
                String name = this.request.getHeaders().getHeaders().getFieldName(i);
                String value = this.request.getHeaders().getHeaders().getValue(i);
                ret[i] = new BasicHeader(name, value);
            }
            return ret;
        }

        public Header getFirstHeader(String name) {
            String value = this.request.getHeaders().getHeaders().get(name);
            if (value == null) {
                return null;
            }
            return new BasicHeader(name, value);
        }

        public Header[] getHeaders(String name) {
            Map<String, List<String>> map = this.request.getHeaders().getHeaders().toMultimap();
            List<String> vals = map.get(name);
            if (vals == null) {
                return new Header[0];
            }
            Header[] ret = new Header[vals.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new BasicHeader(name, vals.get(i));
            }
            return ret;
        }

        public Header getLastHeader(String name) {
            Header[] vals = this.getHeaders(name);
            if (vals.length == 0) {
                return null;
            }
            return vals[vals.length - 1];
        }

        public HttpParams getParams() {
            return this.params;
        }

        public ProtocolVersion getProtocolVersion() {
            return new ProtocolVersion("HTTP", 1, 1);
        }

        public HeaderIterator headerIterator() {
            assert (false);
            return null;
        }

        public HeaderIterator headerIterator(String name) {
            assert (false);
            return null;
        }

        public void removeHeader(Header header) {
            this.request.getHeaders().getHeaders().removeAll(header.getName());
        }

        public void removeHeaders(String name) {
            this.request.getHeaders().getHeaders().removeAll(name);
        }

        public void setHeader(Header header) {
            this.setHeader(header.getName(), header.getValue());
        }

        public void setHeader(String name, String value) {
            this.request.getHeaders().getHeaders().set(name, value);
        }

        public void setHeaders(Header[] headers) {
            for (Header header : headers) {
                this.setHeader(header);
            }
        }

        public void setParams(HttpParams params) {
            this.params = params;
        }
    }
}

