/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.stream;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.WritableCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class OutputStreamDataSink
implements DataSink {
    AsyncServer server;
    OutputStream mStream;
    final ByteBufferList pending = new ByteBufferList();
    int totalWritten;
    WritableCallback mWritable;
    boolean closeReported;
    Exception closeException;
    CompletedCallback mClosedCallback;
    WritableCallback outputStreamCallback;

    public OutputStreamDataSink(AsyncServer server) {
        this(server, null);
    }

    @Override
    public void end() {
        this.close();
    }

    public OutputStreamDataSink(AsyncServer server, OutputStream stream) {
        this.server = server;
        this.setOutputStream(stream);
    }

    public void setOutputStream(OutputStream stream) {
        this.mStream = stream;
    }

    public OutputStream getOutputStream() {
        return this.mStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPending() {
        try {
            while (this.pending.size() > 0) {
                ByteBuffer b;
                ByteBufferList byteBufferList = this.pending;
                synchronized (byteBufferList) {
                    b = this.pending.remove();
                }
                int rem = b.remaining();
                this.mStream.write(b.array(), b.arrayOffset() + b.position(), b.remaining());
                this.totalWritten += rem;
                ByteBufferList.reclaim(b);
            }
            return true;
        }
        catch (Exception e) {
            this.pending.recycle();
            this.closeReported = true;
            this.closeException = e;
            return false;
        }
    }

    @Override
    public void write(ByteBuffer bb) {
        try {
            this.mStream.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        }
        catch (IOException e) {
            this.reportClose(e);
        }
        bb.position(0);
        bb.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBufferList bb) {
        try {
            while (bb.size() > 0) {
                ByteBuffer b = bb.remove();
                this.mStream.write(b.array(), b.arrayOffset() + b.position(), b.remaining());
                ByteBufferList.reclaim(b);
            }
        }
        catch (IOException e) {
            this.reportClose(e);
        }
        finally {
            bb.recycle();
        }
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mWritable = handler;
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mWritable;
    }

    @Override
    public boolean isOpen() {
        return this.closeReported;
    }

    @Override
    public void close() {
        try {
            if (this.mStream != null) {
                this.mStream.close();
            }
            this.reportClose(null);
        }
        catch (IOException e) {
            this.reportClose(e);
        }
    }

    public void reportClose(Exception ex) {
        if (this.closeReported) {
            return;
        }
        this.closeReported = true;
        this.closeException = ex;
        if (this.mClosedCallback != null) {
            this.mClosedCallback.onCompleted(this.closeException);
        }
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mClosedCallback = handler;
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mClosedCallback;
    }

    @Override
    public AsyncServer getServer() {
        return this.server;
    }

    public void setOutputStreamWritableCallback(WritableCallback outputStreamCallback) {
        this.outputStreamCallback = outputStreamCallback;
    }
}

