/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import android.text.TextUtils;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.BufferedDataSink;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.filter.ChunkedOutputFilter;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.http.libcore.ResponseHeaders;
import com.koushikdutta.async.http.server.AsyncHttpServer;
import com.koushikdutta.async.http.server.AsyncHttpServerRequestImpl;
import com.koushikdutta.async.http.server.AsyncHttpServerResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.json.JSONObject;

public class AsyncHttpServerResponseImpl
implements AsyncHttpServerResponse {
    private RawHeaders mRawHeaders = new RawHeaders();
    private int mContentLength = -1;
    private ResponseHeaders mHeaders = new ResponseHeaders(null, this.mRawHeaders);
    AsyncSocket mSocket;
    AsyncHttpServerRequestImpl mRequest;
    boolean mHasWritten = false;
    DataSink mSink;
    private boolean mHeadWritten = false;
    boolean mEnded;

    @Override
    public ResponseHeaders getHeaders() {
        return this.mHeaders;
    }

    @Override
    public AsyncSocket getSocket() {
        return this.mSocket;
    }

    AsyncHttpServerResponseImpl(AsyncSocket socket, AsyncHttpServerRequestImpl req) {
        this.mSocket = socket;
        this.mRequest = req;
        if (HttpUtil.isKeepAlive(req.getHeaders().getHeaders())) {
            this.mRawHeaders.set("Connection", "Keep-Alive");
        }
    }

    @Override
    public void write(ByteBuffer bb) {
        if (bb.remaining() == 0) {
            return;
        }
        this.writeInternal(bb);
    }

    @Override
    public void write(ByteBufferList bb) {
        if (bb.remaining() == 0) {
            return;
        }
        this.writeInternal(bb);
    }

    private void writeInternal(ByteBuffer bb) {
        assert (!this.mEnded);
        if (!this.mHasWritten) {
            this.initFirstWrite();
            return;
        }
        this.mSink.write(bb);
    }

    private void writeInternal(ByteBufferList bb) {
        assert (!this.mEnded);
        if (!this.mHasWritten) {
            this.initFirstWrite();
            return;
        }
        this.mSink.write(bb);
    }

    void initFirstWrite() {
        String contentLength;
        boolean canUseChunked;
        if (this.mHasWritten) {
            return;
        }
        this.mHasWritten = true;
        assert (null != this.mRawHeaders.getStatusLine());
        String currentEncoding = this.mRawHeaders.get("Transfer-Encoding");
        if ("".equals(currentEncoding)) {
            this.mRawHeaders.removeAll("Transfer-Encoding");
        }
        boolean bl = canUseChunked = ("Chunked".equalsIgnoreCase(currentEncoding) || currentEncoding == null) && !"close".equalsIgnoreCase(this.mRawHeaders.get("Connection"));
        if (this.mContentLength < 0 && !TextUtils.isEmpty((CharSequence)(contentLength = this.mRawHeaders.get("Content-Length")))) {
            this.mContentLength = Integer.valueOf(contentLength);
        }
        if (this.mContentLength < 0 && canUseChunked) {
            this.mRawHeaders.set("Transfer-Encoding", "Chunked");
            this.mSink = new ChunkedOutputFilter(this.mSocket);
        } else {
            this.mSink = this.mSocket;
        }
        this.writeHeadInternal();
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.initFirstWrite();
        this.mSink.setWriteableCallback(handler);
    }

    @Override
    public WritableCallback getWriteableCallback() {
        this.initFirstWrite();
        return this.mSink.getWriteableCallback();
    }

    @Override
    public void end() {
        if ("Chunked".equalsIgnoreCase(this.mRawHeaders.get("Transfer-Encoding"))) {
            this.initFirstWrite();
            ((ChunkedOutputFilter)this.mSink).setMaxBuffer(Integer.MAX_VALUE);
            this.mSink.write(new ByteBufferList());
            this.onEnd();
        } else if (!this.mHasWritten) {
            if (!this.mRequest.getMethod().equalsIgnoreCase("HEAD")) {
                this.send("text/html", "");
            } else {
                this.onEnd();
            }
        }
    }

    @Override
    public void writeHead() {
        this.initFirstWrite();
    }

    private void writeHeadInternal() {
        assert (!this.mHeadWritten);
        this.mHeadWritten = true;
        Util.writeAll((DataSink)this.mSocket, this.mRawHeaders.toHeaderString().getBytes(), new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                WritableCallback writableCallback;
                if (AsyncHttpServerResponseImpl.this.mSink instanceof BufferedDataSink) {
                    ((BufferedDataSink)AsyncHttpServerResponseImpl.this.mSink).setDataSink(AsyncHttpServerResponseImpl.this.mSocket);
                }
                if ((writableCallback = AsyncHttpServerResponseImpl.this.getWriteableCallback()) != null) {
                    writableCallback.onWriteable();
                }
            }
        });
    }

    @Override
    public void setContentType(String contentType) {
        assert (!this.mHeadWritten);
        this.mRawHeaders.set("Content-Type", contentType);
    }

    @Override
    public void send(String contentType, String string) {
        block4: {
            try {
                if (this.mRawHeaders.getStatusLine() == null) {
                    this.responseCode(200);
                }
                assert (this.mContentLength < 0);
                byte[] bytes = string.getBytes("UTF-8");
                this.mContentLength = bytes.length;
                this.mRawHeaders.set("Content-Length", Integer.toString(bytes.length));
                this.mRawHeaders.set("Content-Type", contentType);
                Util.writeAll((DataSink)this, string.getBytes(), new CompletedCallback(){

                    @Override
                    public void onCompleted(Exception ex) {
                        AsyncHttpServerResponseImpl.this.onEnd();
                    }
                });
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    protected void onEnd() {
        this.mEnded = true;
    }

    protected void report(Exception e) {
    }

    @Override
    public void send(String string) {
        this.responseCode(200);
        this.send("text/html; charset=utf8", string);
    }

    @Override
    public void send(JSONObject json) {
        this.send("application/json; charset=utf8", json.toString());
    }

    @Override
    public void sendStream(InputStream inputStream, int totalLength) {
        int start = 0;
        int end = totalLength - 1;
        String range = this.mRequest.getHeaders().getHeaders().get("Range");
        if (range != null) {
            String[] parts = range.split("=");
            if (parts.length != 2 || !"bytes".equals(parts[0])) {
                this.responseCode(416);
                this.end();
                return;
            }
            parts = parts[1].split("-");
            try {
                if (parts.length > 2) {
                    throw new Exception();
                }
                if (!TextUtils.isEmpty((CharSequence)parts[0])) {
                    start = Integer.parseInt(parts[0]);
                }
                end = parts.length == 2 && !TextUtils.isEmpty((CharSequence)parts[1]) ? Integer.parseInt(parts[1]) : totalLength - 1;
                this.responseCode(206);
                this.getHeaders().getHeaders().set("Content-Range", String.format("bytes %d-%d/%d", start, end, totalLength));
            }
            catch (Exception e) {
                this.responseCode(416);
                this.end();
                return;
            }
        }
        try {
            if ((long)start != inputStream.skip(start)) {
                throw new Exception("skip failed to skip requested amount");
            }
            this.mContentLength = end - start + 1;
            this.mRawHeaders.set("Content-Length", "" + this.mContentLength);
            this.mRawHeaders.set("Accept-Ranges", "bytes");
            if (this.getHeaders().getHeaders().getStatusLine() == null) {
                this.responseCode(200);
            }
            if (this.mRequest.getMethod().equals("HEAD")) {
                this.writeHead();
                this.onEnd();
                return;
            }
            Util.pump(inputStream, this.mContentLength, this, new CompletedCallback(){

                @Override
                public void onCompleted(Exception ex) {
                    AsyncHttpServerResponseImpl.this.onEnd();
                }
            });
        }
        catch (Exception e) {
            this.responseCode(404);
            this.end();
        }
    }

    @Override
    public void sendFile(File file) {
        try {
            if (this.mRawHeaders.get("Content-Type") == null) {
                this.mRawHeaders.set("Content-Type", AsyncHttpServer.getContentType(file.getAbsolutePath()));
            }
            FileInputStream fin = new FileInputStream(file);
            this.sendStream(fin, (int)file.length());
        }
        catch (Exception e) {
            this.responseCode(404);
            this.end();
        }
    }

    @Override
    public void responseCode(int code) {
        String status = AsyncHttpServer.getResponseCodeDescription(code);
        this.mRawHeaders.setStatusLine(String.format("HTTP/1.1 %d %s", code, status));
    }

    @Override
    public void redirect(String location) {
        this.responseCode(302);
        this.mRawHeaders.set("Location", location);
        this.end();
    }

    @Override
    public void onCompleted(Exception ex) {
        this.end();
    }

    @Override
    public boolean isOpen() {
        if (this.mSink != null) {
            return this.mSink.isOpen();
        }
        return this.mSocket.isOpen();
    }

    @Override
    public void close() {
        this.end();
        if (this.mSink != null) {
            this.mSink.close();
        } else {
            this.mSocket.close();
        }
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mSink.setClosedCallback(handler);
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mSink.getClosedCallback();
    }

    @Override
    public AsyncServer getServer() {
        return this.mSocket.getServer();
    }
}

