/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.dns;

import com.koushikdutta.async.AsyncDatagramSocket;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.dns.DnsResponse;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;

public class Dns {
    public static Future<DnsResponse> lookup(String host) {
        return Dns.lookup(AsyncServer.getDefault(), host, false, null);
    }

    private static int setFlag(int flags, int value, int offset) {
        return flags | value << offset;
    }

    private static int setQuery(int flags) {
        return Dns.setFlag(flags, 0, 0);
    }

    private static int setRecursion(int flags) {
        return Dns.setFlag(flags, 1, 8);
    }

    private static void addName(ByteBuffer bb, String name) {
        String[] parts;
        for (String part : parts = name.split("\\.")) {
            bb.put((byte)part.length());
            bb.put(part.getBytes());
        }
        bb.put((byte)0);
    }

    private static String parseName(ByteBufferList bb, ByteBuffer backReference) {
        byte len;
        bb.order(ByteOrder.BIG_ENDIAN);
        String ret = "";
        while (0 != (len = bb.get())) {
            if ((len & 0xC0) != 0) {
                int offset = (len & 0x3F) << 16 | bb.get() & 0xFF;
                if (ret.length() > 0) {
                    ret = ret + ".";
                }
                ByteBufferList sub = new ByteBufferList();
                ByteBuffer duplicate = backReference.duplicate();
                duplicate.get(new byte[offset]);
                sub.add(duplicate);
                return ret + Dns.parseName(sub, backReference);
            }
            byte[] bytes = new byte[len];
            bb.get(bytes);
            if (ret.length() > 0) {
                ret = ret + ".";
            }
            ret = ret + new String(bytes);
        }
        return ret;
    }

    private static InetAddress parseAddress(ByteBufferList bb) {
        return null;
    }

    private static DnsResponse parse(ByteBufferList bb) {
        ByteBuffer b = bb.getAll();
        bb.add(b.duplicate());
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.getShort();
        bb.getShort();
        int questions = bb.getShort();
        int answers = bb.getShort();
        bb.getShort();
        bb.getShort();
        for (int i = 0; i < questions; ++i) {
            Dns.parseName(bb, b);
            bb.getShort();
            bb.getShort();
        }
        DnsResponse response = new DnsResponse();
        for (int i = 0; i < answers; ++i) {
            String name = Dns.parseName(bb, b);
            int type = bb.getShort();
            int clazz = bb.getShort();
            int ttl = bb.getInt();
            int length = bb.getShort();
            try {
                if (type == 1) {
                    byte[] data = new byte[length];
                    bb.get(data);
                    response.addresses.add(InetAddress.getByAddress(data));
                    continue;
                }
                if (type == 12) {
                    response.names.add(Dns.parseName(bb, b));
                    continue;
                }
                bb.get(new byte[length]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return response;
    }

    public static Future<DnsResponse> lookup(AsyncServer server, String host) {
        return Dns.lookup(server, host, false, null);
    }

    public static Future<DnsResponse> multicastLookup(AsyncServer server, String host, FutureCallback<DnsResponse> callback) {
        return Dns.lookup(server, host, true, callback);
    }

    public static Future<DnsResponse> multicastLookup(String host, FutureCallback<DnsResponse> callback) {
        return Dns.multicastLookup(AsyncServer.getDefault(), host, callback);
    }

    public static Future<DnsResponse> lookup(AsyncServer server, String host, boolean multicast, FutureCallback<DnsResponse> callback) {
        SimpleFuture<DnsResponse> ret = new SimpleFuture<DnsResponse>();
        if (!multicast) {
            callback = ret.getCompletionCallback();
        }
        ByteBuffer packet = ByteBufferList.obtain(1024).order(ByteOrder.BIG_ENDIAN);
        short id = (short)new Random().nextInt();
        short flags = (short)Dns.setQuery(0);
        if (!multicast) {
            flags = (short)Dns.setRecursion(flags);
        }
        packet.putShort(id);
        packet.putShort(flags);
        packet.putShort(multicast ? (short)1 : 2);
        packet.putShort((short)0);
        packet.putShort((short)0);
        packet.putShort((short)0);
        Dns.addName(packet, host);
        packet.putShort(multicast ? (short)12 : 1);
        packet.putShort((short)1);
        if (!multicast) {
            Dns.addName(packet, host);
            packet.putShort((short)28);
            packet.putShort((short)1);
        }
        packet.flip();
        try {
            AsyncDatagramSocket dgram;
            if (!multicast) {
                dgram = server.connectDatagram(new InetSocketAddress("8.8.8.8", 53));
            } else {
                dgram = AsyncServer.getDefault().openDatagram(new InetSocketAddress(5353), true);
                Field field = DatagramSocket.class.getDeclaredField("impl");
                field.setAccessible(true);
                Object impl = field.get(dgram.getSocket());
                Method method = impl.getClass().getMethod("join", InetAddress.class);
                method.setAccessible(true);
                method.invoke(impl, InetAddress.getByName("224.0.0.251"));
                ((DatagramSocket)dgram.getSocket()).setBroadcast(true);
            }
            dgram.setDataCallback(new DataCallback(){

                @Override
                public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                    try {
                        System.out.println(dgram.getRemoteAddress());
                        System.out.println(Dns.parse(bb));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bb.recycle();
                }
            });
            if (!multicast) {
                dgram.write(packet);
            } else {
                dgram.send(new InetSocketAddress("224.0.0.251", 5353), packet);
            }
        }
        catch (Exception e) {
            ret.setComplete(e);
        }
        return ret;
    }
}

