/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.stream;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.WritableCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class OutputStreamDataSink
implements DataSink {
    AsyncServer server;
    boolean blocking;
    OutputStream mStream;
    final ByteBufferList pending = new ByteBufferList();
    Runnable backgrounder;
    int totalWritten;
    WritableCallback mWritable;
    boolean closeReported;
    Exception closeException;
    CompletedCallback mClosedCallback;
    WritableCallback outputStreamCallback;

    public OutputStreamDataSink(AsyncServer server) {
        this(server, null);
    }

    @Override
    public void end() {
        this.close();
    }

    public OutputStreamDataSink(AsyncServer server, OutputStream stream) {
        this(server, stream, false);
    }

    public OutputStreamDataSink(AsyncServer server, OutputStream stream, boolean blocking) {
        this.server = server;
        this.blocking = blocking;
        this.setOutputStream(stream);
    }

    public void setOutputStream(OutputStream stream) {
        this.mStream = stream;
    }

    public OutputStream getOutputStream() {
        return this.mStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPending() {
        try {
            while (this.pending.size() > 0) {
                ByteBuffer b;
                ByteBufferList byteBufferList = this.pending;
                synchronized (byteBufferList) {
                    b = this.pending.remove();
                }
                int rem = b.remaining();
                this.mStream.write(b.array(), b.arrayOffset() + b.position(), b.remaining());
                this.totalWritten += rem;
                ByteBufferList.reclaim(b);
            }
            return true;
        }
        catch (Exception e) {
            this.pending.recycle();
            this.closeReported = true;
            this.closeException = e;
            return false;
        }
    }

    private void doBackground() {
        assert (this.getServer().getAffinity() == Thread.currentThread());
        if (this.backgrounder != null) {
            return;
        }
        this.backgrounder = new Runnable(){

            @Override
            public void run() {
                if (!OutputStreamDataSink.this.doPending()) {
                    return;
                }
                OutputStreamDataSink.this.getServer().post(new Runnable(){

                    @Override
                    public void run() {
                        OutputStreamDataSink.this.backgrounder = null;
                        if (OutputStreamDataSink.this.outputStreamCallback != null && !OutputStreamDataSink.this.pending.hasRemaining()) {
                            OutputStreamDataSink.this.outputStreamCallback.onWriteable();
                        }
                        if (OutputStreamDataSink.this.closeReported && !OutputStreamDataSink.this.pending.hasRemaining()) {
                            System.out.println("TOTAL WRITEN: " + OutputStreamDataSink.this.totalWritten);
                            if (OutputStreamDataSink.this.mClosedCallback != null) {
                                OutputStreamDataSink.this.mClosedCallback.onCompleted(OutputStreamDataSink.this.closeException);
                            }
                            return;
                        }
                        OutputStreamDataSink.this.doBackground();
                    }
                });
            }
        };
        this.getServer().getExecutorService().execute(this.backgrounder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(final ByteBuffer bb) {
        if (this.getServer().getAffinity() != Thread.currentThread() && this.blocking) {
            this.getServer().run(new Runnable(){

                @Override
                public void run() {
                    OutputStreamDataSink.this.write(bb);
                }
            });
            return;
        }
        if (this.blocking) {
            if (this.pending.remaining() > 262144) {
                return;
            }
            ByteBuffer dup = ByteBufferList.obtain(bb.remaining());
            dup.put(bb);
            dup.flip();
            ByteBufferList byteBufferList = this.pending;
            synchronized (byteBufferList) {
                this.pending.add(dup);
            }
            this.doBackground();
            return;
        }
        try {
            this.mStream.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        }
        catch (IOException e) {
            this.reportClose(e);
        }
        bb.position(0);
        bb.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(final ByteBufferList bb) {
        if (this.getServer().getAffinity() != Thread.currentThread() && this.blocking) {
            this.getServer().run(new Runnable(){

                @Override
                public void run() {
                    OutputStreamDataSink.this.write(bb);
                }
            });
            return;
        }
        if (this.blocking) {
            if (this.pending.remaining() > 262144) {
                return;
            }
            ByteBufferList byteBufferList = this.pending;
            synchronized (byteBufferList) {
                bb.get(this.pending);
            }
            this.doBackground();
            return;
        }
        try {
            while (bb.size() > 0) {
                ByteBuffer b = bb.remove();
                this.mStream.write(b.array(), b.arrayOffset() + b.position(), b.remaining());
                ByteBufferList.reclaim(b);
            }
        }
        catch (IOException e) {
            this.reportClose(e);
        }
        finally {
            bb.recycle();
        }
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mWritable = handler;
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mWritable;
    }

    @Override
    public boolean isOpen() {
        return this.closeReported;
    }

    @Override
    public void close() {
        try {
            if (this.mStream != null) {
                this.mStream.close();
            }
            this.reportClose(null);
        }
        catch (IOException e) {
            this.reportClose(e);
        }
    }

    public void reportClose(Exception ex) {
        if (this.closeReported) {
            return;
        }
        this.closeReported = true;
        this.closeException = ex;
        this.doBackground();
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mClosedCallback = handler;
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mClosedCallback;
    }

    @Override
    public AsyncServer getServer() {
        return this.server;
    }

    public void setOutputStreamWritableCallback(WritableCallback outputStreamCallback) {
        this.outputStreamCallback = outputStreamCallback;
    }
}

