/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.os.Handler;
import com.koushikdutta.async.AsyncSSLException;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.NullDataCallback;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncHttpGet;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.AsyncHttpResponseImpl;
import com.koushikdutta.async.http.AsyncSSLSocketMiddleware;
import com.koushikdutta.async.http.AsyncSocketMiddleware;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.WebSocketImpl;
import com.koushikdutta.async.http.callback.HttpConnectCallback;
import com.koushikdutta.async.http.callback.RequestCallback;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.parser.AsyncParser;
import com.koushikdutta.async.parser.ByteBufferListParser;
import com.koushikdutta.async.parser.JSONObjectParser;
import com.koushikdutta.async.parser.StringParser;
import com.koushikdutta.async.stream.OutputStreamDataCallback;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.json.JSONObject;

public class AsyncHttpClient {
    private static AsyncHttpClient mDefaultInstance;
    ArrayList<AsyncHttpClientMiddleware> mMiddleware = new ArrayList();
    AsyncSSLSocketMiddleware sslSocketMiddleware;
    AsyncSocketMiddleware socketMiddleware;
    AsyncServer mServer;
    private static final String LOGTAG = "AsyncHttp";

    public static AsyncHttpClient getDefaultInstance() {
        if (mDefaultInstance == null) {
            mDefaultInstance = new AsyncHttpClient(AsyncServer.getDefault());
        }
        return mDefaultInstance;
    }

    public ArrayList<AsyncHttpClientMiddleware> getMiddleware() {
        return this.mMiddleware;
    }

    public void insertMiddleware(AsyncHttpClientMiddleware middleware) {
        this.mMiddleware.add(0, middleware);
    }

    public AsyncHttpClient(AsyncServer server) {
        this.mServer = server;
        this.socketMiddleware = new AsyncSocketMiddleware(this);
        this.insertMiddleware(this.socketMiddleware);
        this.sslSocketMiddleware = new AsyncSSLSocketMiddleware(this);
        this.insertMiddleware(this.sslSocketMiddleware);
    }

    public AsyncSocketMiddleware getSocketMiddleware() {
        return this.socketMiddleware;
    }

    public AsyncSSLSocketMiddleware getSSLSocketMiddleware() {
        return this.sslSocketMiddleware;
    }

    public Future<AsyncHttpResponse> execute(AsyncHttpRequest request, HttpConnectCallback callback) {
        FutureAsyncHttpResponse ret = new FutureAsyncHttpResponse();
        this.execute(request, 0, ret, callback);
        return ret;
    }

    private void reportConnectedCompleted(FutureAsyncHttpResponse cancel, Exception ex, AsyncHttpResponseImpl response, AsyncHttpRequest request, HttpConnectCallback callback) {
        boolean complete;
        assert (callback != null);
        if (ex != null) {
            request.loge("Connection error", ex);
            complete = cancel.setComplete(ex);
        } else {
            request.logd("Connection successful");
            complete = cancel.setComplete(response);
        }
        if (complete) {
            callback.onConnectCompleted(ex, response);
            assert (ex != null || response.getSocket() == null || response.getDataCallback() != null);
            return;
        }
        if (response != null) {
            response.setDataCallback(new NullDataCallback());
            response.close();
        }
    }

    private void execute(final AsyncHttpRequest request, final int redirectCount, final FutureAsyncHttpResponse cancel, final HttpConnectCallback callback) {
        if (this.mServer.isAffinityThread()) {
            this.executeAffinity(request, redirectCount, cancel, callback);
        } else {
            this.mServer.post(new Runnable(){

                @Override
                public void run() {
                    AsyncHttpClient.this.executeAffinity(request, redirectCount, cancel, callback);
                }
            });
        }
    }

    private static long getTimeoutRemaining(AsyncHttpRequest request) {
        return request.getTimeout();
    }

    private void executeAffinity(final AsyncHttpRequest request, final int redirectCount, final FutureAsyncHttpResponse cancel, final HttpConnectCallback callback) {
        assert (this.mServer.isAffinityThread());
        if (redirectCount > 15) {
            this.reportConnectedCompleted(cancel, new Exception("too many redirects"), null, request, callback);
            return;
        }
        final URI uri = request.getUri();
        final AsyncHttpClientMiddleware.OnRequestCompleteData data = new AsyncHttpClientMiddleware.OnRequestCompleteData();
        request.executionTime = System.currentTimeMillis();
        data.request = request;
        request.logd("Executing request.");
        if (request.getTimeout() > 0) {
            cancel.timeoutRunnable = new Runnable(){

                @Override
                public void run() {
                    if (data.socketCancellable != null) {
                        data.socketCancellable.cancel();
                        if (data.socket != null) {
                            data.socket.close();
                        }
                    }
                    AsyncHttpClient.this.reportConnectedCompleted(cancel, new TimeoutException(), null, request, callback);
                }
            };
            cancel.scheduled = this.mServer.postDelayed(cancel.timeoutRunnable, AsyncHttpClient.getTimeoutRemaining(request));
        }
        data.connectCallback = new ConnectCallback(){

            @Override
            public void onConnectCompleted(Exception ex, AsyncSocket socket) {
                if (cancel.isCancelled()) {
                    if (socket != null) {
                        socket.close();
                    }
                    return;
                }
                if (cancel.timeoutRunnable != null) {
                    AsyncHttpClient.this.mServer.removeAllCallbacks(cancel.scheduled);
                }
                data.socket = socket;
                for (AsyncHttpClientMiddleware middleware : AsyncHttpClient.this.mMiddleware) {
                    middleware.onSocket(data);
                }
                cancel.socket = socket;
                if (ex != null) {
                    AsyncHttpClient.this.reportConnectedCompleted(cancel, ex, null, request, callback);
                    return;
                }
                AsyncHttpResponseImpl ret = new AsyncHttpResponseImpl(request){

                    @Override
                    protected void onRequestCompleted(Exception ex) {
                        if (cancel.isCancelled()) {
                            return;
                        }
                        if (cancel.timeoutRunnable != null && data.headers == null) {
                            AsyncHttpClient.this.mServer.removeAllCallbacks(cancel.scheduled);
                            cancel.scheduled = AsyncHttpClient.this.mServer.postDelayed(cancel.timeoutRunnable, AsyncHttpClient.getTimeoutRemaining(request));
                        }
                    }

                    @Override
                    public void setDataEmitter(DataEmitter emitter) {
                        data.bodyEmitter = emitter;
                        for (AsyncHttpClientMiddleware middleware : AsyncHttpClient.this.mMiddleware) {
                            middleware.onBodyDecoder(data);
                        }
                        this.mHeaders = data.headers;
                        super.setDataEmitter(data.bodyEmitter);
                        RawHeaders headers = this.mHeaders.getHeaders();
                        if ((headers.getResponseCode() == 301 || headers.getResponseCode() == 302) && request.getFollowRedirect()) {
                            URI redirect = URI.create(headers.get("Location"));
                            if (redirect == null || redirect.getScheme() == null) {
                                redirect = URI.create(uri.toString().substring(0, uri.toString().length() - uri.getPath().length()) + headers.get("Location"));
                            }
                            AsyncHttpRequest newReq = new AsyncHttpRequest(redirect, request.getMethod());
                            newReq.executionTime = request.executionTime;
                            newReq.logLevel = request.logLevel;
                            newReq.LOGTAG = request.LOGTAG;
                            request.logi("Redirecting");
                            newReq.logi("Redirected");
                            AsyncHttpClient.this.execute(newReq, redirectCount + 1, cancel, callback);
                            this.setDataCallback(new NullDataCallback());
                            return;
                        }
                        request.logv("Final (post cache response) headers: " + this.mHeaders.getHeaders().toHeaderString());
                        AsyncHttpClient.this.reportConnectedCompleted(cancel, null, this, request, callback);
                    }

                    @Override
                    protected void onHeadersReceived() {
                        try {
                            if (cancel.isCancelled()) {
                                return;
                            }
                            if (cancel.timeoutRunnable != null) {
                                AsyncHttpClient.this.mServer.removeAllCallbacks(cancel.scheduled);
                            }
                            request.logv("Received headers: " + this.mHeaders.getHeaders().toHeaderString());
                            data.headers = this.mHeaders;
                            for (AsyncHttpClientMiddleware middleware : AsyncHttpClient.this.mMiddleware) {
                                middleware.onHeadersReceived(data);
                            }
                            this.mHeaders = data.headers;
                        }
                        catch (Exception ex) {
                            AsyncHttpClient.this.reportConnectedCompleted(cancel, ex, null, request, callback);
                        }
                    }

                    @Override
                    protected void report(Exception ex) {
                        AsyncSocket socket;
                        if (cancel.isCancelled()) {
                            return;
                        }
                        if (ex instanceof AsyncSSLException) {
                            request.loge("SSL Exception", ex);
                            AsyncSSLException ase = (AsyncSSLException)ex;
                            request.onHandshakeException(ase);
                            if (ase.getIgnore()) {
                                return;
                            }
                        }
                        if ((socket = this.getSocket()) == null) {
                            return;
                        }
                        super.report(ex);
                        if (!(socket.isOpen() && ex == null || this.getHeaders() != null || ex == null)) {
                            AsyncHttpClient.this.reportConnectedCompleted(cancel, ex, null, request, callback);
                        }
                        data.exception = ex;
                        for (AsyncHttpClientMiddleware middleware : AsyncHttpClient.this.mMiddleware) {
                            middleware.onRequestComplete(data);
                        }
                    }

                    @Override
                    public AsyncSocket detachSocket() {
                        request.logd("Detaching socket");
                        AsyncSocket socket = this.getSocket();
                        if (socket == null) {
                            return null;
                        }
                        socket.setWriteableCallback(null);
                        socket.setClosedCallback(null);
                        socket.setEndCallback(null);
                        socket.setDataCallback(null);
                        this.setSocket(null);
                        return socket;
                    }
                };
                ret.setSocket(socket);
            }
        };
        for (AsyncHttpClientMiddleware middleware : this.mMiddleware) {
            Cancellable socketCancellable = middleware.getSocket(data);
            if (socketCancellable == null) continue;
            data.socketCancellable = socketCancellable;
            cancel.setParent(socketCancellable);
            return;
        }
        assert (false);
    }

    public Future<AsyncHttpResponse> execute(URI uri, HttpConnectCallback callback) {
        return this.execute((AsyncHttpRequest)new AsyncHttpGet(uri), callback);
    }

    public Future<AsyncHttpResponse> execute(String uri, HttpConnectCallback callback) {
        return this.execute((AsyncHttpRequest)new AsyncHttpGet(URI.create(uri)), callback);
    }

    @Deprecated
    public Future<ByteBufferList> get(String uri, DownloadCallback callback) {
        return this.getByteBufferList(uri, callback);
    }

    public Future<ByteBufferList> getByteBufferList(String uri) {
        return this.getByteBufferList(uri, null);
    }

    public Future<ByteBufferList> getByteBufferList(String uri, DownloadCallback callback) {
        return this.executeByteBufferList(new AsyncHttpGet(uri), callback);
    }

    public Future<ByteBufferList> executeByteBufferList(AsyncHttpRequest request, DownloadCallback callback) {
        return this.execute(request, new ByteBufferListParser(), callback);
    }

    @Deprecated
    public Future<String> get(String uri, StringCallback callback) {
        return this.executeString(new AsyncHttpGet(uri), callback);
    }

    @Deprecated
    public Future<String> execute(AsyncHttpRequest req, StringCallback callback) {
        return this.executeString(req, callback);
    }

    public Future<String> getString(String uri) {
        return this.executeString(new AsyncHttpGet(uri), null);
    }

    public Future<String> getString(String uri, StringCallback callback) {
        return this.executeString(new AsyncHttpGet(uri), callback);
    }

    public Future<String> executeString(AsyncHttpRequest req) {
        return this.executeString(req, null);
    }

    public Future<String> executeString(AsyncHttpRequest req, StringCallback callback) {
        return this.execute(req, new StringParser(), callback);
    }

    @Deprecated
    public Future<JSONObject> get(String uri, JSONObjectCallback callback) {
        return this.executeJSONObject(new AsyncHttpGet(uri), callback);
    }

    @Deprecated
    public Future<JSONObject> execute(AsyncHttpRequest req, JSONObjectCallback callback) {
        return this.executeJSONObject(req, callback);
    }

    public Future<JSONObject> getJSONObject(String uri) {
        return this.getJSONObject(uri, null);
    }

    public Future<JSONObject> getJSONObject(String uri, JSONObjectCallback callback) {
        return this.executeJSONObject(new AsyncHttpGet(uri), callback);
    }

    public Future<JSONObject> executeJSONObject(AsyncHttpRequest req) {
        return this.executeJSONObject(req, null);
    }

    public Future<JSONObject> executeJSONObject(AsyncHttpRequest req, JSONObjectCallback callback) {
        return this.execute(req, new JSONObjectParser(), callback);
    }

    private <T> void invokeWithAffinity(RequestCallback<T> callback, SimpleFuture<T> future, AsyncHttpResponse response, Exception e, T result) {
        boolean complete = e != null ? future.setComplete(e) : future.setComplete(result);
        if (!complete) {
            return;
        }
        if (callback != null) {
            callback.onCompleted(e, response, result);
        }
    }

    private <T> void invoke(Handler handler, final RequestCallback<T> callback, final SimpleFuture<T> future, final AsyncHttpResponse response, final Exception e, final T result) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AsyncHttpClient.this.invokeWithAffinity(callback, future, response, e, result);
            }
        };
        if (handler == null) {
            this.mServer.post(runnable);
        } else {
            AsyncServer.post(handler, runnable);
        }
    }

    private void invokeProgress(RequestCallback callback, AsyncHttpResponse response, int downloaded, int total) {
        if (callback != null) {
            callback.onProgress(response, downloaded, total);
        }
    }

    private void invokeConnect(RequestCallback callback, AsyncHttpResponse response) {
        if (callback != null) {
            callback.onConnect(response);
        }
    }

    @Deprecated
    public Future<File> get(String uri, String filename, FileCallback callback) {
        return this.executeFile(new AsyncHttpGet(uri), filename, callback);
    }

    @Deprecated
    public Future<File> execute(AsyncHttpRequest req, String filename, FileCallback callback) {
        return this.executeFile(req, filename, callback);
    }

    public Future<File> getFile(String uri, String filename) {
        return this.getFile(uri, filename, null);
    }

    public Future<File> getFile(String uri, String filename, FileCallback callback) {
        return this.executeFile(new AsyncHttpGet(uri), filename, callback);
    }

    public Future<File> executeFile(AsyncHttpRequest req, String filename) {
        return this.executeFile(req, filename, null);
    }

    public Future<File> executeFile(AsyncHttpRequest req, String filename, final FileCallback callback) {
        BufferedOutputStream fout;
        final Handler handler = req.getHandler();
        final File file = new File(filename);
        file.getParentFile().mkdirs();
        try {
            fout = new BufferedOutputStream(new FileOutputStream(file), 8192);
        }
        catch (FileNotFoundException e) {
            SimpleFuture<File> ret = new SimpleFuture<File>();
            ret.setComplete(e);
            return ret;
        }
        final FutureAsyncHttpResponse cancel = new FutureAsyncHttpResponse();
        final SimpleFuture<File> ret = new SimpleFuture<File>(){

            @Override
            public void cancelCleanup() {
                try {
                    ((AsyncHttpResponse)cancel.get()).setDataCallback(new NullDataCallback());
                    ((AsyncHttpResponse)cancel.get()).close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    fout.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                file.delete();
            }
        };
        ret.setParent(cancel);
        this.execute(req, 0, cancel, new HttpConnectCallback(){
            int mDownloaded = 0;

            @Override
            public void onConnectCompleted(Exception ex, final AsyncHttpResponse response) {
                if (ex != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    file.delete();
                    AsyncHttpClient.this.invoke(handler, callback, ret, response, ex, null);
                    return;
                }
                AsyncHttpClient.this.invokeConnect(callback, response);
                final int contentLength = response.getHeaders().getContentLength();
                response.setDataCallback(new OutputStreamDataCallback(fout){

                    @Override
                    public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                        mDownloaded += bb.remaining();
                        super.onDataAvailable(emitter, bb);
                        AsyncHttpClient.this.invokeProgress(callback, response, mDownloaded, contentLength);
                    }
                });
                response.setEndCallback(new CompletedCallback(){

                    @Override
                    public void onCompleted(Exception ex) {
                        try {
                            fout.close();
                        }
                        catch (IOException e) {
                            ex = e;
                        }
                        if (ex != null) {
                            file.delete();
                            AsyncHttpClient.this.invoke(handler, callback, ret, response, ex, null);
                        } else {
                            AsyncHttpClient.this.invoke(handler, callback, ret, response, null, file);
                        }
                    }
                });
            }
        });
        return ret;
    }

    private <T> SimpleFuture<T> execute(AsyncHttpRequest req, final AsyncParser<T> parser, final RequestCallback<T> callback) {
        FutureAsyncHttpResponse cancel = new FutureAsyncHttpResponse();
        final SimpleFuture ret = new SimpleFuture();
        final Handler handler = req.getHandler();
        this.execute(req, 0, cancel, new HttpConnectCallback(){

            @Override
            public void onConnectCompleted(Exception ex, final AsyncHttpResponse response) {
                if (ex != null) {
                    AsyncHttpClient.this.invoke(handler, callback, ret, response, ex, null);
                    return;
                }
                AsyncHttpClient.this.invokeConnect(callback, response);
                int contentLength = response.getHeaders().getContentLength();
                Future parsed = parser.parse(response).setCallback(new FutureCallback<T>(){

                    @Override
                    public void onCompleted(Exception e, T result) {
                        AsyncHttpClient.this.invoke(handler, callback, ret, response, e, result);
                    }
                });
                ret.setParent(parsed);
            }
        });
        ret.setParent(cancel);
        return ret;
    }

    public Future<WebSocket> websocket(final AsyncHttpRequest req, String protocol, final WebSocketConnectCallback callback) {
        WebSocketImpl.addWebSocketUpgradeHeaders(req, protocol);
        final SimpleFuture<WebSocket> ret = new SimpleFuture<WebSocket>();
        Future<AsyncHttpResponse> connect = this.execute(req, new HttpConnectCallback(){

            @Override
            public void onConnectCompleted(Exception ex, AsyncHttpResponse response) {
                if (ex != null) {
                    if (ret.setComplete(ex) && callback != null) {
                        callback.onCompleted(ex, null);
                    }
                    return;
                }
                WebSocket ws = WebSocketImpl.finishHandshake(req.getHeaders().getHeaders(), response);
                if (ws == null ? !ret.setComplete(new Exception("Unable to complete websocket handshake")) : !ret.setComplete(ws)) {
                    return;
                }
                if (callback != null) {
                    callback.onCompleted(ex, ws);
                }
            }
        });
        ret.setParent(connect);
        return ret;
    }

    public Future<WebSocket> websocket(String uri, String protocol, WebSocketConnectCallback callback) {
        assert (callback != null);
        AsyncHttpGet get = new AsyncHttpGet(uri.replace("ws://", "http://").replace("wss://", "https://"));
        return this.websocket(get, protocol, callback);
    }

    public AsyncServer getServer() {
        return this.mServer;
    }

    public static interface WebSocketConnectCallback {
        public void onCompleted(Exception var1, WebSocket var2);
    }

    public static abstract class FileCallback
    extends RequestCallbackBase<File> {
    }

    public static abstract class JSONObjectCallback
    extends RequestCallbackBase<JSONObject> {
    }

    public static abstract class StringCallback
    extends RequestCallbackBase<String> {
    }

    public static abstract class DownloadCallback
    extends RequestCallbackBase<ByteBufferList> {
    }

    public static abstract class RequestCallbackBase<T>
    implements RequestCallback<T> {
        @Override
        public void onProgress(AsyncHttpResponse response, int downloaded, int total) {
        }

        @Override
        public void onConnect(AsyncHttpResponse response) {
        }
    }

    private class FutureAsyncHttpResponse
    extends SimpleFuture<AsyncHttpResponse> {
        public AsyncSocket socket;
        public Object scheduled;
        public Runnable timeoutRunnable;

        private FutureAsyncHttpResponse() {
        }

        @Override
        public boolean cancel() {
            if (!super.cancel()) {
                return false;
            }
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.scheduled != null) {
                AsyncHttpClient.this.mServer.removeAllCallbacks(this.scheduled);
            }
            return true;
        }
    }
}

