/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.util.Base64;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.BufferedDataSink;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.HybiParser;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.koushikdutta.async.http.server.AsyncHttpServerResponse;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.UUID;

public class WebSocketImpl
implements WebSocket {
    static final String MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private LinkedList<ByteBufferList> pending;
    private AsyncSocket mSocket;
    BufferedDataSink mSink;
    HybiParser mParser;
    CompletedCallback mExceptionCallback;
    private WebSocket.StringCallback mStringCallback;
    private DataCallback mDataCallback;

    @Override
    public void end() {
        this.mSocket.end();
    }

    private static byte[] toByteArray(UUID uuid) {
        byte[] byteArray = new byte[16];
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        LongBuffer longBuffer = buffer.asLongBuffer();
        longBuffer.put(new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()});
        return byteArray;
    }

    private static String SHA1(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(text.getBytes("iso-8859-1"), 0, text.length());
            byte[] sha1hash = md.digest();
            return Base64.encodeToString((byte[])sha1hash, (int)0);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void addAndEmit(ByteBufferList bb) {
        if (this.pending == null) {
            Util.emitAllData(this, bb);
            if (bb.remaining() > 0) {
                this.pending = new LinkedList();
                this.pending.add(bb);
            }
            return;
        }
        while (!this.isPaused()) {
            bb = this.pending.remove();
            Util.emitAllData(this, bb);
            if (bb.remaining() <= 0) continue;
            this.pending.add(0, bb);
        }
        if (this.pending.size() == 0) {
            this.pending = null;
        }
    }

    private void setupParser(boolean masking) {
        this.mParser = new HybiParser(this.mSocket){

            @Override
            protected void report(Exception ex) {
                if (WebSocketImpl.this.mExceptionCallback != null) {
                    WebSocketImpl.this.mExceptionCallback.onCompleted(ex);
                }
            }

            @Override
            protected void onMessage(byte[] payload) {
                WebSocketImpl.this.addAndEmit(new ByteBufferList(payload));
            }

            @Override
            protected void onMessage(String payload) {
                if (WebSocketImpl.this.mStringCallback != null) {
                    WebSocketImpl.this.mStringCallback.onStringAvailable(payload);
                }
            }

            @Override
            protected void onDisconnect(int code, String reason) {
                WebSocketImpl.this.mSocket.close();
            }

            @Override
            protected void sendFrame(byte[] frame) {
                WebSocketImpl.this.mSink.write(ByteBuffer.wrap(frame));
            }
        };
        this.mParser.setMasking(masking);
        if (this.mSocket.isPaused()) {
            this.mSocket.resume();
        }
    }

    public WebSocketImpl(AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
        this(request.getSocket());
        String key = request.getHeaders().getHeaders().get("Sec-WebSocket-Key");
        String concat = key + MAGIC;
        String sha1 = WebSocketImpl.SHA1(concat);
        String origin = request.getHeaders().getHeaders().get("Origin");
        response.responseCode(101);
        response.getHeaders().getHeaders().set("Upgrade", "WebSocket");
        response.getHeaders().getHeaders().set("Connection", "Upgrade");
        response.getHeaders().getHeaders().set("Sec-WebSocket-Accept", sha1);
        response.writeHead();
        this.setupParser(false);
    }

    public static void addWebSocketUpgradeHeaders(AsyncHttpRequest req, String protocol) {
        RawHeaders headers = req.getHeaders().getHeaders();
        String key = Base64.encodeToString((byte[])WebSocketImpl.toByteArray(UUID.randomUUID()), (int)2);
        headers.set("Sec-WebSocket-Version", "13");
        headers.set("Sec-WebSocket-Key", key);
        headers.set("Connection", "Upgrade");
        headers.set("Upgrade", "websocket");
        if (protocol != null) {
            headers.set("Sec-WebSocket-Protocol", protocol);
        }
        headers.set("Pragma", "no-cache");
        headers.set("Cache-Control", "no-cache");
        req.getHeaders().setUserAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.15 Safari/537.36");
    }

    public WebSocketImpl(AsyncSocket socket) {
        this.mSocket = socket;
        this.mSink = new BufferedDataSink(this.mSocket);
    }

    public static WebSocket finishHandshake(RawHeaders requestHeaders, AsyncHttpResponse response) {
        if (response == null) {
            return null;
        }
        if (response.getHeaders().getHeaders().getResponseCode() != 101) {
            return null;
        }
        if (!"websocket".equalsIgnoreCase(response.getHeaders().getHeaders().get("Upgrade"))) {
            return null;
        }
        String sha1 = response.getHeaders().getHeaders().get("Sec-WebSocket-Accept");
        if (sha1 == null) {
            return null;
        }
        String key = requestHeaders.get("Sec-WebSocket-Key");
        if (key == null) {
            return null;
        }
        String concat = key + MAGIC;
        String expected = WebSocketImpl.SHA1(concat).trim();
        if (!sha1.equalsIgnoreCase(expected)) {
            return null;
        }
        WebSocketImpl ret = new WebSocketImpl(response.detachSocket());
        ret.setupParser(true);
        return ret;
    }

    @Override
    public void close() {
        this.mSocket.close();
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mSocket.setClosedCallback(handler);
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mSocket.getClosedCallback();
    }

    @Override
    public void setEndCallback(CompletedCallback callback) {
        this.mExceptionCallback = callback;
    }

    @Override
    public CompletedCallback getEndCallback() {
        return this.mExceptionCallback;
    }

    @Override
    public void send(byte[] bytes) {
        this.mSink.write(ByteBuffer.wrap(this.mParser.frame(bytes)));
    }

    @Override
    public void send(String string) {
        this.mSink.write(ByteBuffer.wrap(this.mParser.frame(string)));
    }

    @Override
    public void setStringCallback(WebSocket.StringCallback callback) {
        this.mStringCallback = callback;
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        this.mDataCallback = callback;
    }

    @Override
    public WebSocket.StringCallback getStringCallback() {
        return this.mStringCallback;
    }

    @Override
    public DataCallback getDataCallback() {
        return this.mDataCallback;
    }

    @Override
    public boolean isOpen() {
        return this.mSocket.isOpen();
    }

    @Override
    public boolean isBuffering() {
        return this.mSink.remaining() > 0;
    }

    @Override
    public void write(ByteBuffer bb) {
        byte[] buf = new byte[bb.remaining()];
        bb.get(buf);
        bb.position(0);
        bb.limit(0);
        this.send(buf);
    }

    @Override
    public void write(ByteBufferList bb) {
        byte[] buf = bb.getAllByteArray();
        this.send(buf);
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mSink.setWriteableCallback(handler);
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mSink.getWriteableCallback();
    }

    @Override
    public AsyncSocket getSocket() {
        return this.mSocket;
    }

    @Override
    public AsyncServer getServer() {
        return this.mSocket.getServer();
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public void pause() {
        this.mSocket.pause();
    }

    @Override
    public void resume() {
        this.mSocket.resume();
    }

    @Override
    public boolean isPaused() {
        return this.mSocket.isPaused();
    }
}

