/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataEmitterReader;
import com.koushikdutta.async.TapCallback;
import com.koushikdutta.async.callback.DataCallback;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;

public class PushParser {
    private LinkedList<Object> mWaiting = new LinkedList();
    int mNeeded = 0;
    DataEmitterReader mReader;
    DataEmitter mEmitter;
    private ArrayList<Object> mArgs = new ArrayList();
    private TapCallback mCallback;
    ByteOrder order = ByteOrder.BIG_ENDIAN;
    static Hashtable<Class, Method> mTable = new Hashtable();

    public PushParser readInt() {
        this.mNeeded += 4;
        this.mWaiting.add(Integer.TYPE);
        return this;
    }

    public PushParser readByte() {
        ++this.mNeeded;
        this.mWaiting.add(Byte.TYPE);
        return this;
    }

    public PushParser readShort() {
        this.mNeeded += 2;
        this.mWaiting.add(Short.TYPE);
        return this;
    }

    public PushParser readLong() {
        this.mNeeded += 8;
        this.mWaiting.add(Long.TYPE);
        return this;
    }

    public PushParser readBuffer(int length) {
        if (length != -1) {
            this.mNeeded += length;
        }
        BufferWaiter bw = new BufferWaiter();
        bw.length = length;
        this.mWaiting.add(bw);
        return this;
    }

    public PushParser readLenBuffer() {
        this.readInt();
        BufferWaiter bw = new BufferWaiter();
        bw.length = -1;
        this.mWaiting.add(bw);
        return this;
    }

    public PushParser readString() {
        this.readInt();
        StringWaiter bw = new StringWaiter();
        bw.length = -1;
        this.mWaiting.add(bw);
        return this;
    }

    public PushParser until(byte b, DataCallback callback) {
        UntilWaiter waiter = new UntilWaiter();
        waiter.value = b;
        waiter.callback = callback;
        this.mWaiting.add(waiter);
        ++this.mNeeded;
        return this;
    }

    public PushParser noop() {
        this.mWaiting.add(Object.class);
        return this;
    }

    public PushParser(DataEmitter s) {
        this.mEmitter = s;
        this.mReader = new DataEmitterReader();
        this.mEmitter.setDataCallback(this.mReader);
    }

    Exception stack() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            return e;
        }
    }

    public ByteOrder order() {
        return this.order;
    }

    public PushParser order(ByteOrder order) {
        this.order = order;
        return this;
    }

    public void tap(TapCallback callback) {
        assert (this.mCallback == null);
        assert (this.mWaiting.size() > 0);
        this.mCallback = callback;
        new DataCallback(){
            {
                this.onDataAvailable(PushParser.this.mEmitter, null);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                try {
                    Object waiting;
                    if (bb != null) {
                        bb.order(PushParser.this.order);
                    }
                    while (PushParser.this.mWaiting.size() > 0 && (waiting = PushParser.this.mWaiting.peek()) != null) {
                        if (waiting == Integer.TYPE) {
                            PushParser.this.mArgs.add(bb.getInt());
                            PushParser.this.mNeeded -= 4;
                        } else if (waiting == Short.TYPE) {
                            PushParser.this.mArgs.add(bb.getShort());
                            PushParser.this.mNeeded -= 2;
                        } else if (waiting == Byte.TYPE) {
                            PushParser.this.mArgs.add(bb.get());
                            --PushParser.this.mNeeded;
                        } else if (waiting == Long.TYPE) {
                            PushParser.this.mArgs.add(bb.getLong());
                            PushParser.this.mNeeded -= 8;
                        } else if (waiting == Object.class) {
                            PushParser.this.mArgs.add(null);
                        } else if (waiting instanceof UntilWaiter) {
                            UntilWaiter uw = (UntilWaiter)waiting;
                            boolean different = true;
                            ByteBufferList cb = new ByteBufferList();
                            while (bb.size() > 0) {
                                ByteBuffer b = bb.remove();
                                b.mark();
                                int index = 0;
                                while (b.remaining() > 0 && (different = b.get() != uw.value)) {
                                    ++index;
                                }
                                b.reset();
                                if (!different) {
                                    bb.add(0, b);
                                    bb.get(cb, index);
                                    break;
                                }
                                cb.add(b);
                            }
                            if (uw.callback != null) {
                                uw.callback.onDataAvailable(emitter, cb);
                            }
                            if (different) throw new Exception();
                            --PushParser.this.mNeeded;
                        } else if (waiting instanceof BufferWaiter || waiting instanceof StringWaiter) {
                            BufferWaiter bw = (BufferWaiter)waiting;
                            int length = bw.length;
                            if (length == -1) {
                                length = (Integer)PushParser.this.mArgs.get(PushParser.this.mArgs.size() - 1);
                                PushParser.this.mArgs.remove(PushParser.this.mArgs.size() - 1);
                                bw.length = length;
                                PushParser.this.mNeeded += length;
                            }
                            if (bb.remaining() < length) {
                                throw new Exception();
                            }
                            byte[] bytes = null;
                            if (length > 0) {
                                bytes = new byte[length];
                                bb.get(bytes);
                            }
                            PushParser.this.mNeeded -= length;
                            if (waiting instanceof StringWaiter) {
                                PushParser.this.mArgs.add(new String(bytes));
                            } else {
                                PushParser.this.mArgs.add(bytes);
                            }
                        } else assert (false);
                        PushParser.this.mWaiting.remove();
                    }
                }
                catch (Exception ex) {
                    assert (PushParser.this.mNeeded != 0);
                    PushParser.this.mReader.read(PushParser.this.mNeeded, this);
                    return;
                }
                try {
                    Object[] args = PushParser.this.mArgs.toArray();
                    PushParser.this.mArgs.clear();
                    TapCallback callback = PushParser.this.mCallback;
                    PushParser.this.mCallback = null;
                    Method method = PushParser.getTap(callback);
                    method.invoke((Object)callback, args);
                    return;
                }
                catch (Exception ex) {
                    assert (false);
                    ex.printStackTrace();
                }
            }
        };
    }

    static Method getTap(TapCallback callback) {
        Method found = mTable.get(callback.getClass());
        if (found != null) {
            return found;
        }
        for (Method method : callback.getClass().getMethods()) {
            if (!"tap".equals(method.getName())) continue;
            mTable.put(callback.getClass(), method);
            return method;
        }
        String fail = "-keep class * extends com.koushikdutta.async.TapCallback {\n    *;\n}\n";
        assert (false);
        return null;
    }

    static class UntilWaiter {
        byte value;
        DataCallback callback;

        UntilWaiter() {
        }
    }

    static class StringWaiter
    extends BufferWaiter {
        StringWaiter() {
        }
    }

    static class BufferWaiter {
        int length;

        BufferWaiter() {
        }
    }
}

