/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.SimpleCancellable;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.SimpleMiddleware;
import java.net.URI;
import java.util.HashSet;
import java.util.Hashtable;

public class AsyncSocketMiddleware
extends SimpleMiddleware {
    String scheme;
    int port;
    AsyncHttpClient mClient;
    private Hashtable<String, HashSet<AsyncSocket>> mSockets = new Hashtable();

    public AsyncSocketMiddleware(AsyncHttpClient client, String scheme, int port) {
        this.mClient = client;
        this.scheme = scheme;
        this.port = port;
    }

    public int getSchemePort(URI uri) {
        if (!uri.getScheme().equals(this.scheme)) {
            return -1;
        }
        if (uri.getPort() == -1) {
            return this.port;
        }
        return uri.getPort();
    }

    public AsyncSocketMiddleware(AsyncHttpClient client) {
        this(client, "http", 80);
    }

    protected ConnectCallback wrapCallback(ConnectCallback callback, URI uri, int port) {
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cancellable getSocket(final AsyncHttpClientMiddleware.GetSocketData data) {
        URI uri = data.request.getUri();
        int port = this.getSchemePort(data.request.getUri());
        if (port == -1) {
            return null;
        }
        String lookup = uri.getScheme() + "//" + uri.getHost() + ":" + port;
        data.state.putBoolean(this.getClass().getCanonicalName() + ".owned", true);
        HashSet<AsyncSocket> sockets = this.mSockets.get(lookup);
        if (sockets != null) {
            HashSet<AsyncSocket> hashSet = sockets;
            synchronized (hashSet) {
                for (final AsyncSocket socket : sockets) {
                    if (!socket.isOpen()) continue;
                    sockets.remove(socket);
                    socket.setClosedCallback(null);
                    this.mClient.getServer().post(new Runnable(){

                        @Override
                        public void run() {
                            data.request.logd("Reusing keep-alive socket");
                            data.connectCallback.onConnectCompleted(null, socket);
                        }
                    });
                    return new SimpleCancellable();
                }
            }
        }
        data.request.logd("Connecting socket");
        return this.mClient.getServer().connectSocket(uri.getHost(), port, this.wrapCallback(data.connectCallback, uri, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequestComplete(final AsyncHttpClientMiddleware.OnRequestCompleteData data) {
        if (!data.state.getBoolean(this.getClass().getCanonicalName() + ".owned", false)) {
            return;
        }
        if (data.exception != null || !data.socket.isOpen()) {
            data.socket.close();
            return;
        }
        String kas = data.headers.getConnection();
        if (kas == null || !"keep-alive".toLowerCase().equals(kas.toLowerCase())) {
            data.socket.close();
            return;
        }
        data.request.logd("Recycling keep-alive socket");
        URI uri = data.request.getUri();
        int port = this.getSchemePort(data.request.getUri());
        String lookup = uri.getScheme() + "//" + uri.getHost() + ":" + port;
        HashSet<AsyncSocket> sockets = this.mSockets.get(lookup);
        if (sockets == null) {
            sockets = new HashSet();
            this.mSockets.put(lookup, sockets);
        }
        final HashSet<AsyncSocket> ss = sockets;
        HashSet<AsyncSocket> hashSet = sockets;
        synchronized (hashSet) {
            sockets.add(data.socket);
            data.socket.setClosedCallback(new CompletedCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompleted(Exception ex) {
                    HashSet hashSet = ss;
                    synchronized (hashSet) {
                        ss.remove(data.socket);
                    }
                    data.socket.setClosedCallback(null);
                }
            });
        }
    }
}

