/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.json;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;
import kong.unirest.json.JsonEngine;

class ToObjectMapper {
    private static Map<Predicate<JsonEngine.Element>, Function<JsonEngine.Element, Object>> mappers = new HashMap<Predicate<JsonEngine.Element>, Function<JsonEngine.Element, Object>>();

    ToObjectMapper() {
    }

    private static Object mapPrimative(JsonEngine.Primitive e) {
        if (e.isBoolean()) {
            return e.getAsBoolean();
        }
        if (e.isNumber()) {
            String s = e.getAsString();
            if (s.contains(".")) {
                return e.getAsDouble();
            }
            if ((long)e.getAsInt() == e.getAsLong()) {
                return e.getAsInt();
            }
            return e.getAsLong();
        }
        if (e.isJsonNull()) {
            return null;
        }
        return e.getAsString();
    }

    public Object apply(JsonEngine.Element e) {
        return mappers.entrySet().stream().filter(r -> ((Predicate)r.getKey()).test(e)).map(r -> ((Function)r.getValue()).apply(e)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    static {
        mappers.put(j -> j == null || j.isJsonNull(), j -> null);
        mappers.put(JsonEngine.Element::isJsonArray, JSONArray::new);
        mappers.put(JsonEngine.Element::isJsonObject, JSONObject::new);
        mappers.put(JsonEngine.Element::isJsonPrimitive, j -> ToObjectMapper.mapPrimative(j.getAsJsonPrimitive()));
    }
}

