/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.java;

import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import kong.unirest.BasicResponse;
import kong.unirest.Client;
import kong.unirest.Config;
import kong.unirest.FailedResponse;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestSummary;
import kong.unirest.HttpResponse;
import kong.unirest.MetricContext;
import kong.unirest.RawResponse;
import kong.unirest.UnirestException;
import kong.unirest.WebSocketRequest;
import kong.unirest.WebSocketResponse;
import kong.unirest.java.BodyBuilder;
import kong.unirest.java.JavaClientBuilder;
import kong.unirest.java.JavaResponse;

public class JavaClient
implements Client {
    private final Config config;
    private final HttpClient client;

    public JavaClient(Config config) {
        this.config = config;
        this.client = new JavaClientBuilder().apply(config);
    }

    public JavaClient(Config config, HttpClient client) {
        this.config = config;
        this.client = client;
    }

    public HttpClient getClient() {
        return this.client;
    }

    @Override
    public <T> HttpResponse<T> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer, Class<?> resultType) {
        HttpRequestSummary reqSum = request.toSummary();
        this.config.getUniInterceptor().onRequest(request, this.config);
        java.net.http.HttpRequest requestObj = this.getRequest(request);
        MetricContext metric = this.config.getMetric().begin(reqSum);
        try {
            java.net.http.HttpResponse<InputStream> execute = this.client.send(requestObj, responseInfo -> HttpResponse.BodySubscribers.ofInputStream());
            JavaResponse t = new JavaResponse(execute, this.config);
            metric.complete(t.toSummary(), null);
            HttpResponse<T> httpResponse = this.transformBody(transformer, t);
            this.config.getUniInterceptor().onResponse(httpResponse, reqSum, this.config);
            return httpResponse;
        }
        catch (Exception e) {
            metric.complete(null, e);
            return this.config.getUniInterceptor().onFail(e, reqSum, this.config);
        }
    }

    private java.net.http.HttpRequest getRequest(HttpRequest<?> request) {
        try {
            URI url = URI.create(request.getUrl());
            HttpRequest.Builder jreq = java.net.http.HttpRequest.newBuilder(url).version(HttpClient.Version.HTTP_2).method(request.getHttpMethod().name(), new BodyBuilder(this.config, request).getBody()).timeout(Duration.ofMillis(request.getConnectTimeout()));
            this.setHeaders(request, jreq);
            return jreq.build();
        }
        catch (RuntimeException e) {
            if (e instanceof UnirestException) {
                throw e;
            }
            throw new UnirestException(e);
        }
    }

    private void setHeaders(HttpRequest<?> request, HttpRequest.Builder jreq) {
        request.getHeaders().all().forEach(h -> jreq.header(h.getName(), h.getValue()));
        if (request.getBody().isPresent() && !request.getHeaders().containsKey("Content-Type")) {
            Object value = "text/plain";
            Charset charset = request.getBody().get().getCharset();
            if (charset != null) {
                value = (String)value + "; charset=" + charset.toString();
            }
            jreq.header("Content-Type", (String)value);
        }
        if (!request.getHeaders().containsKey("Content-Encoding") && this.config.isRequestCompressionOn()) {
            jreq.header("Accept-Encoding", "gzip");
        }
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer, CompletableFuture<HttpResponse<T>> callback, Class<?> resultType) {
        HttpRequestSummary reqSum = request.toSummary();
        this.config.getUniInterceptor().onRequest(request, this.config);
        java.net.http.HttpRequest requestObj = this.getRequest(request);
        MetricContext metric = this.config.getMetric().begin(reqSum);
        CompletableFuture<java.net.http.HttpResponse<InputStream>> execute = this.client.sendAsync(requestObj, HttpResponse.BodyHandlers.ofInputStream());
        return ((CompletableFuture)execute.thenApplyAsync(h -> {
            JavaResponse t = new JavaResponse((java.net.http.HttpResponse<InputStream>)h, this.config);
            metric.complete(t.toSummary(), null);
            HttpResponse httpResponse = this.transformBody(transformer, t);
            this.config.getUniInterceptor().onResponse(httpResponse, reqSum, this.config);
            callback.complete(httpResponse);
            return httpResponse;
        })).exceptionally(e -> {
            UnirestException ex = new UnirestException((Throwable)e);
            metric.complete(null, ex);
            try {
                HttpResponse<?> r = this.config.getUniInterceptor().onFail(ex, reqSum, this.config);
                callback.complete(r);
                return r;
            }
            catch (Exception ee) {
                callback.completeExceptionally((Throwable)e);
                return new FailedResponse(ex);
            }
        });
    }

    @Override
    public WebSocketResponse websocket(WebSocketRequest request, WebSocket.Listener listener) {
        WebSocket.Builder b = this.client.newWebSocketBuilder();
        request.getHeaders().all().forEach(h -> b.header(h.getName(), h.getValue()));
        return new WebSocketResponse(b.buildAsync(URI.create(request.getUrl()), listener), listener);
    }

    protected <T> HttpResponse<T> transformBody(Function<RawResponse, HttpResponse<T>> transformer, RawResponse rr) {
        try {
            return transformer.apply(rr);
        }
        catch (RuntimeException e) {
            String originalBody = this.recoverBody(rr);
            return new BasicResponse(rr, originalBody, e);
        }
    }

    private String recoverBody(RawResponse rr) {
        try {
            return rr.getContentAsString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

