/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import kong.unirest.Config;
import kong.unirest.GetRequest;
import kong.unirest.HttpMethod;
import kong.unirest.HttpRequestBody;
import kong.unirest.HttpRequestJsonPatch;
import kong.unirest.HttpRequestNoBody;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.JsonPatchRequest;
import kong.unirest.WebSocketRequest;
import kong.unirest.WebSocketRequestImpl;

public class UnirestInstance {
    private final Config config;

    public UnirestInstance(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean clearOptions) {
        this.config.reset(clearOptions);
    }

    public GetRequest get(String url) {
        return new HttpRequestNoBody(this.config, HttpMethod.GET, url);
    }

    public GetRequest head(String url) {
        return new HttpRequestNoBody(this.config, HttpMethod.HEAD, url);
    }

    public GetRequest options(String url) {
        return new HttpRequestNoBody(this.config, HttpMethod.OPTIONS, url);
    }

    public HttpRequestWithBody post(String url) {
        return new HttpRequestBody(this.config, HttpMethod.POST, url);
    }

    public HttpRequestWithBody delete(String url) {
        return new HttpRequestBody(this.config, HttpMethod.DELETE, url);
    }

    public HttpRequestWithBody patch(String url) {
        return new HttpRequestBody(this.config, HttpMethod.PATCH, url);
    }

    public HttpRequestWithBody put(String url) {
        return new HttpRequestBody(this.config, HttpMethod.PUT, url);
    }

    public JsonPatchRequest jsonPatch(String url) {
        return new HttpRequestJsonPatch(this.config, url);
    }

    public HttpRequestWithBody request(String method, String url) {
        return new HttpRequestBody(this.config, HttpMethod.valueOf(method), url);
    }

    public void close() {
        this.reset(true);
    }

    public WebSocketRequest webSocket(String url) {
        return new WebSocketRequestImpl(this.config, url);
    }
}

