/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONElement;
import kong.unirest.json.JSONException;
import kong.unirest.json.JSONString;
import kong.unirest.json.NullObject;

public class JSONObject
extends JSONElement {
    public static final Object NULL = new NullObject();
    private final transient JsonObject obj;

    public JSONObject(String string) {
        this((JsonElement)JSONObject.fromJson(string, JsonObject.class));
    }

    public JSONObject(Map<String, Object> map) {
        this((JsonElement)JSONObject.fromJson(JSONObject.toJson(map), JsonObject.class));
    }

    public JSONObject() {
        this((JsonElement)new JsonObject());
    }

    JSONObject(JsonElement jsonElement) {
        super(jsonElement);
        this.obj = jsonElement.getAsJsonObject();
    }

    public static String quote(String s) {
        return new Gson().toJson((Object)s);
    }

    public static Writer quote(String s, Writer writer) throws IOException {
        writer.write(JSONObject.quote(s));
        return writer;
    }

    public static Object stringToValue(String str) {
        if (str.contentEquals("null")) {
            return NULL;
        }
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        if (str.contains(".")) {
            return Double.valueOf(str);
        }
        return Integer.valueOf(str);
    }

    public static Object wrap(Object obj) {
        if (obj == null || obj.equals(NULL)) {
            return NULL;
        }
        if (JSONObject.isPrimitive(obj)) {
            return obj;
        }
        if (obj instanceof Map) {
            return new JSONObject((Map)obj);
        }
        if (obj instanceof Collection) {
            return new JSONArray((Collection)obj);
        }
        if (obj.getClass().isArray()) {
            return JSONObject.wrapArray(obj);
        }
        return new JSONObject();
    }

    private static JSONArray wrapArray(Object obj) {
        JSONArray array = new JSONArray();
        int length = Array.getLength(obj);
        for (int i = 0; i < length; ++i) {
            Object arrayElement = Array.get(obj, i);
            array.put(arrayElement);
        }
        return array;
    }

    private static boolean isPrimitive(Object o) {
        return o instanceof String || o instanceof Number || o instanceof Boolean;
    }

    public static String doubleToString(double d) {
        if (d == Math.floor(d) && !Double.isInfinite(d)) {
            return Integer.toString((int)d);
        }
        return Double.toString(d);
    }

    public static String numberToString(Number number) throws JSONException {
        return String.valueOf(number);
    }

    public static String valueToString(Object o) throws JSONException {
        if (o == null) {
            return "null";
        }
        if (o instanceof JSONString) {
            return ((JSONString)o).toJSONString();
        }
        if (o instanceof JSONElement) {
            return o.toString();
        }
        return new Gson().toJson(o);
    }

    public static String[] getNames(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isEmpty()) {
            return null;
        }
        List list = jsonObject.names().toList();
        return list.toArray(new String[list.size()]);
    }

    public static String[] getNames(Object o) {
        if (o instanceof JSONObject) {
            return JSONObject.getNames((JSONObject)o);
        }
        return new String[0];
    }

    JsonElement asElement() {
        return this.obj;
    }

    public String toString() {
        return JSONObject.toJson(this.obj);
    }

    public String toString(int i) throws JSONException {
        return JSONObject.toPrettyJson((JsonElement)this.obj);
    }

    public boolean similar(Object o) {
        if (!(o instanceof JSONObject)) {
            return false;
        }
        JSONObject cst = (JSONObject)o;
        return this.obj.equals((Object)cst.obj);
    }

    public boolean has(String key) {
        return this.obj.has(key);
    }

    public int length() {
        return this.obj.size();
    }

    public Object get(String key) throws JSONException {
        return MAPPER.apply(this.getProperty(key));
    }

    public JSONObject getJSONObject(String key) throws JSONException {
        try {
            return new JSONObject((JsonElement)this.getProperty(key).getAsJsonObject());
        }
        catch (IllegalStateException e) {
            throw new JSONException("JSONObject[\"%s\"] is not a JSONObject.", key);
        }
    }

    public JSONObject optJSONObject(String key) {
        return this.getOrDefault(() -> this.getJSONObject(key), null);
    }

    public JSONArray getJSONArray(String key) throws JSONException {
        try {
            return new JSONArray(this.getProperty(key).getAsJsonArray());
        }
        catch (IllegalStateException e) {
            throw new JSONException("JSONObject[\"%s\"] is not a JSONArray.", key);
        }
    }

    public JSONArray optJSONArray(String key) {
        return this.getOrDefault(() -> this.getJSONArray(key), null);
    }

    public String getString(String key) throws JSONException {
        return this.getProperty(key).getAsString();
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        return this.getOrDefault(() -> this.getString(key), defaultValue);
    }

    public double getDouble(String key) throws JSONException {
        return this.tryNumber(() -> this.getProperty(key).getAsDouble(), key);
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        return this.getOrDefault(() -> this.getDouble(key), defaultValue);
    }

    public float getFloat(String key) throws JSONException {
        return this.tryNumber(() -> Float.valueOf(this.getProperty(key).getAsFloat()), key).floatValue();
    }

    public float optFloat(String key) {
        return this.optFloat(key, Float.NaN);
    }

    public float optFloat(String key, float defaultValue) {
        return this.getOrDefault(() -> Float.valueOf(this.getFloat(key)), Float.valueOf(defaultValue)).floatValue();
    }

    public long getLong(String key) throws JSONException {
        return this.tryNumber(() -> this.getProperty(key).getAsLong(), key);
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        return this.getOrDefault(() -> this.getLong(key), defaultValue);
    }

    public Number getNumber(String key) throws JSONException {
        return this.tryNumber(() -> this.getProperty(key).getAsInt(), key);
    }

    public Number optNumber(String key) {
        return this.optNumber(key, 0);
    }

    public Number optNumber(String key, Number defaultValue) {
        return this.getOrDefault(() -> this.getNumber(key), defaultValue);
    }

    public int getInt(String key) throws JSONException {
        return this.tryNumber(() -> this.getProperty(key).getAsInt(), key);
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        return this.getOrDefault(() -> this.getInt(key), defaultValue);
    }

    public BigInteger getBigInteger(String key) throws JSONException {
        return this.tryNumber(() -> this.getProperty(key).getAsBigInteger(), key);
    }

    public BigInteger optBigInteger(String key, BigInteger defaultValue) {
        return this.getOrDefault(() -> this.getBigInteger(key), defaultValue);
    }

    public BigDecimal getBigDecimal(String key) throws JSONException {
        return this.tryNumber(() -> this.getProperty(key).getAsBigDecimal(), key);
    }

    public BigDecimal optBigDecimal(String key, BigDecimal defaultValue) {
        return this.getOrDefault(() -> this.getBigDecimal(key), defaultValue);
    }

    public boolean getBoolean(String key) throws JSONException {
        JsonElement e = this.getProperty(key);
        if (!e.isJsonPrimitive() || !e.getAsJsonPrimitive().isBoolean()) {
            throw new JSONException("JSONObject[\"%s\"] is not a boolean.", key);
        }
        return e.getAsBoolean();
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        return this.getOrDefault(() -> this.getBoolean(key), defaultValue);
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumClass, String key) throws JSONException {
        try {
            String v = this.getProperty(key).getAsString();
            return Enum.valueOf(enumClass, v);
        }
        catch (IllegalArgumentException e) {
            throw new JSONException("JSONObject[\"%s\"] is not an enum of type \"%s\".", key, enumClass.getSimpleName());
        }
    }

    public <T extends Enum<T>> T optEnum(Class<T> enumClass, String key) {
        return this.optEnum(enumClass, key, null);
    }

    public <T extends Enum<T>> T optEnum(Class<T> enumClass, String key, T defaultValue) {
        return (T)this.getOrDefault(() -> this.getEnum(enumClass, key), defaultValue);
    }

    public JSONObject put(String key, JSONObject object) throws JSONException {
        this.obj.add(key, (JsonElement)object.obj);
        return this;
    }

    public JSONObject put(String key, JSONArray array) throws JSONException {
        this.obj.add(key, (JsonElement)array.getArray());
        return this;
    }

    public JSONObject put(String key, boolean value) throws JSONException {
        this.obj.addProperty(key, Boolean.valueOf(value));
        return this;
    }

    public JSONObject put(String key, Number value) throws JSONException {
        this.obj.addProperty(key, value);
        return this;
    }

    public JSONObject put(String key, double value) throws JSONException {
        this.obj.addProperty(key, (Number)value);
        return this;
    }

    public JSONObject put(String key, float value) throws JSONException {
        this.obj.addProperty(key, (Number)Float.valueOf(value));
        return this;
    }

    public JSONObject put(String key, long value) throws JSONException {
        this.obj.addProperty(key, (Number)value);
        return this;
    }

    public JSONObject put(String key, int value) throws JSONException {
        this.obj.addProperty(key, (Number)value);
        return this;
    }

    public JSONObject put(String key, String value) throws JSONException {
        this.obj.addProperty(key, value);
        return this;
    }

    public JSONObject put(String key, Collection value) throws JSONException {
        this.put(key, new JSONArray(value));
        return this;
    }

    public JSONObject put(String key, Map value) throws JSONException {
        this.put(key, new JSONObject(value));
        return this;
    }

    public <T extends Enum<T>> JSONObject put(String key, T enumvalue) throws JSONException {
        this.obj.add(key, (JsonElement)(enumvalue == null ? JsonNull.INSTANCE : new JsonPrimitive(enumvalue.name())));
        return this;
    }

    public Object remove(String key) {
        if (!this.has(key)) {
            return null;
        }
        Object o = this.get(key);
        this.obj.remove(key);
        return o;
    }

    public JSONObject accumulate(String key, Object additionalValue) throws JSONException {
        Objects.requireNonNull(key, "Null key.");
        if (!this.obj.has(key)) {
            return this;
        }
        Object existing = this.get(key);
        if (existing instanceof JSONArray) {
            ((JSONArray)existing).put(additionalValue);
            this.put(key, (JSONArray)existing);
        } else {
            JSONArray a = new JSONArray();
            a.put(existing);
            a.put(additionalValue);
            this.put(key, a);
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        Objects.requireNonNull(key, "Null key.");
        if (this.has(key)) {
            JSONArray arr = this.getJSONArray(key);
            arr.put(value);
            this.put(key, arr);
        } else {
            JSONArray arr = new JSONArray();
            arr.put(value);
            this.put(key, arr);
        }
        return this;
    }

    public JSONObject increment(String key) throws JSONException {
        if (!this.has(key)) {
            this.put(key, 1);
        } else {
            Object n = this.get(key);
            if (!(n instanceof Number)) {
                throw new JSONException("");
            }
            if (n instanceof Integer) {
                this.put(key, (Integer)n + 1);
            } else if (n instanceof Double) {
                this.put(key, (Double)n + 1.0);
            }
        }
        return this;
    }

    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (this.has(key)) {
            throw new JSONException("Duplicate key \"foo\"");
        }
        return this.put(key, value);
    }

    public JSONObject put(String key, Object value) throws JSONException {
        if (value == null) {
            this.put(key, (String)value);
        } else if (value instanceof Number) {
            this.put(key, (Number)value);
        } else if (value instanceof Boolean) {
            this.put(key, (Boolean)value);
        } else if (value instanceof JSONArray) {
            this.put(key, (JSONArray)value);
        } else if (value instanceof JSONObject) {
            this.put(key, (JSONObject)value);
        } else if (value instanceof Map) {
            this.put(key, (Map)value);
        } else if (value instanceof Collection) {
            this.put(key, (Collection)value);
        } else if (value.getClass().isArray()) {
            this.put(key, JSONObject.wrapArray(value));
        } else {
            this.put(key, String.valueOf(value));
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key == null || value == null) {
            return this;
        }
        return this.put(key, value);
    }

    public Set<String> keySet() {
        return this.obj.keySet();
    }

    public Iterator<String> keys() {
        return this.obj.keySet().iterator();
    }

    public Map<String, Object> toMap() {
        return JSONObject.toMap(this.obj);
    }

    public JSONArray names() {
        return new JSONArray(this.keySet());
    }

    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        if (names == null || names.isEmpty()) {
            return null;
        }
        JSONArray array = new JSONArray();
        for (Object name : names) {
            array.put(this.opt(String.valueOf(name)));
        }
        return array;
    }

    private JsonElement getProperty(String key) {
        if (!this.obj.has(key)) {
            throw new JSONException("JSONObject[\"%s\"] not found.", key);
        }
        return this.obj.get(key);
    }

    private <T extends Number> T tryNumber(Supplier<T> supplier, String key) {
        try {
            return (T)((Number)supplier.get());
        }
        catch (NumberFormatException e) {
            throw new JSONException("JSONObject[\"%s\"] is not a number.", key);
        }
    }

    private <T> T getOrDefault(Supplier<T> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean equals(Object other) {
        return this.similar(other);
    }

    public int hashCode() {
        return this.obj.hashCode();
    }

    public Object opt(String key) {
        try {
            return this.get(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public boolean isEmpty() {
        return this.obj.size() == 0;
    }

    public boolean isNull(String key) {
        return !this.has(key) || this.get(key) == null;
    }
}

