/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kong.unirest.Config;
import kong.unirest.Header;
import kong.unirest.HttpMethod;
import kong.unirest.HttpRequest;
import kong.unirest.UnirestException;
import kong.unirest.apache.ApacheBodyMapper;
import kong.unirest.apache.ApacheDeleteWithBody;
import kong.unirest.apache.ApachePatchWithBody;
import kong.unirest.apache.ApacheRequestWithBody;
import kong.unirest.apache.RequestOptions;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NByteArrayEntity;

class RequestPrep {
    private static final String CONTENT_TYPE = "content-type";
    private static final String ACCEPT_ENCODING_HEADER = "accept-encoding";
    private static final String USER_AGENT_HEADER = "user-agent";
    private static final String USER_AGENT = "unirest-java/3.0.00";
    private static final Map<HttpMethod, Function<String, HttpRequestBase>> FACTORIES = new HashMap<HttpMethod, Function<String, HttpRequestBase>>();
    private final HttpRequest request;
    private Config config;
    private final boolean async;

    RequestPrep(HttpRequest request, Config config, boolean async) {
        this.request = request;
        this.config = config;
        this.async = async;
    }

    HttpRequestBase prepare() {
        HttpRequestBase reqObj = this.getHttpRequestBase();
        this.setBody(reqObj);
        return reqObj;
    }

    private HttpRequestBase getHttpRequestBase() {
        if (!this.request.getHeaders().containsKey(USER_AGENT_HEADER)) {
            this.request.header(USER_AGENT_HEADER, USER_AGENT);
        }
        if (!this.request.getHeaders().containsKey(ACCEPT_ENCODING_HEADER) && this.config.isRequestCompressionOn()) {
            this.request.header(ACCEPT_ENCODING_HEADER, "gzip");
        }
        try {
            String url = this.request.getUrl();
            HttpRequestBase reqObj = (HttpRequestBase)FACTORIES.computeIfAbsent(this.request.getHttpMethod(), this::register).apply(url);
            this.request.getHeaders().all().stream().map(this::toEntries).forEach(arg_0 -> ((HttpRequestBase)reqObj).addHeader(arg_0));
            reqObj.setConfig(this.overrideConfig());
            return reqObj;
        }
        catch (RuntimeException e) {
            throw new UnirestException(e);
        }
    }

    private RequestConfig overrideConfig() {
        return RequestConfig.custom().setConnectTimeout(this.request.getConnectTimeout()).setSocketTimeout(this.request.getSocketTimeout()).setConnectionRequestTimeout(this.request.getSocketTimeout()).setProxy(RequestOptions.toApacheProxy(this.request.getProxy())).setCookieSpec(this.config.getCookieSpec()).build();
    }

    private Function<String, HttpRequestBase> register(HttpMethod method) {
        return u -> new ApacheRequestWithBody(method, (String)u);
    }

    private org.apache.http.Header toEntries(Header k) {
        return new BasicHeader(k.getName(), k.getValue());
    }

    private void setBody(HttpRequestBase reqObj) {
        if (this.request.getBody().isPresent()) {
            ApacheBodyMapper mapper = new ApacheBodyMapper(this.request);
            HttpEntity entity = mapper.apply();
            if (this.async) {
                if (reqObj.getHeaders(CONTENT_TYPE) == null || reqObj.getHeaders(CONTENT_TYPE).length == 0) {
                    reqObj.setHeader(entity.getContentType());
                }
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    entity.writeTo((OutputStream)output);
                    NByteArrayEntity en = new NByteArrayEntity(output.toByteArray());
                    ((HttpEntityEnclosingRequestBase)reqObj).setEntity((HttpEntity)en);
                }
                catch (IOException e) {
                    throw new UnirestException(e);
                }
            } else {
                ((HttpEntityEnclosingRequestBase)reqObj).setEntity(entity);
            }
        }
    }

    static {
        FACTORIES.put(HttpMethod.GET, HttpGet::new);
        FACTORIES.put(HttpMethod.POST, HttpPost::new);
        FACTORIES.put(HttpMethod.PUT, HttpPut::new);
        FACTORIES.put(HttpMethod.DELETE, ApacheDeleteWithBody::new);
        FACTORIES.put(HttpMethod.PATCH, ApachePatchWithBody::new);
        FACTORIES.put(HttpMethod.OPTIONS, HttpOptions::new);
        FACTORIES.put(HttpMethod.HEAD, HttpHead::new);
    }
}

