/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Collectors;
import kong.unirest.core.Body;
import kong.unirest.core.BodyPart;
import kong.unirest.core.ByteArrayPart;
import kong.unirest.core.FilePart;
import kong.unirest.core.HttpRequest;
import kong.unirest.core.InputStreamPart;
import kong.unirest.core.MultipartMode;
import kong.unirest.core.ParamPart;
import kong.unirest.core.UnirestException;
import kong.unirest.core.java.MonitorWrapper;
import kong.unirest.core.java.MultipartBodyPublisher;
import kong.unirest.core.java.PartPublisher;

class BodyBuilder {
    public static final Charset ASCII = StandardCharsets.US_ASCII;
    private final HttpRequest request;

    BodyBuilder(HttpRequest request) {
        this.request = request;
    }

    HttpRequest.BodyPublisher getBody() {
        Optional<Body> body = this.request.getBody();
        return body.map(o -> this.toPublisher((Body)o)).orElseGet(HttpRequest.BodyPublishers::noBody);
    }

    private HttpRequest.BodyPublisher toPublisher(Body o) {
        if (o.isEntityBody()) {
            return this.mapToUniBody(o);
        }
        return this.mapToMultipart(o);
    }

    private HttpRequest.BodyPublisher mapToMultipart(Body o) {
        try {
            if (o.multiParts().isEmpty()) {
                this.setContentAsFormEncoding(o);
                return HttpRequest.BodyPublishers.noBody();
            }
            if (!o.isMultiPart()) {
                this.setContentAsFormEncoding(o);
                return HttpRequest.BodyPublishers.ofString(this.toFormParams(o));
            }
            MultipartBodyPublisher.Builder builder = MultipartBodyPublisher.newBuilder(o.getBoundary());
            o.multiParts().forEach(part -> this.setMultiPart(o, builder, (BodyPart)part));
            MultipartBodyPublisher build = builder.build(o.getMonitor());
            this.request.header("Content-Type", "multipart/form-data; boundary=" + build.boundary() + ";charset=" + String.valueOf(o.getCharset()));
            return build;
        }
        catch (Exception e) {
            throw new UnirestException(e);
        }
    }

    private void setContentAsFormEncoding(Body o) {
        Object content = "application/x-www-form-urlencoded";
        if (o.getCharset() != null) {
            content = (String)content + "; charset=" + o.getCharset().toString();
        }
        if (!this.alreadyHasMultiPartHeader()) {
            this.request.header("Content-Type", (String)content);
        }
    }

    private boolean alreadyHasMultiPartHeader() {
        return this.request.getHeaders().containsKey("Content-Type");
    }

    private String toFormParams(Body o) {
        return o.multiParts().stream().filter(p -> p instanceof ParamPart).map(p -> (ParamPart)p).map(p -> this.toPair((ParamPart)p, o)).collect(Collectors.joining("&"));
    }

    private String toPair(ParamPart p, Body o) {
        try {
            String encoding = o.getCharset() == null ? "UTF-8" : o.getCharset().toString();
            return String.format("%s=%s", p.getName(), URLEncoder.encode((String)p.getValue(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnirestException(e);
        }
    }

    private void setMultiPart(Body o, MultipartBodyPublisher.Builder builder, BodyPart part) {
        String contentType = part.getContentType();
        if (part.isFile()) {
            if (part instanceof FilePart) {
                try {
                    builder.filePart(part.getName(), ((File)part.getValue()).toPath(), contentType);
                }
                catch (FileNotFoundException e) {
                    throw new UnirestException(e);
                }
            } else if (part instanceof InputStreamPart) {
                if (part.getFileName() != null) {
                    builder.formPart(part.getName(), this.standardizeName(part, o.getMode()), new PartPublisher(HttpRequest.BodyPublishers.ofInputStream(() -> (InputStream)part.getValue()), contentType), contentType);
                } else {
                    builder.formPart(part.getName(), new PartPublisher(HttpRequest.BodyPublishers.ofInputStream(() -> (InputStream)part.getValue()), contentType), contentType);
                }
            } else if (part instanceof ByteArrayPart) {
                builder.formPart(part.getName(), this.standardizeName(part, o.getMode()), new PartPublisher(HttpRequest.BodyPublishers.ofByteArray((byte[])part.getValue()), contentType), contentType);
            }
        } else {
            builder.textPart(part.getName(), String.valueOf(part.getValue()), contentType);
        }
    }

    private String standardizeName(BodyPart part, MultipartMode mode) {
        if (mode.equals((Object)MultipartMode.STRICT)) {
            return part.getFileName().chars().mapToObj(c -> {
                if (!ASCII.newEncoder().canEncode((char)c)) {
                    return Character.valueOf('?');
                }
                return Character.valueOf((char)c);
            }).map(c -> c.toString()).collect(Collectors.joining());
        }
        return part.getFileName();
    }

    private HttpRequest.BodyPublisher mapToUniBody(Body b) {
        BodyPart bodyPart = b.uniPart();
        if (bodyPart == null) {
            return HttpRequest.BodyPublishers.noBody();
        }
        if (String.class.isAssignableFrom(bodyPart.getPartType())) {
            return this.createStringBody(b, bodyPart);
        }
        if (InputStream.class.isAssignableFrom(bodyPart.getPartType())) {
            return this.createInputStreamBody(b, bodyPart);
        }
        return HttpRequest.BodyPublishers.ofByteArray((byte[])bodyPart.getValue());
    }

    private HttpRequest.BodyPublisher createInputStreamBody(Body b, BodyPart bodyPart) {
        if (b.getMonitor() != null) {
            return HttpRequest.BodyPublishers.ofInputStream(() -> new MonitorWrapper((InputStream)bodyPart.getValue(), b.getMonitor()));
        }
        return HttpRequest.BodyPublishers.ofInputStream(() -> (InputStream)bodyPart.getValue());
    }

    private HttpRequest.BodyPublisher createStringBody(Body b, BodyPart bodyPart) {
        Charset charset = b.getCharset();
        if (charset == null) {
            return HttpRequest.BodyPublishers.ofString((String)bodyPart.getValue());
        }
        return HttpRequest.BodyPublishers.ofString((String)bodyPart.getValue(), charset);
    }
}

