/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kong.unirest.core.Headers;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.UnirestException;
import kong.unirest.core.Util;

class RetryAfter {
    private static final Set<Integer> RETRY_CODES = Set.of(Integer.valueOf(429), Integer.valueOf(503), Integer.valueOf(529), Integer.valueOf(301));
    private static final String RETRY_AFTER = "Retry-After";
    private static final RetryAfter EMPTY = new RetryAfter(0L);
    private long millies;

    RetryAfter(Long millies) {
        this.millies = millies;
    }

    static RetryAfter from(HttpResponse response) {
        return RetryAfter.from(response.getHeaders());
    }

    static RetryAfter from(Headers response) {
        String value = response.getFirst(RETRY_AFTER);
        return RetryAfter.tryAsDouble(value).orElseGet(() -> RetryAfter.tryAsDateTime(value));
    }

    boolean isRetriable(HttpResponse response) {
        return RETRY_CODES.contains(response.getStatus()) && response.getHeaders().containsKey(RETRY_AFTER);
    }

    private static RetryAfter tryAsDateTime(String value) {
        ZonedDateTime zdt = Util.tryParseToDate(value);
        if (zdt == null) {
            return EMPTY;
        }
        Instant now = Util.now();
        long diff = ChronoUnit.MILLIS.between(now, zdt.toInstant());
        return new RetryAfter(diff);
    }

    private static Optional<RetryAfter> tryAsDouble(String s) {
        try {
            long millies = RetryAfter.parse(s);
            return Optional.of(new RetryAfter(millies));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    private static long parse(String s) {
        if (s.contains(".")) {
            double d = Double.parseDouble(s);
            return Math.round(d * 1000.0);
        }
        return Long.parseLong(s) * 1000L;
    }

    long millies() {
        return this.millies;
    }

    void waitForIt() {
        try {
            TimeUnit.MILLISECONDS.sleep(this.millies);
        }
        catch (InterruptedException e) {
            throw new UnirestException(e);
        }
    }

    boolean canWait() {
        return this.millies > 0L;
    }
}

