/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.io.FileInputStream;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import kong.unirest.core.Cache;
import kong.unirest.core.CacheManager;
import kong.unirest.core.Client;
import kong.unirest.core.CompoundInterceptor;
import kong.unirest.core.Cookie;
import kong.unirest.core.Headers;
import kong.unirest.core.Interceptor;
import kong.unirest.core.NoopMetric;
import kong.unirest.core.ObjectMapper;
import kong.unirest.core.Proxy;
import kong.unirest.core.UniMetric;
import kong.unirest.core.UnirestConfigException;
import kong.unirest.core.UnirestException;
import kong.unirest.core.Util;
import kong.unirest.core.java.JavaClient;
import kong.unirest.core.json.CoreFactory;

public class Config {
    public static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    private Optional<Client> client = Optional.empty();
    private Supplier<ObjectMapper> objectMapper;
    private Executor customExecutor;
    private Headers headers;
    private Proxy proxy;
    private int connectionTimeout;
    private boolean followRedirects;
    private boolean cookieManagement;
    private boolean useSystemProperties;
    private String defaultResponseEncoding = StandardCharsets.UTF_8.name();
    private Function<Config, Client> clientBuilder;
    private boolean requestCompressionOn = true;
    private boolean automaticRetries;
    private boolean verifySsl = true;
    private KeyStore keystore;
    private Supplier<String> keystorePassword = () -> null;
    private String cookieSpec;
    private UniMetric metrics = new NoopMetric();
    private long ttl = -1L;
    private SSLContext sslContext;
    private String[] ciphers;
    private String[] protocols;
    private CompoundInterceptor interceptor = new CompoundInterceptor();
    private String defaultBaseUrl;
    private CacheManager cache;
    private HttpClient.Version version;
    private boolean retry = false;
    private int maxRetries;

    public Config() {
        this.setDefaults();
    }

    private void setDefaults() {
        this.proxy = null;
        this.cache = null;
        this.customExecutor = null;
        this.headers = new Headers();
        this.connectionTimeout = 10000;
        this.followRedirects = true;
        this.useSystemProperties = false;
        this.cookieManagement = true;
        this.requestCompressionOn = true;
        this.automaticRetries = true;
        this.verifySsl = true;
        this.keystore = null;
        this.keystorePassword = null;
        this.sslContext = null;
        this.ciphers = null;
        this.protocols = null;
        this.defaultBaseUrl = null;
        this.interceptor = new CompoundInterceptor();
        this.retry = false;
        this.maxRetries = 10;
        this.objectMapper = () -> CoreFactory.getCore().getObjectMapper();
        try {
            this.clientBuilder = JavaClient::new;
        }
        catch (BootstrapMethodError e) {
            throw new UnirestException("It looks like you are using an older version of Apache Http Client. \nFor security and performance reasons Unirest requires the most recent version. Please upgrade.", e);
        }
    }

    public Config httpClient(Client httpClient) {
        this.client = Optional.ofNullable(httpClient);
        return this;
    }

    public Config httpClient(Function<Config, Client> httpClient) {
        this.clientBuilder = httpClient;
        return this;
    }

    public Config executor(Executor executor) {
        this.customExecutor = executor;
        return this;
    }

    public Config proxy(Proxy value) {
        this.validateClientsNotRunning();
        this.proxy = value;
        return this;
    }

    public Config proxy(String host, int port) {
        return this.proxy(new Proxy(host, port));
    }

    public Config proxy(String host, int port, String username, String password) {
        return this.proxy(new Proxy(host, port, username, password));
    }

    public Config setObjectMapper(ObjectMapper om) {
        this.objectMapper = () -> om;
        return this;
    }

    public Config sslContext(SSLContext ssl) {
        this.verifySecurityConfig(this.keystore);
        this.sslContext = ssl;
        return this;
    }

    public Config ciphers(String ... values) {
        this.ciphers = values;
        return this;
    }

    public Config protocols(String ... values) {
        this.protocols = values;
        return this;
    }

    private void verifySecurityConfig(Object thing) {
        if (thing != null) {
            throw new UnirestConfigException("You may only configure a SSLContext OR a Keystore, but not both");
        }
    }

    public Config clientCertificateStore(KeyStore store, String password) {
        this.verifySecurityConfig(this.sslContext);
        this.keystore = store;
        this.keystorePassword = () -> password;
        return this;
    }

    public Config clientCertificateStore(String fileLocation, String password) {
        this.verifySecurityConfig(this.sslContext);
        try (FileInputStream keyStoreStream = Util.getFileInputStream(fileLocation);){
            this.keystorePassword = () -> password;
            this.keystore = KeyStore.getInstance("PKCS12");
            this.keystore.load(keyStoreStream, this.keystorePassword.get().toCharArray());
        }
        catch (Exception e) {
            throw new UnirestConfigException(e);
        }
        return this;
    }

    public Config connectTimeout(int inMillies) {
        this.validateClientsNotRunning();
        this.connectionTimeout = inMillies;
        return this;
    }

    public Config clearDefaultHeaders() {
        this.headers.clear();
        return this;
    }

    public Config setDefaultBasicAuth(String username, String password) {
        this.headers.replace("Authorization", Util.toBasicAuthValue(username, password));
        return this;
    }

    public Config setDefaultHeader(String name, String value) {
        this.headers.replace(name, value);
        return this;
    }

    public Config setDefaultHeader(String name, Supplier<String> value) {
        this.headers.add(name, value);
        return this;
    }

    public Config addDefaultHeader(String name, String value) {
        this.headers.add(name, value);
        return this;
    }

    public Config addDefaultCookie(String name, String value) {
        return this.addDefaultCookie(new Cookie(name, value));
    }

    public Config addDefaultCookie(Cookie cookie) {
        this.headers.cookie(cookie);
        return this;
    }

    public Config instrumentWith(UniMetric metric) {
        this.metrics = metric;
        return this;
    }

    public Config interceptor(Interceptor value) {
        Objects.requireNonNull(value, "Interceptor may not be null");
        this.interceptor.register(value);
        return this;
    }

    public Config followRedirects(boolean enable) {
        this.validateClientsNotRunning();
        this.followRedirects = enable;
        return this;
    }

    public Config enableCookieManagement(boolean enable) {
        this.validateClientsNotRunning();
        this.cookieManagement = enable;
        return this;
    }

    public Config verifySsl(boolean value) {
        this.verifySsl = value;
        return this;
    }

    public Config useSystemProperties(boolean value) {
        this.useSystemProperties = value;
        return this;
    }

    public Config requestCompression(boolean value) {
        this.requestCompressionOn = value;
        return this;
    }

    public Config automaticRetries(boolean value) {
        this.automaticRetries = value;
        return this;
    }

    public Config cookieSpec(String policy) {
        this.cookieSpec = policy;
        return this;
    }

    public Config cacheResponses(boolean value) {
        this.cache = value ? new CacheManager() : null;
        return this;
    }

    public Config cacheResponses(Cache.Builder value) {
        this.cache = value.build();
        return this;
    }

    public Config setDefaultResponseEncoding(String value) {
        Objects.requireNonNull(value, "Encoding cannot be null");
        this.defaultResponseEncoding = value;
        return this;
    }

    public Config connectionTTL(long duration, TimeUnit unit) {
        this.ttl = unit.toMillis(duration);
        return this;
    }

    public Config retryAfter(boolean value) {
        return this.retryAfter(value, 10);
    }

    public Config retryAfter(boolean value, int maxRetryAttempts) {
        this.retry = value;
        this.maxRetries = maxRetryAttempts;
        return this;
    }

    public Config connectionTTL(Duration duration) {
        this.ttl = duration.toMillis();
        return this;
    }

    public Config version(HttpClient.Version value) {
        this.version = value;
        return this;
    }

    public Config defaultBaseUrl(String value) {
        this.defaultBaseUrl = value;
        return this;
    }

    public Headers getDefaultHeaders() {
        return this.headers;
    }

    public boolean isRunning() {
        return this.client.isPresent();
    }

    public Config reset() {
        this.reset(false);
        return this;
    }

    public void reset(boolean clearOptions) {
        this.client = Optional.empty();
        if (clearOptions) {
            this.setDefaults();
        }
    }

    public Client getClient() {
        if (!this.client.isPresent()) {
            this.buildClient();
        }
        return this.getFinalClient();
    }

    private Client getFinalClient() {
        if (this.cache == null) {
            return this.client.get();
        }
        return this.cache.wrap(this.client.get());
    }

    private synchronized void buildClient() {
        if (!this.client.isPresent()) {
            this.client = Optional.of(this.clientBuilder.apply(this));
        }
    }

    public boolean getEnabledCookieManagement() {
        return this.cookieManagement;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public KeyStore getKeystore() {
        return this.keystore;
    }

    public String getKeyStorePassword() {
        return this.keystorePassword.get();
    }

    public ObjectMapper getObjectMapper() {
        ObjectMapper om = this.objectMapper.get();
        if (om == null) {
            throw new UnirestConfigException("No Object Mapper Configured. Please config one with Unirest.config().setObjectMapper");
        }
        return om;
    }

    private void validateClientsNotRunning() {
        if (this.client.isPresent()) {
            throw new UnirestConfigException("Http Clients are already built in order to build a new config execute Unirest.config().reset() before changing settings. \nThis should be done rarely.");
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public boolean useSystemProperties() {
        return this.useSystemProperties;
    }

    public String getDefaultResponseEncoding() {
        return this.defaultResponseEncoding;
    }

    public boolean isRequestCompressionOn() {
        return this.requestCompressionOn;
    }

    public boolean isAutomaticRetries() {
        return this.automaticRetries;
    }

    public boolean isVerifySsl() {
        return this.verifySsl;
    }

    public String getCookieSpec() {
        return this.cookieSpec;
    }

    public UniMetric getMetric() {
        return this.metrics;
    }

    public long getTTL() {
        return this.ttl;
    }

    public Interceptor getUniInterceptor() {
        return this.interceptor;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public String[] getCiphers() {
        return this.ciphers;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public String getDefaultBaseUrl() {
        return this.defaultBaseUrl;
    }

    public Executor getCustomExecutor() {
        return this.customExecutor;
    }

    public HttpClient.Version getVersion() {
        return this.version;
    }

    public boolean isAutomaticRetryAfter() {
        return this.retry;
    }

    public int maxRetries() {
        return this.maxRetries;
    }
}

