/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFAddressFamilyConfig;
import org.newsclub.net.unix.AFDatagramChannel;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFServerSocketChannel;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketChannel;
import org.newsclub.net.unix.AFSocketPair;
import org.newsclub.net.unix.AFSomeSocket;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.tipc.AFTIPCDatagramChannel;
import org.newsclub.net.unix.tipc.AFTIPCDatagramSocket;
import org.newsclub.net.unix.tipc.AFTIPCProtocolFamily;
import org.newsclub.net.unix.tipc.AFTIPCServerSocket;
import org.newsclub.net.unix.tipc.AFTIPCServerSocketChannel;
import org.newsclub.net.unix.tipc.AFTIPCSocket;
import org.newsclub.net.unix.tipc.AFTIPCSocketChannel;
import org.newsclub.net.unix.tipc.AFTIPCSocketPair;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFTIPCSelectorProvider
extends AFSelectorProvider<AFTIPCSocketAddress> {
    private static final AFTIPCSelectorProvider INSTANCE = new AFTIPCSelectorProvider();
    static final AFAddressFamily<@NonNull AFTIPCSocketAddress> AF_TIPC = AFAddressFamily.registerAddressFamilyImpl((String)"tipc", (AFAddressFamily)AFTIPCSocketAddress.addressFamily(), (AFAddressFamilyConfig)new AFAddressFamilyConfig<AFTIPCSocketAddress>(){

        protected Class<? extends AFSocket<AFTIPCSocketAddress>> socketClass() {
            return AFTIPCSocket.class;
        }

        protected AFSocket.Constructor<AFTIPCSocketAddress> socketConstructor() {
            return AFTIPCSocket::new;
        }

        protected Class<? extends AFServerSocket<AFTIPCSocketAddress>> serverSocketClass() {
            return AFTIPCServerSocket.class;
        }

        protected AFServerSocket.Constructor<AFTIPCSocketAddress> serverSocketConstructor() {
            return AFTIPCServerSocket::new;
        }

        protected Class<? extends AFSocketChannel<AFTIPCSocketAddress>> socketChannelClass() {
            return AFTIPCSocketChannel.class;
        }

        protected Class<? extends AFServerSocketChannel<AFTIPCSocketAddress>> serverSocketChannelClass() {
            return AFTIPCServerSocketChannel.class;
        }

        protected Class<? extends AFDatagramSocket<AFTIPCSocketAddress>> datagramSocketClass() {
            return AFTIPCDatagramSocket.class;
        }

        protected AFDatagramSocket.Constructor<AFTIPCSocketAddress> datagramSocketConstructor() {
            return AFTIPCDatagramSocket::new;
        }

        protected Class<? extends AFDatagramChannel<AFTIPCSocketAddress>> datagramChannelClass() {
            return AFTIPCDatagramChannel.class;
        }
    });

    private AFTIPCSelectorProvider() {
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"})
    public static AFTIPCSelectorProvider getInstance() {
        return INSTANCE;
    }

    public static AFTIPCSelectorProvider provider() {
        return AFTIPCSelectorProvider.getInstance();
    }

    protected <P extends AFSomeSocket> AFSocketPair<P> newSocketPair(P s1, P s2) {
        return new AFTIPCSocketPair<P>(s1, s2);
    }

    public AFTIPCSocketPair<AFTIPCSocketChannel> openSocketChannelPair() throws IOException {
        return (AFTIPCSocketPair)super.openSocketChannelPair();
    }

    public AFTIPCSocketPair<AFTIPCDatagramChannel> openDatagramChannelPair() throws IOException {
        return (AFTIPCSocketPair)super.openDatagramChannelPair();
    }

    protected AFTIPCSocket newSocket() throws IOException {
        return AFTIPCSocket.newInstance();
    }

    public AFTIPCDatagramChannel openDatagramChannel() throws IOException {
        return AFTIPCDatagramSocket.newInstance().getChannel();
    }

    public AFTIPCDatagramChannel openDatagramChannel(ProtocolFamily family) throws IOException {
        return (AFTIPCDatagramChannel)super.openDatagramChannel(family);
    }

    public AFTIPCServerSocketChannel openServerSocketChannel() throws IOException {
        return AFTIPCServerSocket.newInstance().getChannel();
    }

    public AFTIPCServerSocketChannel openServerSocketChannel(SocketAddress sa) throws IOException {
        return AFTIPCServerSocket.bindOn(AFTIPCSocketAddress.unwrap((SocketAddress)sa)).getChannel();
    }

    public AFTIPCSocketChannel openSocketChannel() throws IOException {
        return (AFTIPCSocketChannel)super.openSocketChannel();
    }

    public AFTIPCSocketChannel openSocketChannel(SocketAddress sa) throws IOException {
        return AFTIPCSocket.connectTo(AFTIPCSocketAddress.unwrap((SocketAddress)sa)).getChannel();
    }

    protected ProtocolFamily protocolFamily() {
        return AFTIPCProtocolFamily.TIPC;
    }

    protected AFAddressFamily<@NonNull AFTIPCSocketAddress> addressFamily() {
        return AF_TIPC;
    }
}

