/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.newsclub.net.unix.NamedInteger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFTIPCErrInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ErrorCode errorCode;
    private final int dataLength;

    public AFTIPCErrInfo(ErrorCode errorCode, int dataLength) {
        this.errorCode = errorCode;
        this.dataLength = dataLength;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.errorCode + ";dataLength=" + this.dataLength + ")";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataLength, this.errorCode});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AFTIPCErrInfo other = (AFTIPCErrInfo)obj;
        return this.dataLength == other.dataLength && this.errorCode.equals((Object)other.errorCode);
    }

    static AFTIPCErrInfo of(int[] tipcErrInfo) {
        if (tipcErrInfo == null) {
            return null;
        }
        if (tipcErrInfo.length != 2) {
            throw new IllegalArgumentException();
        }
        return new AFTIPCErrInfo(ErrorCode.ofValue(tipcErrInfo[0]), tipcErrInfo[1]);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NonNullByDefault
    public static final class ErrorCode
    extends NamedInteger {
        private static final long serialVersionUID = 1L;
        public static final ErrorCode TIPC_OK = new ErrorCode("TIPC_OK", 0);
        public static final ErrorCode TIPC_ERR_NO_NAME = new ErrorCode("TIPC_ERR_NO_NAME", 1);
        public static final ErrorCode TIPC_ERR_NO_PORT = new ErrorCode("TIPC_ERR_NO_PORT", 2);
        public static final ErrorCode TIPC_ERR_NO_NODE = new ErrorCode("TIPC_ERR_NO_NODE", 3);
        public static final ErrorCode TIPC_ERR_OVERLOAD = new ErrorCode("TIPC_ERR_OVERLOAD", 4);
        public static final ErrorCode TIPC_ERR_CONN_SHUTDOWN = new ErrorCode("TIPC_ERR_CONN_SHUTDOWN", 5);
        private static final @NonNull ErrorCode[] VALUES = (ErrorCode[])ErrorCode.init((NamedInteger[])new ErrorCode[]{TIPC_OK, TIPC_ERR_NO_NAME, TIPC_ERR_NO_PORT, TIPC_ERR_NO_NODE, TIPC_ERR_OVERLOAD, TIPC_ERR_CONN_SHUTDOWN});

        private ErrorCode(int id) {
            super(id);
        }

        private ErrorCode(String name, int id) {
            super(name, id);
        }

        public static ErrorCode ofValue(int v) {
            return (ErrorCode)ErrorCode.ofValue((NamedInteger[])VALUES, ErrorCode::new, (int)v);
        }
    }
}

