/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.NamedInteger;
import org.newsclub.net.unix.tipc.AFTIPCSocket;
import org.newsclub.net.unix.tipc.AFTIPCTopologySubscription;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NonNullByDefault
public final class AFTIPCTopologyEvent {
    private static final int MESSAGE_LENGTH = 48;
    private final Type type;
    private final int foundLower;
    private final int foundUpper;
    private final AFTIPCSocketAddress address;
    private final AFTIPCTopologySubscription subscription;

    private AFTIPCTopologyEvent(Type type, int foundLower, int foundUpper, AFTIPCSocketAddress address, AFTIPCTopologySubscription subscription) {
        this.type = type;
        this.foundLower = foundLower;
        this.foundUpper = foundUpper;
        this.address = address;
        this.subscription = subscription;
    }

    static AFTIPCTopologyEvent readFromBuffer(ByteBuffer buf) throws SocketException {
        buf = buf.order(ByteOrder.BIG_ENDIAN);
        Type type = Type.ofValue(buf.getInt());
        int foundLower = buf.getInt();
        int foundUpper = buf.getInt();
        AFTIPCSocketAddress address = AFTIPCSocketAddress.ofSocket((int)buf.getInt(), (int)buf.getInt());
        AFTIPCTopologySubscription sub = AFTIPCTopologySubscription.readFromBuffer(buf);
        return new AFTIPCTopologyEvent(type, foundLower, foundUpper, address, sub);
    }

    public String toString() {
        int upper;
        int lower = this.getFoundLower();
        Object found = lower == (upper = this.getFoundUpper()) ? AFTIPCSocketAddress.AddressType.formatTIPCInt((int)lower) : AFTIPCSocketAddress.AddressType.formatTIPCInt((int)lower) + "-" + AFTIPCSocketAddress.AddressType.formatTIPCInt((int)upper);
        return super.toString() + "[" + String.valueOf((Object)this.getType()) + ";found:" + (String)found + ";addr=" + String.valueOf(this.getAddress()) + ";sub=" + String.valueOf(this.getSubscription()) + "]";
    }

    ByteBuffer writeToBuffer(ByteBuffer buf) throws IOException {
        buf = buf.order(ByteOrder.BIG_ENDIAN);
        buf.putInt(this.getType().value());
        buf.putInt(this.getFoundLower());
        buf.putInt(this.getFoundUpper());
        this.getAddress().writeNativeAddressTo(buf);
        this.getSubscription().writeToBuffer(buf);
        return buf;
    }

    public ByteBuffer toBuffer() throws IOException {
        return this.writeToBuffer(ByteBuffer.allocate(48)).flip();
    }

    public Type getType() {
        return this.type;
    }

    public int getFoundLower() {
        return this.foundLower;
    }

    public int getFoundUpper() {
        return this.foundUpper;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AFTIPCSocketAddress getAddress() {
        return this.address;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AFTIPCTopologySubscription getSubscription() {
        return this.subscription;
    }

    public boolean isPublished() {
        return this.type == Type.TIPC_PUBLISHED;
    }

    public boolean isWithdrawn() {
        return this.type == Type.TIPC_WITHDRAWN;
    }

    public boolean isTimeout() {
        return this.type == Type.TIPC_SUBSCR_TIMEOUT;
    }

    public boolean isPort() {
        return this.subscription.isPort();
    }

    public boolean isService() {
        return this.subscription.isService();
    }

    public boolean isCancellationRequest() {
        return this.subscription.isCancellation();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.foundLower, this.foundUpper, this.subscription, this.type});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AFTIPCTopologyEvent)) {
            return false;
        }
        AFTIPCTopologyEvent other = (AFTIPCTopologyEvent)obj;
        return Objects.equals(this.address, other.address) && this.foundLower == other.foundLower && this.foundUpper == other.foundUpper && Objects.equals(this.subscription, other.subscription) && Objects.equals((Object)this.type, (Object)other.type);
    }

    public @Nullable String getLinkName() throws IOException {
        int node = this.getFoundLower();
        int ref = this.getAddress().getTIPCRef();
        return AFTIPCSocket.getLinkName(node, ref & 0xFFFF);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Type
    extends NamedInteger {
        private static final long serialVersionUID = 1L;
        public static final Type TIPC_PUBLISHED;
        public static final Type TIPC_WITHDRAWN;
        public static final Type TIPC_SUBSCR_TIMEOUT;
        public static final Type UNDEFINED;
        private static final @NonNull Type[] VALUES;

        private Type(int id) {
            super(id);
        }

        private Type(String name, int id) {
            super(name, id);
        }

        public static Type ofValue(int v) {
            return (Type)Type.ofValue((NamedInteger[])VALUES, Type::new, (int)v);
        }

        static {
            UNDEFINED = new Type("UNDEFINED", 0);
            TIPC_PUBLISHED = new Type("TIPC_PUBLISHED", 1);
            TIPC_WITHDRAWN = new Type("TIPC_WITHDRAWN", 2);
            TIPC_SUBSCR_TIMEOUT = new Type("TIPC_SUBSCR_TIMEOUT", 3);
            VALUES = (Type[])Type.init((NamedInteger[])new Type[]{UNDEFINED, TIPC_PUBLISHED, TIPC_WITHDRAWN, TIPC_SUBSCR_TIMEOUT});
        }
    }
}

