/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.newsclub.net.unix.ssl.BuilderSSLSocket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class BuilderSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory factory;
    private final SSLParameters defaultParams;
    private final boolean clientMode;
    private final SSLContext context;
    private final SocketFactory underlyingSocketFactory;

    BuilderSSLSocketFactory(boolean clientMode, SSLContext context, SSLSocketFactory factory, SSLParameters defaultParams, SocketFactory socketFactory) {
        this.clientMode = clientMode;
        this.context = context;
        this.factory = factory;
        this.defaultParams = defaultParams;
        this.underlyingSocketFactory = socketFactory;
    }

    SSLContext getContext() {
        return this.context;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.defaultParams.getCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    private SSLSocket init(SSLSocket socket) {
        socket.setSSLParameters(this.defaultParams);
        socket.setUseClientMode(this.clientMode);
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.init(new BuilderSSLSocket((SSLSocket)this.factory.createSocket(s, host, port, autoClose), s, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.underlyingSocketFactory.createSocket(host, port);
        return this.createSocket(socket, host, port, true);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.underlyingSocketFactory.createSocket(host, port, localHost, localPort);
        return this.createSocket(socket, host, port, true);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.underlyingSocketFactory.createSocket(host, port);
        return this.createSocket(socket, host.getHostName(), port, true);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.underlyingSocketFactory.createSocket(address, port, localAddress, localPort);
        return this.createSocket(socket, address.getHostName(), port, true);
    }

    @Override
    public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
        return this.init(new BuilderSSLSocket((SSLSocket)this.factory.createSocket(s, consumed, autoClose), s, autoClose));
    }

    @Override
    public Socket createSocket() throws IOException {
        throw (SocketException)new SocketException("Unconnected sockets not implemented").initCause(new UnsupportedOperationException());
    }
}

