/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.KnownJavaBugIOException;
import org.newsclub.net.unix.ssl.BuilderSSLContext;
import org.newsclub.net.unix.ssl.SSLFunction;
import org.newsclub.net.unix.ssl.SSLSupplier;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SSLContextBuilder {
    private static final Provider PROVIDER_PKCS12 = AFSocket.isRunningOnAndroid() ? SSLContextBuilder.bouncyCastleInstanceIfPossible() : null;
    private static final Provider PROVIDER_JSSE = AFSocket.isRunningOnAndroid() ? SSLContextBuilder.bouncyCastleJSSEInstanceIfPossible() : null;
    private static final String DEFAULT_PROVIDER = AFSocket.isRunningOnAndroid() && PROVIDER_JSSE != null ? "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider,org.bouncycastle.jce.provider.BouncyCastleProvider" : null;
    private final boolean clientMode;
    private String protocol = "TLS";
    private SecureRandom secureRandom = null;
    private URL keyStoreUrl;
    private SSLSupplier<char[]> keyStorePassword;
    private URL trustManagerUrl;
    private SSLSupplier<char[]> trustManagerPassword;
    private Function<SSLParameters, SSLParameters> parametersFunction = null;
    private SSLSupplier<KeyStore> keyStoreSupplier = SSLContextBuilder::newKeyStorePKCS12;
    private SSLFunction<KeyManagerFactory, KeyManager[]> keyManager = null;
    private SSLFunction<TrustManagerFactory, TrustManager[]> trustManager = null;
    private Object provider = DEFAULT_PROVIDER;
    private SocketFactory socketFactory = SocketFactory.getDefault();

    private SSLContextBuilder(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public static SSLContextBuilder forServer() {
        return new SSLContextBuilder(false);
    }

    public static SSLContextBuilder forClient() {
        return new SSLContextBuilder(true);
    }

    public SSLContextBuilder withSocketFactory(SocketFactory sf) {
        this.socketFactory = sf == null ? SocketFactory.getDefault() : sf;
        return this;
    }

    public SSLContextBuilder withProtocol(String p) {
        this.protocol = p;
        return this;
    }

    public SSLContextBuilder withProvider(Provider p) {
        this.provider = p;
        return this;
    }

    public SSLContextBuilder withProvider(String id) {
        this.provider = id.isEmpty() ? null : id;
        return this;
    }

    public SSLContextBuilder withKeyManagers(SSLFunction<KeyManagerFactory, KeyManager[]> s) {
        if (this.keyStoreUrl != null) {
            throw new IllegalStateException("withKeyStore was already called");
        }
        this.keyManager = s;
        return this;
    }

    public SSLContextBuilder withTrustManagers(SSLFunction<TrustManagerFactory, TrustManager[]> s) {
        if (this.trustManagerUrl != null) {
            throw new IllegalStateException("withTrustStore was already called");
        }
        this.trustManager = s;
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public SSLContextBuilder withSecureRandom(SecureRandom s) {
        this.secureRandom = s;
        return this;
    }

    public SSLContextBuilder withKeyStoreSupplier(SSLSupplier<KeyStore> supplier) {
        this.keyStoreSupplier = supplier == null ? SSLContextBuilder::newKeyStorePKCS12 : supplier;
        return this;
    }

    public SSLContextBuilder withKeyStore(File path, SSLSupplier<char[]> password) throws FileNotFoundException, MalformedURLException {
        return this.withKeyStore(path.toURI().toURL(), password);
    }

    public SSLContextBuilder withKeyStore(URL url, SSLSupplier<char[]> password) throws FileNotFoundException {
        if (this.keyManager != null) {
            throw new IllegalStateException("withKeyManagers was already called");
        }
        this.keyStoreUrl = Objects.requireNonNull(url);
        this.keyStorePassword = password;
        this.keyManager = this::buildKeyManagers;
        return this;
    }

    public SSLContextBuilder withTrustStore(File path, SSLSupplier<char[]> password) throws FileNotFoundException, MalformedURLException {
        return this.withTrustStore(path.toURI().toURL(), password);
    }

    public SSLContextBuilder withTrustStore(URL url, SSLSupplier<char[]> password) throws FileNotFoundException {
        if (this.trustManager != null) {
            throw new IllegalStateException("withTrustManagers was already called");
        }
        this.trustManagerUrl = Objects.requireNonNull(url, "trustStore");
        this.trustManagerPassword = password;
        return this;
    }

    public SSLContextBuilder withDefaultSSLParameters(Function<SSLParameters, SSLParameters> function) {
        if (this.parametersFunction != null) {
            throw new IllegalStateException("Default parameters already set");
        }
        this.parametersFunction = function;
        return this;
    }

    public SSLContextBuilder withDefaultSSLParameters(Consumer<SSLParameters> consumer) {
        return this.withDefaultSSLParameters((SSLParameters p) -> {
            consumer.accept((SSLParameters)p);
            return p;
        });
    }

    private KeyManagerFactory buildKeyManagerFactory() throws GeneralSecurityException {
        return KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
    }

    private TrustManagerFactory buildTrustManagerFactory() throws GeneralSecurityException {
        return TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
    }

    private KeyManager[] buildKeyManagers(KeyManagerFactory kmf) throws GeneralSecurityException, IOException, UnrecoverableKeyException {
        if (this.keyStoreUrl == null) {
            return null;
        }
        KeyStore ks = this.keyStoreSupplier.get();
        char[] password = this.keyStorePassword == null ? null : this.keyStorePassword.get();
        try (InputStream in = this.keyStoreUrl.openStream();){
            ks.load(in, password);
            kmf.init(ks, password);
        }
        catch (IOException e) {
            throw SSLContextBuilder.wrapIOExceptionIfJDKBug(e);
        }
        finally {
            SSLContextBuilder.clear(password);
        }
        return kmf.getKeyManagers();
    }

    public static IOException wrapIOExceptionIfJDKBug(IOException e) {
        String msg = e.getMessage();
        if (msg == null) {
            return e;
        }
        if (msg.contains("data isn't an object ID (tag = 48)")) {
            return SSLContextBuilder.knownJDKBug(e, "JDK-8202837", "8u312", "11.0.3");
        }
        if (msg.contains("HmacPBESHA256 not available")) {
            return SSLContextBuilder.knownJDKBug(e, "JDK-8267701", "8u301", "11.0.12", "alternatively try running Java with -Dkeystore.pkcs12.legacy");
        }
        if (msg.contains("HmacPBESHA256")) {
            String vmVersion;
            if ("IBM J9 VM".equals(System.getProperty("java.vm.name")) && (vmVersion = System.getProperty("java.runtime.version", "")).startsWith("8.0.") && vmVersion.compareTo("8.0.8.") < 0) {
                return new KnownJavaBugIOException("Bug JDK-8267701 detected -- please upgrade your Java release to at least IBM SDK 8.0.8.0; details here: https://www.ibm.com/support/pages/troubleshooting-unable-open-pkcs12-keystores-due-unrecoverablekeyexception", (Throwable)e);
            }
            return new KnownJavaBugIOException("Bug JDK-8267701 detected -- please upgrade your Java release; alternatively try running Java with -Dkeystore.pkcs12.legacy", (Throwable)e);
        }
        return e;
    }

    private static KnownJavaBugIOException knownJDKBug(Exception e, String bugId, String java8Version, String java11Version) {
        return SSLContextBuilder.knownJDKBug(e, bugId, java8Version, java11Version, null);
    }

    private static KnownJavaBugIOException knownJDKBug(Exception e, String bugId, String java8Version, String java11Version, String hint) {
        hint = hint == null ? "" : "; " + hint;
        String specVersion = System.getProperty("java.specification.version", "");
        if (specVersion.startsWith("1.")) {
            return new KnownJavaBugIOException("Bug " + bugId + " detected -- please upgrade to Java " + java8Version + " or newer" + hint, (Throwable)e);
        }
        if ("9".equals(specVersion) || "10".equals(specVersion) || "11".equals(specVersion)) {
            return new KnownJavaBugIOException("Bug " + bugId + " detected -- please upgrade to Java " + java11Version + " or newer" + hint, (Throwable)e);
        }
        return new KnownJavaBugIOException("Bug " + bugId + " detected -- please upgrade your Java release" + hint, (Throwable)e);
    }

    private TrustManager[] buildTrustManagers(TrustManagerFactory tmf) throws IOException, GeneralSecurityException {
        if (this.trustManagerUrl == null) {
            return null;
        }
        KeyStore ks = this.keyStoreSupplier.get();
        char[] password = this.trustManagerPassword == null ? null : this.trustManagerPassword.get();
        try (InputStream in = this.trustManagerUrl.openStream();){
            ks.load(in, password);
        }
        catch (IOException e) {
            throw SSLContextBuilder.wrapIOExceptionIfJDKBug(e);
        }
        finally {
            SSLContextBuilder.clear(password);
        }
        tmf.init(ks);
        return tmf.getTrustManagers();
    }

    private static void clear(char[] password) {
        if (password == null) {
            return;
        }
        Arrays.fill(password, ' ');
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    private static SSLContext tryInitContextFallback(NoSuchProviderException e, String protocol, String providerString) throws NoSuchAlgorithmException, NoSuchProviderException {
        try {
            ArrayList<Provider> providers = new ArrayList<Provider>();
            for (String pn : providerString.split(",")) {
                Class<?> klazz;
                if ((pn = pn.trim()).isEmpty() || !Provider.class.isAssignableFrom(klazz = Class.forName(pn))) continue;
                Provider p = (Provider)klazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                providers.add(p);
                try {
                    Security.addProvider(p);
                }
                catch (NullPointerException | SecurityException e1) {
                    e.addSuppressed(e1);
                }
            }
            if (providers.isEmpty()) {
                throw e;
            }
            return SSLContext.getInstance(protocol, Objects.requireNonNull((Provider)providers.get(0)).getName());
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e1) {
            e.addSuppressed(e1);
            throw e;
        }
    }

    public SSLContext build() throws GeneralSecurityException, IOException {
        SSLFunction<TrustManagerFactory, TrustManager[]> tm;
        SSLContext sslContext;
        if (this.provider == null) {
            sslContext = SSLContext.getInstance(this.protocol);
        } else if (this.provider instanceof String) {
            String providerString = (String)this.provider;
            try {
                sslContext = SSLContext.getInstance(this.protocol, providerString);
            }
            catch (NoSuchProviderException e) {
                sslContext = SSLContextBuilder.tryInitContextFallback(e, this.protocol, providerString);
            }
        } else {
            sslContext = SSLContext.getInstance(this.protocol, (Provider)this.provider);
        }
        SSLFunction<KeyManagerFactory, KeyManager[]> km = this.keyManager;
        if (km == null) {
            km = this::buildKeyManagers;
        }
        if ((tm = this.trustManager) == null) {
            tm = this::buildTrustManagers;
        }
        KeyManager[] kms = km.apply(this.buildKeyManagerFactory());
        TrustManager[] tms = tm.apply(this.buildTrustManagerFactory());
        BuilderSSLContext.initContext(sslContext, kms, tms, this.secureRandom);
        return new BuilderSSLContext(this.clientMode, sslContext, this.parametersFunction, this.socketFactory);
    }

    public SSLContext buildAndDestroyBuilder() throws GeneralSecurityException, IOException, DestroyFailedException {
        try {
            SSLContext context = this.build();
            this.destroy();
            return context;
        }
        catch (IOException e) {
            throw SSLContextBuilder.wrapIOExceptionIfJDKBug(e);
        }
    }

    public void destroy() throws DestroyFailedException {
        DestroyFailedException dfe = null;
        for (Object o : new Object[]{this.keyStorePassword, this.trustManagerPassword, this.keyManager, this.trustManager}) {
            Destroyable d;
            if (!(o instanceof Destroyable) || (d = (Destroyable)o).isDestroyed()) continue;
            try {
                d.destroy();
            }
            catch (DestroyFailedException e) {
                if (dfe == null) {
                    dfe = e;
                    continue;
                }
                dfe.addSuppressed(e);
            }
        }
        this.keyStoreUrl = null;
        this.keyStorePassword = null;
        this.keyManager = null;
        this.trustManagerUrl = null;
        this.trustManagerPassword = null;
        this.trustManager = null;
        this.parametersFunction = null;
        this.secureRandom = null;
        if (dfe != null) {
            throw dfe;
        }
    }

    private static Provider resolveProviderIfPossible(String className) {
        Class<?> klazz;
        try {
            klazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            return (Provider)klazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Cannot instantiate provider '" + className + "', despite being on the classpath", e);
        }
    }

    private static Provider bouncyCastleInstanceIfPossible() {
        return SSLContextBuilder.resolveProviderIfPossible("org.bouncycastle.jce.provider.BouncyCastleProvider");
    }

    private static Provider bouncyCastleJSSEInstanceIfPossible() {
        return SSLContextBuilder.resolveProviderIfPossible("org.bouncycastle.jsse.provider.BouncyCastleJsseProvider");
    }

    public static KeyStore newKeyStorePKCS12() throws KeyStoreException {
        if (PROVIDER_PKCS12 == null) {
            return KeyStore.getInstance("PKCS12");
        }
        return KeyStore.getInstance("PKCS12", PROVIDER_PKCS12);
    }
}

