/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.selftest.apps;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ExecutionException;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFOutputStream;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketChannel;
import org.newsclub.net.unix.selftest.apps.SocketAddressUtil;
import org.newsclub.net.unix.server.AFSocketServer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ZeroServer {
    private static void printHelp() {
        System.err.println("Syntax: java " + ZeroServer.class.getName() + " <URI>");
        System.err.println();
        System.err.println("Supported schemes: " + AFAddressFamily.uriSchemes());
    }

    public static void main(String[] args) throws IOException, InterruptedException, ExecutionException {
        AFSocketAddress address;
        if (args.length == 0) {
            ZeroServer.printHelp();
            System.exit(1);
            return;
        }
        try {
            address = SocketAddressUtil.parseAddress(args[0]);
        }
        catch (Exception e) {
            ZeroServer.printHelp();
            System.err.println();
            e.printStackTrace();
            System.exit(1);
            return;
        }
        new AFSocketServer<AFSocketAddress>(address){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doServeSocket(AFSocket<?> sock) throws IOException {
                Object object;
                StringBuilder stringBuilder;
                System.out.println("Connected: " + sock);
                long numBytes = -1L;
                try {
                    block23: {
                        File devZeroFile = new File("/dev/zero");
                        if (devZeroFile.exists() && Boolean.parseBoolean(System.getProperty("useDevZero", "true"))) {
                            System.out.println("Streaming /dev/zero");
                            try (FileInputStream fin = new FileInputStream(devZeroFile);
                                 AFOutputStream out = sock.getOutputStream();){
                                numBytes = out.transferFrom((InputStream)fin);
                                break block23;
                            }
                        }
                        System.out.println("Streaming empty ByteBuffer");
                        ByteBuffer buf = ByteBuffer.allocate(8192);
                        sock.setSendBufferSize(8192);
                        sock.setSoTimeout(1);
                        numBytes = 0L;
                        try (AFSocketChannel out = sock.getChannel();){
                            while (!Thread.interrupted()) {
                                numBytes += (long)out.write(buf);
                                buf.rewind();
                            }
                        }
                        catch (ClosedChannelException closedChannelException) {
                            // empty catch block
                        }
                    }
                    stringBuilder = new StringBuilder().append("Disconnected: ").append(sock).append("; written bytes: ");
                    object = numBytes == -1L ? "unknown" : Long.valueOf(numBytes);
                }
                catch (Throwable throwable) {
                    System.out.println("Disconnected: " + sock + "; written bytes: " + (numBytes == -1L ? "unknown" : Long.valueOf(numBytes)));
                    throw throwable;
                }
                System.out.println(stringBuilder.append(object).toString());
            }
        }.startAndWaitToBecomeReady();
        System.out.println("Server ready, listening on " + address);
    }
}

